/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.client.gui.WindowHutWorkerPlaceholder;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobPlaceholder;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingBlacksmith
extends AbstractBuildingWorker {
    private static final String BLACKSMITH = "Blacksmith";
    private static final String BLACKSMITH_HUT_NAME = "blacksmithHut";
    private static final int MAX_BUILDING_LEVEL = 3;

    public BuildingBlacksmith(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BLACKSMITH;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 3;
    }

    @Override
    @NotNull
    public String getJobName() {
        return BLACKSMITH;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobPlaceholder(citizen);
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerPlaceholder<View>(this, BuildingBlacksmith.BLACKSMITH_HUT_NAME);
        }
    }
}

