/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.client.gui.WindowHutBuilder;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.NotNull;

public class BuildingBuilder
extends AbstractBuildingWorker {
    public static final int MAX_BUILDING_LEVEL = 5;
    private static final String BUILDER = "Builder";
    private static final String TAG_RESOURCE_LIST = "resources";
    private static final String TAG_AMOUNT = "amount";
    private HashMap<Block, Integer> neededResources = new HashMap();

    public BuildingBuilder(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BUILDER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().triggerAchievement(ModAchievements.achievementBuildingBuilder);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().triggerAchievement(ModAchievements.achievementUpgradeBuilderMax);
        }
    }

    @Override
    @NotNull
    public String getJobName() {
        return BUILDER;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobBuilder(citizen);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagList neededResTagList = compound.func_150295_c(TAG_RESOURCE_LIST, 10);
        for (int i = 0; i < neededResTagList.func_74745_c(); ++i) {
            NBTTagCompound neededRes = neededResTagList.func_150305_b(i);
            IBlockState state = NBTUtil.func_190008_d((NBTTagCompound)neededRes);
            int amount = neededRes.func_74762_e(TAG_AMOUNT);
            this.neededResources.put(state.func_177230_c(), amount);
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList neededResTagList = new NBTTagList();
        for (Map.Entry<Block, Integer> entry : this.neededResources.entrySet()) {
            NBTTagCompound neededRes = new NBTTagCompound();
            NBTUtil.func_190009_a((NBTTagCompound)neededRes, (IBlockState)entry.getKey().func_176223_P());
            neededRes.func_74768_a(TAG_AMOUNT, entry.getValue().intValue());
            neededResTagList.func_74742_a((NBTBase)neededRes);
        }
        compound.func_74782_a(TAG_RESOURCE_LIST, (NBTBase)neededResTagList);
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.neededResources.size());
        for (Map.Entry<Block, Integer> entry : this.neededResources.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey().func_149732_F());
            buf.writeInt(entry.getValue().intValue());
        }
    }

    public Map<Block, Integer> getNeededResources() {
        return new HashMap<Block, Integer>(this.neededResources);
    }

    public void addNeededResource(Block res, int amount) {
        int preAmount = 0;
        if (this.neededResources.containsKey(res)) {
            preAmount = this.neededResources.get(res);
        }
        this.neededResources.put(res, preAmount + amount);
        this.markDirty();
    }

    public void reduceNeededResource(Block res, int amount) {
        int preAmount = 0;
        if (this.neededResources.containsKey(res)) {
            preAmount = this.neededResources.get(res);
        }
        if (preAmount - amount <= 0) {
            this.neededResources.remove(res);
        } else {
            this.neededResources.put(res, preAmount - amount);
        }
        this.markDirty();
    }

    public void resetNeededResources() {
        this.neededResources = new HashMap();
        this.markDirty();
    }

    public static class View
    extends AbstractBuildingWorker.View {
        private HashMap<String, Integer> neededResources;

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutBuilder(this);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            int size = buf.readInt();
            this.neededResources = new HashMap();
            for (int i = 0; i < size; ++i) {
                String block = ByteBufUtils.readUTF8String((ByteBuf)buf);
                int amount = buf.readInt();
                this.neededResources.put(block, amount);
            }
        }

        public Map<String, Integer> getNeededResources() {
            return new HashMap<String, Integer>(this.neededResources);
        }
    }
}

