/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.materials;

import com.minecolonies.coremod.colony.materials.Material;
import com.minecolonies.coremod.colony.materials.MaterialSystem;
import com.minecolonies.coremod.colony.materials.QuantityNotFound;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaterialStore {
    private static final String TAG_MATERIAL_STORE = "MaterialStore";
    private static final String TAG_DONT_NEED = "HaveDontNeed";
    private static final String TAG_HAVE_NEED = "HaveNeed";
    private static final String TAG_NEED = "NeedDontHave";
    private static final String TAG_ID = "ID";
    private static final String TAG_QUANTITY = "quantity";
    @NotNull
    private final Map<Material, Integer> dontNeed = new HashMap<Material, Integer>();
    @NotNull
    private final Map<Material, Integer> haveNeed = new HashMap<Material, Integer>();
    @NotNull
    private final Map<Material, Integer> need = new HashMap<Material, Integer>();
    private final Type type;
    private final MaterialSystem system;

    public MaterialStore(Type type, @NotNull MaterialSystem system) {
        this.type = type;
        this.system = system;
        system.addStore(this);
    }

    public Type getType() {
        return this.type;
    }

    @NotNull
    public Map<Material, Integer> getNeed() {
        return Collections.unmodifiableMap(this.need);
    }

    @NotNull
    public Map<Material, Integer> getHave() {
        return Collections.unmodifiableMap(this.dontNeed);
    }

    public int getMaterialCount(Material material) {
        Integer count = this.dontNeed.get(material);
        return count == null ? 0 : count;
    }

    public void addMaterial(Item item, int quantity) {
        this.addMaterial(this.system.getMaterial(item), quantity);
    }

    private void addMaterial(@Nullable Material material, int quantity) {
        if (quantity <= 0 || material == null) {
            return;
        }
        Integer count = this.dontNeed.get(material);
        if (count == null) {
            Integer needCount = this.need.get(material);
            if (needCount == null) {
                this.dontNeed.put(material, quantity);
                this.system.addMaterial(material, quantity);
                material.add(this, quantity);
            } else if (quantity < needCount) {
                this.haveNeed.put(material, quantity);
                this.need.put(material, needCount - quantity);
            } else if (quantity == needCount) {
                this.haveNeed.put(material, quantity);
                this.need.remove(material);
            } else {
                this.haveNeed.put(material, needCount);
                this.need.remove(material);
                this.dontNeed.put(material, quantity - needCount);
                this.system.addMaterial(material, quantity - needCount);
                material.add(this, quantity - needCount);
            }
        } else {
            this.dontNeed.put(material, count + quantity);
            this.system.addMaterial(material, quantity);
            material.add(this, quantity);
        }
    }

    public void addMaterial(Block block, int quantity) {
        this.addMaterial(this.system.getMaterial(block), quantity);
    }

    public void removeMaterial(Item item, int quantity) {
        this.removeMaterial(this.system.getMaterial(item), quantity);
    }

    private void removeMaterial(@Nullable Material material, int quantity) {
        if (quantity <= 0 || material == null) {
            return;
        }
        Integer count = this.dontNeed.get(material);
        if (count == null || count < quantity) {
            Integer countNeed = this.haveNeed.get(material);
            if (count == null) {
                if (countNeed == null || countNeed < quantity) {
                    throw new QuantityNotFound("MaterialStore (haveNeed)", material.getID(), countNeed == null ? 0 : countNeed, quantity);
                }
                if (countNeed == quantity) {
                    this.haveNeed.remove(material);
                } else {
                    this.haveNeed.put(material, countNeed - quantity);
                }
            } else {
                int countToRemove = quantity - count;
                if (countNeed == null || countNeed < countToRemove) {
                    throw new QuantityNotFound("MaterialStore (dontNeed+haveNeed)", material.getID(), countNeed == null ? count : countNeed + count, quantity);
                }
                this.removeMaterial(material);
                if (countNeed == countToRemove) {
                    this.haveNeed.remove(material);
                } else {
                    this.haveNeed.put(material, countNeed - countToRemove);
                }
            }
        } else if (count == quantity) {
            this.removeMaterial(material);
        } else {
            this.dontNeed.put(material, count - quantity);
            this.system.removeMaterial(material, quantity);
            material.remove(this, quantity);
        }
    }

    private void removeMaterial(@NotNull Material material) {
        int count = this.dontNeed.get(material);
        this.dontNeed.remove(material);
        this.removeMaterialFromExternal(material, count);
    }

    private void removeMaterialFromExternal(@NotNull Material material, int count) {
        this.system.removeMaterial(material, count);
        material.remove(this);
    }

    public void removeMaterial(Block block, int quantity) {
        this.removeMaterial(this.system.getMaterial(block), quantity);
    }

    public void addNeededMaterial(Item item, int quantity) {
        this.addNeededMaterial(this.system.getMaterial(item), quantity);
    }

    public void addNeededMaterial(Block block, int quantity) {
        this.addNeededMaterial(this.system.getMaterial(block), quantity);
    }

    public void removeNeededMaterial(Item item, int quantity) {
        this.removeNeededMaterial(this.system.getMaterial(item), quantity);
    }

    private void removeNeededMaterial(@Nullable Material material, int quantity) {
        if (quantity <= 0 || material == null) {
            return;
        }
        Integer count = this.haveNeed.get(material);
        if (count != null) {
            if (count > quantity) {
                this.haveNeed.put(material, count - quantity);
                this.addMaterial(material, count - quantity);
            } else {
                if (count < quantity) {
                    this.removeFromNeededMap(material, quantity - count);
                }
                this.haveNeed.remove(material);
                this.addMaterial(material, (int)count);
            }
        } else {
            this.removeFromNeededMap(material, quantity);
        }
    }

    private void removeFromNeededMap(@NotNull Material material, int quantity) {
        Integer count = this.need.get(material);
        if (count == null || count < quantity) {
            throw new QuantityNotFound("MaterialStore (need)", material.getID(), count == null ? 0 : count, quantity);
        }
        if (count == quantity) {
            this.need.remove(material);
        } else {
            this.need.put(material, count - quantity);
        }
    }

    public void removeNeededMaterial(Block block, int quantity) {
        this.removeNeededMaterial(this.system.getMaterial(block), quantity);
    }

    private void addNeededMaterial(@Nullable Material material, int quantity) {
        if (quantity <= 0 || material == null) {
            return;
        }
        Integer count = this.dontNeed.get(material);
        if (count != null) {
            if (count >= quantity) {
                this.haveNeed.put(material, quantity);
                this.removeMaterial(material, quantity);
            } else {
                this.haveNeed.put(material, count);
                this.removeMaterial(material);
                this.need.put(material, quantity - count);
            }
        } else {
            this.need.put(material, quantity);
        }
    }

    public void destroy() {
        this.clear();
        this.system.removeStore(this);
    }

    public void clear() {
        for (Map.Entry<Material, Integer> entry : this.dontNeed.entrySet()) {
            this.removeMaterialFromExternal(entry.getKey(), entry.getValue());
        }
    }

    public void readFromNBT(@NotNull NBTTagCompound nbtTagCompound) {
        NBTTagCompound compound = nbtTagCompound.func_74775_l(TAG_MATERIAL_STORE);
        NBTTagList list = compound.func_150295_c(TAG_DONT_NEED, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            Material material = new Material(tag.func_74762_e(TAG_ID));
            this.addMaterial(material, tag.func_74762_e(TAG_QUANTITY));
        }
        NBTTagList listHaveNeed = compound.func_150295_c(TAG_HAVE_NEED, 10);
        MaterialStore.readMapFromNBT(listHaveNeed, this.haveNeed);
        NBTTagList listNeed = compound.func_150295_c(TAG_NEED, 10);
        MaterialStore.readMapFromNBT(listNeed, this.need);
    }

    private static void readMapFromNBT(@NotNull NBTTagList list, @NotNull Map<Material, Integer> map) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            Integer id = tag.func_74762_e(TAG_ID);
            map.put(new Material(id), tag.func_74762_e(TAG_QUANTITY));
        }
    }

    public void writeToNBT(@NotNull NBTTagCompound nbtTagCompound) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList dontNeedList = new NBTTagList();
        MaterialStore.writeMapToNBT(dontNeedList, this.dontNeed);
        compound.func_74782_a(TAG_DONT_NEED, (NBTBase)dontNeedList);
        NBTTagList haveNeedList = new NBTTagList();
        MaterialStore.writeMapToNBT(haveNeedList, this.haveNeed);
        compound.func_74782_a(TAG_HAVE_NEED, (NBTBase)haveNeedList);
        NBTTagList needList = new NBTTagList();
        MaterialStore.writeMapToNBT(needList, this.need);
        compound.func_74782_a(TAG_NEED, (NBTBase)needList);
        nbtTagCompound.func_74782_a(TAG_MATERIAL_STORE, (NBTBase)compound);
    }

    private static void writeMapToNBT(@NotNull NBTTagList compound, @NotNull Map<Material, Integer> map) {
        for (Map.Entry<Material, Integer> entry : map.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a(TAG_ID, entry.getKey().hashCode());
            tag.func_74768_a(TAG_QUANTITY, entry.getValue().intValue());
            compound.func_74742_a((NBTBase)tag);
        }
    }

    public static enum Type {
        INVENTORY,
        CHEST;

    }
}

