/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.IColony;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public class DeleteColonyCommand
extends AbstractSingleCommand {
    public static final String DESC = "delete";
    private static final String NO_COLONY_FOUND_MESSAGE = "Colony with mayor %s not found.";
    private static final String NO_COLONY_FOUND_MESSAGE_ID = "Colony with ID %d not found.";

    public DeleteColonyCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId|OwnerName>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        IColony colony;
        int colonyId = -1;
        UUID mayorID = null;
        if (args.length != 0) {
            try {
                colonyId = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                mayorID = DeleteColonyCommand.getUUIDFromName(sender, args);
            }
        }
        if ((colony = colonyId == -1 ? ColonyManager.getIColonyByOwner(sender.func_130014_f_(), mayorID) : ColonyManager.getColony(colonyId)) == null) {
            if (colonyId == -1) {
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format(NO_COLONY_FOUND_MESSAGE, args[0])));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format(NO_COLONY_FOUND_MESSAGE_ID, colonyId)));
            }
            return;
        }
        server.func_152344_a(() -> ColonyManager.deleteColony(colony.getID()));
    }

    private static UUID getUUIDFromName(@NotNull ICommandSender sender, String ... args) {
        GameProfile profile;
        MinecraftServer tempServer = sender.func_130014_f_().func_73046_m();
        if (tempServer != null && (profile = tempServer.func_152358_ax().func_152655_a(args[0])) != null) {
            return profile.getId();
        }
        return null;
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return index == 0 && args.length > 0 && !args[0].isEmpty() && DeleteColonyCommand.getIthArgument(args, 0, Integer.MAX_VALUE) == Integer.MAX_VALUE;
    }
}

