/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.ai.item.handling.ItemStorage;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.entity.pathfinding.WalkToProxy;
import com.minecolonies.coremod.inventory.InventoryCitizen;
import com.minecolonies.coremod.util.InventoryFunctions;
import com.minecolonies.coremod.util.InventoryUtils;
import com.minecolonies.coremod.util.LanguageHandler;
import com.minecolonies.coremod.util.Log;
import com.minecolonies.coremod.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIBasic<J extends AbstractJob>
extends AbstractAISkeleton<J> {
    public static final int EXCEPTION_TIMEOUT = 100;
    private static final int DELAY_RECHECK = 10;
    private static final int DEFAULT_RANGE_FOR_DELAY = 4;
    private static final int ACTIONS_UNTIL_DUMP = 32;
    private static final int HIT_EVERY_X_TICKS = 5;
    @NotNull
    private final List<ItemStack> itemsNeeded = new ArrayList<ItemStack>();
    @Nullable
    protected BlockPos currentWorkingLocation = null;
    @Nullable
    protected BlockPos currentStandingLocation = null;
    private int delay = 0;
    @NotNull
    private List<ItemStack> itemsCurrentlyNeeded = new ArrayList<ItemStack>();
    private boolean needsShovel = false;
    private boolean needsAxe = false;
    private boolean needsHoe = false;
    private boolean needsPickaxe = false;
    private boolean needsWeapon = false;
    private int needsPickaxeLevel = -1;
    private boolean hasDelayed = false;
    private int actionsDone = 0;
    private WalkToProxy proxy;

    protected AbstractEntityAIBasic(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget(AIState.INIT, this::initSafetyChecks), new AITarget(this::updateVisualState), new AITarget(this::waitingForSomething, this::getState), new AITarget(() -> !this.itemsCurrentlyNeeded.isEmpty(), this::waitForNeededItems), new AITarget(() -> this.needsShovel, this::waitForShovel), new AITarget(() -> this.needsAxe, this::waitForAxe), new AITarget(() -> this.needsHoe, this::waitForHoe), new AITarget(() -> this.needsPickaxe, this::waitForPickaxe), new AITarget(() -> this.needsWeapon, this::waitForWeapon), new AITarget(AIState.INVENTORY_FULL, this::dumpInventory), new AITarget(this::inventoryNeedsDump, AIState.INVENTORY_FULL));
    }

    @Override
    protected void onException(RuntimeException e) {
        Log.getLogger().info("Pausing Entity for 5 Seconds");
        this.setDelay(100);
    }

    protected final void setDelay(int timeout) {
        this.delay = timeout;
    }

    private boolean inventoryNeedsDump() {
        return this.worker.isInventoryFull() || this.actionsDone >= this.getActionsDoneUntilDumping() || this.wantInventoryDumped();
    }

    protected int getActionsDoneUntilDumping() {
        return 32;
    }

    protected boolean wantInventoryDumped() {
        return false;
    }

    @NotNull
    private AIState initSafetyChecks() {
        if (null == this.getOwnBuilding()) {
            return AIState.INIT;
        }
        return AIState.IDLE;
    }

    @Nullable
    protected AbstractBuildingWorker getOwnBuilding() {
        return this.worker.getWorkBuilding();
    }

    private AIState updateVisualState() {
        this.job.setNameTag(this.getState().toString());
        this.updateRenderMetaData();
        return null;
    }

    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata("");
    }

    private boolean waitingForSomething() {
        if (this.delay > 0) {
            if (this.currentStandingLocation != null && !this.worker.isWorkerAtSiteWithMove(this.currentStandingLocation, 4)) {
                return true;
            }
            if (this.delay % 5 == 0) {
                this.worker.hitBlockWithToolInHand(this.currentWorkingLocation);
            }
            --this.delay;
            return true;
        }
        this.clearWorkTarget();
        return false;
    }

    private void clearWorkTarget() {
        this.currentStandingLocation = null;
        this.currentWorkingLocation = null;
        this.delay = 0;
    }

    @NotNull
    private AIState waitForNeededItems() {
        this.delay = 10;
        return this.lookForNeededItems();
    }

    @NotNull
    private AIState lookForNeededItems() {
        this.syncNeededItemsWithInventory();
        if (this.itemsCurrentlyNeeded.isEmpty()) {
            this.itemsNeeded.clear();
            this.job.clearItemsNeeded();
            return AIState.IDLE;
        }
        if (!this.walkToBuilding()) {
            this.delay += 10;
            ItemStack first = this.itemsCurrentlyNeeded.get(0);
            if (this.isInHut(first)) {
                return AIState.NEEDS_ITEM;
            }
            this.requestWithoutSpam(first.func_82833_r());
        }
        return AIState.NEEDS_ITEM;
    }

    private void syncNeededItemsWithInventory() {
        this.job.clearItemsNeeded();
        this.itemsNeeded.forEach(this.job::addItemNeeded);
        InventoryUtils.getInventoryAsList(this.worker.getInventoryCitizen()).forEach(this.job::removeItemNeeded);
        this.itemsCurrentlyNeeded = new ArrayList<ItemStack>(this.job.getItemsNeeded());
    }

    protected final boolean walkToBuilding() {
        AbstractBuildingWorker ownBuilding = this.getOwnBuilding();
        return ownBuilding == null || this.walkToBlock(ownBuilding.getLocation());
    }

    public boolean isInHut(@Nullable ItemStack is) {
        AbstractBuildingWorker buildingMiner = this.getOwnBuilding();
        return buildingMiner != null && is != null && InventoryFunctions.matchFirstInInventory((IInventory)buildingMiner.getTileEntity(), stack -> stack != null && is.func_77969_a(stack), this::takeItemStackFromChest);
    }

    private void requestWithoutSpam(@NotNull String chat) {
        this.chatSpamFilter.requestWithoutSpam(chat);
    }

    protected final boolean walkToBlock(@NotNull BlockPos stand) {
        return this.walkToBlock(stand, 4);
    }

    protected final boolean walkToBlock(@NotNull BlockPos stand, int range) {
        if (this.proxy == null) {
            this.proxy = new WalkToProxy(this.worker);
        }
        if (this.proxy.walkToBlock(stand, range)) {
            this.workOnBlock(null, stand, 10);
            return true;
        }
        return false;
    }

    private void workOnBlock(@Nullable BlockPos target, @Nullable BlockPos stand, int timeout) {
        this.currentWorkingLocation = target;
        this.currentStandingLocation = stand;
        this.delay = timeout;
    }

    public void takeItemStackFromChest(int slot) {
        AbstractBuildingWorker ownBuilding = this.getOwnBuilding();
        if (ownBuilding == null) {
            return;
        }
        InventoryUtils.takeStackInSlot((IInventory)ownBuilding.getTileEntity(), this.worker.getInventoryCitizen(), slot);
    }

    @NotNull
    private AIState waitForShovel() {
        if (this.checkForShovel()) {
            this.delay += 10;
            return AIState.NEEDS_SHOVEL;
        }
        return AIState.IDLE;
    }

    private boolean checkForShovel() {
        this.needsShovel = this.checkForTool("shovel");
        return this.needsShovel;
    }

    private boolean checkForTool(@NotNull String tool) {
        boolean needsTool = !InventoryFunctions.matchFirstInInventory(this.worker.getInventoryCitizen(), stack -> Utils.isTool(stack, tool), xva$0 -> InventoryFunctions.doNothing(xva$0));
        int hutLevel = this.worker.getWorkBuilding().getBuildingLevel();
        InventoryCitizen inventory = this.worker.getInventoryCitizen();
        boolean isUsable = InventoryUtils.hasToolLevel(tool, inventory, hutLevel);
        if (!needsTool && isUsable) {
            return false;
        }
        this.delay += 10;
        if (this.walkToBuilding()) {
            return true;
        }
        if (this.isToolInHut(tool)) {
            return false;
        }
        this.chatSpamFilter.talkWithoutSpam(LanguageHandler.format("entity.worker.toolRequest", tool, InventoryUtils.swapToolGrade(hutLevel)), new String[0]);
        return true;
    }

    private boolean isToolInHut(String tool) {
        AbstractBuildingWorker buildingWorker = this.getOwnBuilding();
        return buildingWorker != null && InventoryFunctions.matchFirstInInventory((IInventory)buildingWorker.getTileEntity(), stack -> Utils.isTool(stack, tool), this::takeItemStackFromChest);
    }

    @NotNull
    private AIState waitForAxe() {
        if (this.checkForAxe()) {
            this.delay += 10;
            return AIState.NEEDS_AXE;
        }
        return AIState.IDLE;
    }

    protected boolean checkForAxe() {
        this.needsAxe = this.checkForTool("axe");
        return this.needsAxe;
    }

    @NotNull
    private AIState waitForHoe() {
        if (this.checkForHoe()) {
            this.delay += 10;
            return AIState.NEEDS_HOE;
        }
        return AIState.IDLE;
    }

    protected boolean checkForHoe() {
        this.needsHoe = this.checkForTool("hoe");
        return this.needsHoe;
    }

    @NotNull
    private AIState waitForPickaxe() {
        if (this.checkForPickaxe(this.needsPickaxeLevel)) {
            this.delay += 10;
            return AIState.NEEDS_PICKAXE;
        }
        return AIState.IDLE;
    }

    private boolean checkForPickaxe(int minlevel) {
        int hutLevel;
        this.needsPickaxe = !InventoryFunctions.matchFirstInInventory(this.worker.getInventoryCitizen(), stack -> Utils.checkIfPickaxeQualifies(minlevel, Utils.getMiningLevel(stack, "pickaxe")), xva$0 -> InventoryFunctions.doNothing(xva$0));
        this.delay += 10;
        InventoryCitizen inventory = this.worker.getInventoryCitizen();
        boolean isUsable = InventoryUtils.hasToolLevel("pickaxe", inventory, hutLevel = this.worker.getWorkBuilding().getBuildingLevel());
        if (!isUsable) {
            this.needsPickaxe = true;
        }
        if (this.needsPickaxe) {
            this.needsPickaxeLevel = minlevel;
            if (this.walkToBuilding()) {
                return false;
            }
            if (this.isPickaxeInHut(minlevel)) {
                return true;
            }
            this.chatSpamFilter.talkWithoutSpam(LanguageHandler.format("entity.worker.pickaxeRequest", InventoryUtils.swapToolGrade(minlevel), InventoryUtils.swapToolGrade(hutLevel)), new String[0]);
        }
        return this.needsPickaxe;
    }

    private boolean isPickaxeInHut(int minlevel) {
        AbstractBuildingWorker buildingWorker = this.getOwnBuilding();
        return buildingWorker != null && InventoryFunctions.matchFirstInInventory((IInventory)buildingWorker.getTileEntity(), stack -> Utils.checkIfPickaxeQualifies(minlevel, Utils.getMiningLevel(stack, "pickaxe")), this::takeItemStackFromChest);
    }

    @NotNull
    private AIState waitForWeapon() {
        if (this.checkForWeapon()) {
            this.delay += 10;
            return AIState.NEEDS_WEAPON;
        }
        return AIState.IDLE;
    }

    public boolean checkForWeapon() {
        this.needsWeapon = !InventoryFunctions.matchFirstInInventory(this.worker.getInventoryCitizen(), stack -> stack != null && Utils.doesItemServeAsWeapon(stack), xva$0 -> InventoryFunctions.doNothing(xva$0));
        this.delay += 10;
        if (this.needsWeapon) {
            if (this.walkToBuilding()) {
                return false;
            }
            if (this.isWeaponInHut()) {
                return true;
            }
            this.requestWithoutSpam(LanguageHandler.format("com.minecolonies.coremod.job.guard.needWeapon", new Object[0]));
        }
        return this.needsWeapon;
    }

    private boolean isWeaponInHut() {
        AbstractBuildingWorker buildingWorker = this.getOwnBuilding();
        return buildingWorker != null && InventoryFunctions.matchFirstInInventory((IInventory)buildingWorker.getTileEntity(), stack -> stack != null && Utils.doesItemServeAsWeapon(stack), this::takeItemStackFromChest);
    }

    @NotNull
    private AIState dumpInventory() {
        if (this.dumpOneMoreSlot()) {
            this.delay += 10;
            return AIState.INVENTORY_FULL;
        }
        if (this.isInventoryAndChestFull()) {
            this.chatSpamFilter.talkWithoutSpam("entity.worker.inventoryFullChestFull", new String[0]);
        }
        this.itemsNiceToHave().forEach(this::isInHut);
        this.clearActionsDone();
        return AIState.IDLE;
    }

    private boolean dumpOneMoreSlot() {
        return this.dumpOneMoreSlot(this::neededForWorker);
    }

    private boolean isInventoryAndChestFull() {
        AbstractBuildingWorker buildingWorker = this.getOwnBuilding();
        return InventoryUtils.isInventoryFull(this.worker.getInventoryCitizen()) && buildingWorker != null && InventoryUtils.isInventoryFull((IInventory)buildingWorker.getTileEntity());
    }

    @NotNull
    protected List<ItemStack> itemsNiceToHave() {
        return new ArrayList<ItemStack>();
    }

    private void clearActionsDone() {
        this.actionsDone = 0;
    }

    private boolean dumpOneMoreSlot(@NotNull Predicate<ItemStack> keepIt) {
        HashMap alreadyKept = new HashMap();
        Map<ItemStorage, Integer> shouldKeep = this.needXForWorker();
        AbstractBuildingWorker buildingWorker = this.getOwnBuilding();
        return buildingWorker != null && (this.walkToBuilding() || InventoryFunctions.matchFirstInInventory((IInventory)this.worker.getInventoryCitizen(), (i, stack) -> stack != null && !keepIt.test((ItemStack)stack) && this.shouldDumpItem(alreadyKept, shouldKeep, buildingWorker, (ItemStack)stack, (int)i)));
    }

    protected Map<ItemStorage, Integer> needXForWorker() {
        return new HashMap<ItemStorage, Integer>();
    }

    private boolean shouldDumpItem(@NotNull Map<ItemStorage, Integer> alreadyKept, @NotNull Map<ItemStorage, Integer> shouldKeep, @NotNull AbstractBuildingWorker buildingWorker, @NotNull ItemStack stack, int i) {
        ItemStack returnStack;
        int amountToKeep = 0;
        if (AbstractEntityAIBasic.keptEnough(alreadyKept, shouldKeep, stack)) {
            returnStack = InventoryUtils.setStack((IInventory)buildingWorker.getTileEntity(), stack);
        } else {
            ItemStorage tempStorage = new ItemStorage(stack.func_77973_b(), stack.func_77952_i(), stack.field_77994_a, false);
            ItemStack tempStack = AbstractEntityAIBasic.handleKeepX(alreadyKept, shouldKeep, tempStorage);
            if (tempStack == null || tempStack.field_77994_a == 0) {
                return false;
            }
            amountToKeep = stack.field_77994_a - tempStorage.getAmount();
            returnStack = InventoryUtils.setStack((IInventory)buildingWorker.getTileEntity(), tempStack);
        }
        if (returnStack == null) {
            this.worker.getInventoryCitizen().func_70298_a(i, stack.field_77994_a - amountToKeep);
            return amountToKeep == 0;
        }
        this.worker.getInventoryCitizen().func_70298_a(i, stack.field_77994_a - returnStack.field_77994_a - amountToKeep);
        return stack.field_77994_a != returnStack.field_77994_a;
    }

    private static boolean keptEnough(@NotNull Map<ItemStorage, Integer> alreadyKept, @NotNull Map<ItemStorage, Integer> shouldKeep, @NotNull ItemStack stack) {
        ItemStorage tempStorage;
        ArrayList<Map.Entry<ItemStorage, Integer>> tempKeep = new ArrayList<Map.Entry<ItemStorage, Integer>>(shouldKeep.entrySet());
        for (Map.Entry<ItemStorage, Integer> tempEntry : tempKeep) {
            ItemStorage tempStorage2 = tempEntry.getKey();
            if (tempStorage2 == null || tempStorage2.getItem() != stack.func_77973_b() || tempStorage2.getDamageValue() == stack.func_77952_i()) continue;
            shouldKeep.put(new ItemStorage(stack.func_77973_b(), stack.func_77952_i(), 0, tempStorage2.ignoreDamageValue()), tempEntry.getValue());
            break;
        }
        return shouldKeep.get(tempStorage = new ItemStorage(stack.func_77973_b(), stack.func_77952_i(), 0, false)) == null || alreadyKept.get(tempStorage) != null && alreadyKept.get(tempStorage) >= shouldKeep.get(tempStorage);
    }

    private static ItemStack handleKeepX(@NotNull Map<ItemStorage, Integer> alreadyKept, @NotNull Map<ItemStorage, Integer> shouldKeep, @NotNull ItemStorage tempStorage) {
        int amountKept = 0;
        if (alreadyKept.get(tempStorage) != null) {
            amountKept = alreadyKept.remove(tempStorage);
        }
        if (shouldKeep.get(tempStorage) >= tempStorage.getAmount() + amountKept) {
            alreadyKept.put(tempStorage, tempStorage.getAmount() + amountKept);
            return null;
        }
        alreadyKept.put(tempStorage, shouldKeep.get(tempStorage));
        int dump = tempStorage.getAmount() + amountKept - shouldKeep.get(tempStorage);
        return new ItemStack(tempStorage.getItem(), dump, tempStorage.getDamageValue());
    }

    protected boolean checkOrRequestItems(ItemStack ... items) {
        if (items == null) {
            return false;
        }
        boolean allClear = true;
        for (ItemStack stack : items) {
            int countOfItem;
            if (stack == null || stack.func_77973_b() == null || (countOfItem = this.worker.getItemCountInInventory(stack.func_77973_b())) >= stack.field_77994_a) continue;
            int itemsLeft = stack.field_77994_a - countOfItem;
            ItemStack requiredStack = new ItemStack(stack.func_77973_b(), itemsLeft);
            this.itemsCurrentlyNeeded.add(requiredStack);
            allClear = false;
        }
        if (allClear) {
            return false;
        }
        this.itemsNeeded.clear();
        Collections.addAll(this.itemsNeeded, items);
        return true;
    }

    @NotNull
    protected InventoryCitizen getInventory() {
        return this.worker.getInventoryCitizen();
    }

    protected boolean neededForWorker(@Nullable ItemStack stack) {
        return false;
    }

    protected final boolean holdEfficientTool(@NotNull Block target) {
        int bestSlot = this.getMostEfficientTool(target);
        if (bestSlot >= 0) {
            this.worker.setHeldItem(bestSlot);
            return true;
        }
        this.requestTool(target);
        return false;
    }

    private void requestTool(@NotNull Block target) {
        String tool = target.getHarvestTool(target.func_176223_P());
        int required = target.getHarvestLevel(target.func_176223_P());
        this.updateToolFlag(tool, required);
    }

    private void updateToolFlag(@NotNull String tool, int required) {
        switch (tool) {
            case "axe": {
                this.checkForAxe();
                break;
            }
            case "shovel": {
                this.checkForShovel();
                break;
            }
            case "hoe": {
                this.checkForHoe();
                break;
            }
            case "pickaxe": {
                this.checkForPickaxe(required);
                break;
            }
            default: {
                Log.getLogger().error("Invalid tool " + tool + " not implemented as tool!");
            }
        }
    }

    private int getMostEfficientTool(@NotNull Block target) {
        String tool = target.getHarvestTool(target.func_176223_P());
        int required = target.getHarvestLevel(target.func_176223_P());
        int bestSlot = -1;
        int bestLevel = Integer.MAX_VALUE;
        InventoryCitizen inventory = this.worker.getInventoryCitizen();
        int hutLevel = this.worker.getWorkBuilding().getBuildingLevel();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            int level = Utils.getMiningLevel(item, tool);
            if (level < required || level >= bestLevel || tool != null && !InventoryUtils.verifyToolLevel(item, level, hutLevel)) continue;
            bestSlot = i;
            bestLevel = level;
        }
        return bestSlot;
    }

    protected final boolean hasNotDelayed(int time) {
        if (!this.hasDelayed) {
            this.setDelay(time);
            this.hasDelayed = true;
            return true;
        }
        this.hasDelayed = false;
        return false;
    }

    protected final void incrementActionsDone() {
        ++this.actionsDone;
    }
}

