/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.BlockUtils;
import com.minecolonies.coremod.util.InventoryUtils;
import com.minecolonies.coremod.util.Log;
import com.minecolonies.coremod.util.MathUtils;
import com.minecolonies.coremod.util.Utils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIInteract<J extends AbstractJob>
extends AbstractEntityAICrafting<J> {
    private static final double DELAY_MODIFIER = 1000.0;
    private static final double XP_PER_BLOCK = 0.05;
    private static final double LEVEL_MODIFIER = 0.85;
    private static final int HAND_MINING_MODIFIER = 10;
    private static final int MIN_WORKING_RANGE = 12;

    public AbstractEntityAIInteract(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget[0]);
    }

    protected final boolean mineBlock(@NotNull BlockPos blockToMine) {
        return this.mineBlock(blockToMine, new BlockPos((int)this.worker.field_70165_t, (int)this.worker.field_70163_u, (int)this.worker.field_70161_v));
    }

    protected final boolean mineBlock(@NotNull BlockPos blockToMine, @NotNull BlockPos safeStand) {
        IBlockState curBlockState = this.world.func_180495_p(blockToMine);
        Block curBlock = curBlockState.func_177230_c();
        if (curBlock == null || curBlock.equals(Blocks.field_150350_a) || BlockUtils.shouldNeverBeMessedWith(curBlock)) {
            if (curBlock != null && curBlockState.func_185904_a().func_76224_d()) {
                this.world.func_175698_g(blockToMine);
            }
            return true;
        }
        if (this.checkMiningLocation(blockToMine, safeStand)) {
            return false;
        }
        ItemStack tool = this.worker.func_184614_ca();
        int fortune = Utils.getFortuneOf(tool);
        List<ItemStack> items = BlockPosUtil.getBlockDrops(this.world, blockToMine, fortune);
        this.worker.breakBlockWithToolInHand(blockToMine);
        for (ItemStack item : items) {
            InventoryUtils.setStack(this.worker.getInventoryCitizen(), item);
        }
        this.worker.addExperience(0.05);
        this.incrementActionsDone();
        return true;
    }

    private boolean checkMiningLocation(@NotNull BlockPos blockToMine, @NotNull BlockPos safeStand) {
        Block curBlock = this.world.func_180495_p(blockToMine).func_177230_c();
        if (!this.holdEfficientTool(curBlock)) {
            return true;
        }
        ItemStack tool = this.worker.func_184614_ca();
        if (tool != null && !ForgeHooks.canToolHarvestBlock((IBlockAccess)this.world, (BlockPos)blockToMine, (ItemStack)tool) && curBlock != Blocks.field_150357_h) {
            Log.getLogger().info(String.format("ForgeHook not in sync with EfficientTool for %s and %s\nPlease report to MineColonies with this text to add support!", curBlock, tool));
        }
        if (this.walkToBlock(safeStand) && MathUtils.twoDimDistance(this.worker.func_180425_c(), safeStand) > 12.0) {
            return true;
        }
        this.currentWorkingLocation = blockToMine;
        this.currentStandingLocation = safeStand;
        return this.hasNotDelayed(this.getBlockMiningDelay(curBlock, blockToMine));
    }

    private int getBlockMiningDelay(@NotNull Block block, @NotNull BlockPos pos) {
        if (this.worker.func_184614_ca() == null) {
            return (int)this.world.func_180495_p(pos).func_185887_b(this.world, pos);
        }
        return (int)(1000.0 * Math.pow(0.85, this.worker.getLevel()) * (double)this.world.func_180495_p(pos).func_185887_b(this.world, pos) / (double)this.worker.func_184614_ca().func_77973_b().func_150893_a(this.worker.func_184614_ca(), block.func_176223_P()));
    }
}

