/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.BuildingBuilder;
import com.minecolonies.coremod.colony.buildings.BuildingMiner;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.AbstractJobStructure;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuild;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.configuration.Configurations;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.entity.ai.citizen.miner.Level;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.entity.ai.util.Structure;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.BlockUtils;
import com.minecolonies.coremod.util.EntityUtils;
import com.minecolonies.coremod.util.InventoryUtils;
import com.minecolonies.coremod.util.LanguageHandler;
import com.minecolonies.coremod.util.Log;
import com.minecolonies.coremod.util.MathUtils;
import com.minecolonies.coremod.util.StructureWrapper;
import com.minecolonies.coremod.util.Utils;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockDragonEgg;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIStructure<J extends AbstractJob>
extends AbstractEntityAIInteract<J> {
    private static final double XP_EACH_BUILDING = 2.5;
    private static final double RUN_AWAY_SPEED = 4.1;
    private static final int MIN_ADDITIONAL_RANGE_TO_BUILD = 3;
    private static final int MAX_ADDITIONAL_RANGE_TO_BUILD = 25;
    private static final int UNLIMITED_RESOURCES_TIMEOUT = 5;
    private Structure currentStructure;
    private BlockPos workFrom;
    private static final int STANDARD_WORKING_RANGE = 5;
    private static final int MIN_WORKING_RANGE = 12;
    private int rotation = 0;
    private static final CharSequence WAYPOINT_STRING = "waypoint";

    protected AbstractEntityAIStructure(@NotNull J job) {
        super(job);
        this.registerTargets(new AITarget(AIState.START_BUILDING, this::startBuilding), new AITarget(AIState.IDLE, this::isThereAStructureToBuild, () -> AIState.START_BUILDING), new AITarget(AIState.CLEAR_STEP, this.generateStructureGenerator(this::clearStep, AIState.BUILDING_STEP)), new AITarget(AIState.BUILDING_STEP, this.generateStructureGenerator(this::structureStep, AIState.DECORATION_STEP)), new AITarget(AIState.DECORATION_STEP, this.generateStructureGenerator(this::decorationStep, AIState.COMPLETE_BUILD)), new AITarget(AIState.SPAWN_STEP, () -> AIState.IDLE), new AITarget(AIState.COMPLETE_BUILD, this::completeBuild));
    }

    private AIState completeBuild() {
        if (this.job instanceof AbstractJobStructure) {
            if (((AbstractJobStructure)this.job).getStructure() == null && this.job instanceof JobBuilder) {
                ((JobBuilder)this.job).complete();
            }
            if (this.job instanceof JobBuilder) {
                String structureName = ((AbstractJobStructure)this.job).getStructure().getName();
                LanguageHandler.sendPlayersLocalizedMessage(this.worker.getColony().getMessageEntityPlayers(), "entity.builder.messageBuildComplete", structureName);
                ((JobBuilder)this.job).getStructure().getEntities().forEach(this::spawnEntity);
                WorkOrderBuild wo = ((JobBuilder)this.job).getWorkOrder();
                if (wo == null) {
                    Log.getLogger().error(String.format("Builder (%d:%d) ERROR - Finished, but missing work order(%d)", this.worker.getColony().getID(), this.worker.getCitizenData().getId(), ((JobBuilder)this.job).getWorkOrderId()));
                } else {
                    if (wo instanceof WorkOrderBuildDecoration) {
                        if (structureName.contains(WAYPOINT_STRING)) {
                            this.worker.getColony().addWayPoint(wo.getBuildingLocation(), this.world.func_180495_p(wo.getBuildingLocation()));
                        }
                    } else {
                        AbstractBuilding building = this.job.getColony().getBuilding(wo.getBuildingLocation());
                        if (building == null) {
                            Log.getLogger().error(String.format("Builder (%d:%d) ERROR - Finished, but missing building(%s)", this.worker.getColony().getID(), this.worker.getCitizenData().getId(), wo.getBuildingLocation()));
                        } else {
                            building.setBuildingLevel(wo.getUpgradeLevel());
                        }
                    }
                    ((JobBuilder)this.job).complete();
                }
                AbstractBuildingWorker workerBuilding = this.getOwnBuilding();
                if (workerBuilding instanceof BuildingBuilder) {
                    ((BuildingBuilder)workerBuilding).resetNeededResources();
                }
                this.func_75251_c();
            } else if (this.job instanceof JobMiner) {
                BuildingMiner minerBuilding = (BuildingMiner)this.getOwnBuilding();
                if (minerBuilding.clearedShaft) {
                    minerBuilding.getCurrentLevel().closeNextNode(this.rotation);
                } else {
                    Level currentLevel = new Level(minerBuilding, ((JobMiner)this.job).getStructure().getPosition().func_177956_o());
                    minerBuilding.addLevel(currentLevel);
                    minerBuilding.setCurrentLevel(minerBuilding.getNumberOfLevels());
                    minerBuilding.resetStartingLevelShaft();
                }
                this.getOwnBuilding().markDirty();
                ((JobMiner)this.job).setStructure(null);
            }
            this.worker.addExperience(2.5);
            this.workFrom = null;
        }
        this.currentStructure = null;
        return AIState.IDLE;
    }

    private Boolean decorationStep(Structure.StructureBlock structureBlock) {
        if (!BlockUtils.shouldNeverBeMessedWith(structureBlock.worldBlock)) {
            if (!this.walkToConstructionSite()) {
                return false;
            }
            if (structureBlock.block == null || structureBlock.doesStructureBlockEqualWorldBlock() || structureBlock.metadata.func_185904_a().func_76220_a()) {
                return true;
            }
            this.worker.faceBlock(structureBlock.blockPosition);
            Block block = structureBlock.block;
            if (block == null) {
                BlockPos local = structureBlock.blockPosition;
                Log.getLogger().error(String.format("StructureProxy has null block at %s - local(%s)", this.currentStructure.getCurrentBlockPosition(), local));
                return true;
            }
            IBlockState blockState = structureBlock.metadata;
            if (!Configurations.builderInfiniteResources && !this.handleMaterials(block, blockState)) {
                return false;
            }
            this.placeBlockAt(block, blockState, structureBlock.blockPosition);
        }
        return true;
    }

    private Boolean structureStep(Structure.StructureBlock structureBlock) {
        if (!BlockUtils.shouldNeverBeMessedWith(structureBlock.worldBlock)) {
            if (!this.walkToConstructionSite()) {
                return false;
            }
            if (structureBlock.block == null || structureBlock.doesStructureBlockEqualWorldBlock() || !structureBlock.metadata.func_185904_a().func_76220_a() && structureBlock.block != Blocks.field_150350_a) {
                return true;
            }
            Block block = structureBlock.block;
            IBlockState blockState = structureBlock.metadata;
            if (structureBlock.block == ModBlocks.blockSolidSubstitution) {
                if (!(this.job instanceof JobMiner && structureBlock.worldBlock instanceof BlockOre || !structureBlock.worldMetadata.func_185904_a().func_76220_a())) {
                    return true;
                }
                block = this.getSolidSubstitution(structureBlock.blockPosition);
                blockState = block.func_176223_P();
            }
            this.worker.faceBlock(structureBlock.blockPosition);
            if (block == null) {
                BlockPos local = structureBlock.blockPosition;
                Log.getLogger().error(String.format("StructureProxy has null block at %s - local(%s)", this.currentStructure.getCurrentBlockPosition(), local));
                return true;
            }
            if (!Configurations.builderInfiniteResources && !this.handleMaterials(block, blockState)) {
                return false;
            }
            this.placeBlockAt(block, blockState, structureBlock.blockPosition);
        }
        return true;
    }

    private Supplier<AIState> generateStructureGenerator(@NotNull Function<Structure.StructureBlock, Boolean> evaluationFunction, @NotNull AIState nextState) {
        Supplier<Structure.StructureBlock> getCurrentBlock = () -> this.currentStructure.getCurrentBlock();
        Supplier<Structure.Result> advanceBlock = () -> this.currentStructure.advanceBlock();
        return () -> {
            Structure.StructureBlock currentBlock = (Structure.StructureBlock)getCurrentBlock.get();
            if (currentBlock.block == null || ((Boolean)evaluationFunction.apply(currentBlock)).booleanValue()) {
                Structure.Result result = (Structure.Result)((Object)((Object)advanceBlock.get()));
                if (result == Structure.Result.AT_END) {
                    this.switchStage(nextState);
                    return nextState;
                }
                if (result == Structure.Result.CONFIG_LIMIT) {
                    return this.getState();
                }
            }
            return this.getState();
        };
    }

    private void switchStage(AIState state) {
        if (state.equals((Object)AIState.BUILDING_STEP)) {
            this.currentStructure.setStage(Structure.Stage.BUILD);
        } else if (state.equals((Object)AIState.DECORATION_STEP)) {
            this.currentStructure.setStage(Structure.Stage.DECORATE);
        } else if (state.equals((Object)AIState.COMPLETE_BUILD)) {
            this.currentStructure.setStage(Structure.Stage.COMPLETE);
        }
    }

    public void loadStructure() {
        WorkOrderBuild workOrder = null;
        if (this.job instanceof JobBuilder) {
            workOrder = ((JobBuilder)this.job).getWorkOrder();
        }
        if (workOrder == null) {
            return;
        }
        BlockPos pos = workOrder.getBuildingLocation();
        if (!(workOrder instanceof WorkOrderBuildDecoration) && this.worker.getColony().getBuilding(pos) == null) {
            Log.getLogger().warn("AbstractBuilding does not exist - removing build request");
            this.worker.getColony().getWorkManager().removeWorkOrder(workOrder);
            return;
        }
        int tempRotation = 0;
        if (workOrder.getRotation() == 0 && !(workOrder instanceof WorkOrderBuildDecoration)) {
            IBlockState blockState = this.world.func_180495_p(pos);
            if (blockState.func_177230_c() instanceof AbstractBlockHut) {
                tempRotation = BlockUtils.getRotationFromFacing((EnumFacing)blockState.func_177229_b((IProperty)AbstractBlockHut.FACING));
            }
        } else {
            tempRotation = workOrder.getRotation();
        }
        this.loadStructure(workOrder.getStructureName(), tempRotation, pos);
        workOrder.setCleared(false);
        workOrder.setRequested(false);
        this.requestMaterials();
    }

    public abstract Block getSolidSubstitution(BlockPos var1);

    public void loadStructure(@NotNull String name, int rotateTimes, BlockPos position) {
        if (this.job instanceof AbstractJobStructure) {
            this.rotation = rotateTimes;
            try {
                StructureWrapper wrapper = new StructureWrapper(this.world, name);
                ((AbstractJobStructure)this.job).setStructure(wrapper);
                this.currentStructure = new Structure(this.world, wrapper, Structure.Stage.CLEAR);
            }
            catch (IllegalStateException e) {
                Log.getLogger().warn(String.format("StructureProxy: (%s) does not exist - removing build request", name), (Throwable)e);
                ((AbstractJobStructure)this.job).setStructure(null);
            }
            ((AbstractJobStructure)this.job).getStructure().rotate(rotateTimes);
            ((AbstractJobStructure)this.job).getStructure().setPosition(position);
        }
    }

    private void requestMaterials() {
        if (!Configurations.builderInfiniteResources && this.job instanceof JobBuilder) {
            while (((JobBuilder)this.job).getStructure().findNextBlock()) {
                AbstractBuildingWorker building;
                Block block = ((JobBuilder)this.job).getStructure().getBlock();
                IBlockState blockState = ((JobBuilder)this.job).getStructure().getBlockState();
                if (((JobBuilder)this.job).getStructure().doesStructureBlockEqualWorldBlock() || blockState instanceof BlockBed && ((BlockBed.EnumPartType)blockState.func_177229_b((IProperty)BlockBed.field_176472_a)).equals((Object)BlockBed.EnumPartType.FOOT) || blockState instanceof BlockDoor && ((BlockDoor.EnumDoorHalf)blockState.func_177229_b((IProperty)BlockDoor.field_176523_O)).equals((Object)BlockDoor.EnumDoorHalf.LOWER)) continue;
                Block worldBlock = BlockPosUtil.getBlock(this.world, ((JobBuilder)this.job).getStructure().getBlockPosition());
                if (block == null || block == Blocks.field_150350_a || worldBlock == Blocks.field_150357_h || worldBlock instanceof AbstractBlockHut || AbstractEntityAIStructure.isBlockFree(block, 0) || !((building = this.getOwnBuilding()) instanceof BuildingBuilder)) continue;
                ((BuildingBuilder)building).addNeededResource(block, 1);
            }
            ((JobBuilder)this.job).getWorkOrder().setRequested(true);
        }
    }

    private boolean clearStep(@NotNull Structure.StructureBlock currentBlock) {
        if (this.job instanceof JobBuilder && ((JobBuilder)this.job).getWorkOrder().isCleared() || !this.currentStructure.getStage().equals((Object)Structure.Stage.CLEAR)) {
            return true;
        }
        if (!BlockUtils.shouldNeverBeMessedWith(currentBlock.worldBlock)) {
            if (!this.walkToConstructionSite()) {
                return false;
            }
            this.worker.faceBlock(currentBlock.blockPosition);
            if (Configurations.builderInfiniteResources || currentBlock.worldMetadata.func_185904_a().func_76224_d()) {
                this.worker.func_184201_a(EntityEquipmentSlot.MAINHAND, null);
                this.world.func_175698_g(currentBlock.blockPosition);
                this.world.func_175656_a(currentBlock.blockPosition, Blocks.field_150350_a.func_176223_P());
                this.worker.func_184609_a(this.worker.func_184600_cs());
                this.setDelay(5);
            } else if (!this.mineBlock(currentBlock.blockPosition, this.workFrom == null ? this.getWorkingPosition() : this.workFrom)) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    private BlockPos getPositionInDirection(EnumFacing facing, int distance) {
        return this.getFloor(this.currentStructure.getCurrentBlockPosition().func_177967_a(facing, distance));
    }

    @NotNull
    private BlockPos getFloor(@NotNull BlockPos position) {
        if (!EntityUtils.solidOrLiquid(this.world, position)) {
            return this.getFloor(position.func_177977_b());
        }
        if (!EntityUtils.solidOrLiquid(this.world, position.func_177984_a())) {
            return position;
        }
        return this.getFloor(position.func_177984_a());
    }

    private boolean isThereAStructureToBuild() {
        return this.currentStructure != null;
    }

    public boolean walkToConstructionSite() {
        if (this.workFrom == null) {
            this.workFrom = this.getWorkingPosition();
        }
        return this.worker.isWorkerAtSiteWithMove(this.workFrom, 5) || MathUtils.twoDimDistance(this.worker.func_180425_c(), this.workFrom) < 12.0;
    }

    private BlockPos getWorkingPosition() {
        if (this.job instanceof JobMiner) {
            this.getNodeMiningPosition(this.currentStructure.getCurrentBlockPosition());
        }
        return this.getWorkingPosition(0);
    }

    private BlockPos getWorkingPosition(int offset) {
        EnumFacing[] directions;
        if (offset > 25) {
            return this.currentStructure.getCurrentBlockPosition();
        }
        int length = this.currentStructure.getLength();
        int width = this.currentStructure.getWidth();
        int distance = Math.max(width, length) + 3 + offset;
        for (EnumFacing direction : directions = new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH}) {
            BlockPos positionInDirection = this.getPositionInDirection(direction, distance);
            if (!EntityUtils.checkForFreeSpace(this.world, positionInDirection)) continue;
            return positionInDirection;
        }
        return this.getWorkingPosition(offset + 1);
    }

    @NotNull
    private AIState startBuilding() {
        if (this.currentStructure == null) {
            return AIState.IDLE;
        }
        switch (this.currentStructure.getStage()) {
            case CLEAR: {
                return AIState.CLEAR_STEP;
            }
            case BUILD: {
                return AIState.BUILDING_STEP;
            }
            case DECORATE: {
                return AIState.DECORATION_STEP;
            }
            case SPAWN: {
                return AIState.SPAWN_STEP;
            }
        }
        return AIState.COMPLETE_BUILD;
    }

    private boolean handleMaterials(@NotNull Block block, @NotNull IBlockState blockState) {
        if (block == Blocks.field_150350_a) {
            return true;
        }
        if (AbstractEntityAIStructure.isBlockFree(block, block.func_176201_c(blockState))) {
            return true;
        }
        return !this.checkOrRequestItems(BlockUtils.getItemStackFromBlockState(blockState));
    }

    public static boolean isBlockFree(@Nullable Block block, int metadata) {
        return block == null || BlockUtils.isWater(block.func_176223_P()) || block.equals(Blocks.field_150362_t) || block.equals(Blocks.field_150361_u) || block.equals(Blocks.field_150398_cm) && Utils.testFlag(metadata, 8) || block instanceof BlockDoor && Utils.testFlag(metadata, 8) || block.equals(Blocks.field_150349_c);
    }

    private void placeBlockAt(@NotNull Block block, @NotNull IBlockState blockState, @NotNull BlockPos coords) {
        if (block == Blocks.field_150350_a) {
            this.worker.func_184201_a(EntityEquipmentSlot.MAINHAND, null);
            if (!this.world.func_175698_g(coords)) {
                Log.getLogger().error(String.format("Block break failure at %s", coords));
            }
        } else {
            Item item = Item.func_150898_a((Block)block);
            this.worker.func_184201_a(EntityEquipmentSlot.MAINHAND, item == null ? null : new ItemStack(item, 1));
            if (!this.placeBlock(coords, block, blockState)) {
                Log.getLogger().error(String.format("Block place failure %s at %s", block.func_149739_a(), coords));
            }
            this.worker.func_184609_a(this.worker.func_184600_cs());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean placeBlock(@NotNull BlockPos pos, Block block, @NotNull IBlockState blockState) {
        if (MathHelper.func_76128_c((double)this.worker.field_70165_t) == pos.func_177958_n() && MathHelper.func_76130_a((int)(pos.func_177956_o() - (int)this.worker.field_70163_u)) <= 1 && MathHelper.func_76128_c((double)this.worker.field_70161_v) == pos.func_177952_p() && this.worker.getNavigator().func_75500_f()) {
            this.worker.getNavigator().moveAwayFromXYZ(pos, 4.1, 1.0);
        }
        if (blockState.func_177230_c() instanceof BlockStairs && this.world.func_180495_p(pos).func_177230_c() instanceof BlockStairs && this.world.func_180495_p(pos).func_177229_b((IProperty)BlockStairs.field_176309_a) == blockState.func_177229_b((IProperty)BlockStairs.field_176309_a) && blockState.func_177230_c() == this.world.func_180495_p(pos).func_177230_c()) {
            return true;
        }
        if (!Configurations.builderInfiniteResources && this.world.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a) {
            List<ItemStack> items = BlockPosUtil.getBlockDrops(this.world, pos, 0);
            for (ItemStack item : items) {
                InventoryUtils.setStack(this.worker.getInventoryCitizen(), item);
            }
        }
        if (block instanceof BlockDoor) {
            if (((BlockDoor.EnumDoorHalf)blockState.func_177229_b((IProperty)BlockDoor.field_176523_O)).equals((Object)BlockDoor.EnumDoorHalf.LOWER)) {
                ItemDoor.func_179235_a((World)this.world, (BlockPos)pos, (EnumFacing)((EnumFacing)blockState.func_177229_b((IProperty)BlockDoor.field_176520_a)), (Block)block, (boolean)false);
            }
        } else if (block instanceof BlockBed) {
            this.world.func_180501_a(pos, blockState, 3);
            EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)BlockBed.field_185512_D);
            if (blockState.func_177229_b((IProperty)BlockBed.field_176472_a) != BlockBed.EnumPartType.FOOT) return true;
            this.world.func_180501_a(pos, blockState.func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT), 3);
            this.world.func_180501_a(pos.func_177972_a(facing), blockState.func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.HEAD), 3);
        } else if (block instanceof BlockDoublePlant) {
            this.world.func_180501_a(pos, blockState.func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.LOWER), 3);
            this.world.func_180501_a(pos.func_177984_a(), blockState.func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER), 3);
        } else {
            if (block instanceof BlockEndPortal || block instanceof BlockMobSpawner || block instanceof BlockDragonEgg || block instanceof BlockPortal) {
                return true;
            }
            if (!this.world.func_180501_a(pos, blockState, 3)) {
                return false;
            }
        }
        if (AbstractEntityAIStructure.isBlockFree(block, block.func_176201_c(blockState))) {
            return true;
        }
        ItemStack stack = BlockUtils.getItemStackFromBlockState(blockState);
        if (stack == null) {
            Log.getLogger().error("Block causes NPE: " + blockState.func_177230_c());
            return false;
        }
        int slot = this.worker.findFirstSlotInInventoryWith(stack.func_77973_b());
        if (slot == -1) return true;
        this.getInventory().func_70298_a(slot, 1);
        this.reduceNeededResources(block);
        return true;
    }

    public void reduceNeededResources(Block block) {
        AbstractBuildingWorker workerBuilding = this.getOwnBuilding();
        if (workerBuilding instanceof BuildingBuilder) {
            ((BuildingBuilder)workerBuilding).reduceNeededResource(block, 1);
        }
    }

    private void spawnEntity(@Nullable Entity entity) {
        if (entity != null && this.job instanceof JobBuilder) {
            BlockPos pos = ((JobBuilder)this.job).getStructure().getOffsetPosition();
            if (entity instanceof EntityHanging) {
                EntityHanging entityHanging = (EntityHanging)entity;
                entityHanging.field_70165_t += (double)pos.func_177958_n();
                entityHanging.field_70163_u += (double)pos.func_177956_o();
                entityHanging.field_70161_v += (double)pos.func_177952_p();
                entityHanging.func_70107_b((double)entityHanging.func_174857_n().func_177958_n(), (double)entityHanging.func_174857_n().func_177956_o(), (double)entityHanging.func_174857_n().func_177952_p());
                entityHanging.func_70029_a(this.world);
                entityHanging.field_71093_bK = this.world.field_73011_w.getDimension();
                this.world.func_72838_d((Entity)entityHanging);
            } else if (entity instanceof EntityMinecart) {
                EntityMinecart minecart = (EntityMinecart)entity;
                minecart.field_70165_t += (double)pos.func_177958_n();
                minecart.field_70163_u += (double)pos.func_177956_o();
                minecart.field_70161_v += (double)pos.func_177952_p();
                minecart.func_70029_a(this.world);
                minecart.field_71093_bK = this.world.field_73011_w.getDimension();
                this.world.func_72838_d((Entity)minecart);
            }
        }
    }

    private BlockPos getNodeMiningPosition(BlockPos blockToMine) {
        if (((BuildingMiner)this.getOwnBuilding()).getCurrentLevel() == null || ((BuildingMiner)this.getOwnBuilding()).getCurrentLevel().getRandomNode() != null) {
            return blockToMine;
        }
        Point2D pos = ((BuildingMiner)this.getOwnBuilding()).getCurrentLevel().getRandomNode().getParent();
        return new BlockPos(pos.getX(), (double)((BuildingMiner)this.getOwnBuilding()).getCurrentLevel().getDepth(), pos.getY());
    }
}

