/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.builder;

import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuild;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructure;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.util.LanguageHandler;
import com.minecolonies.coremod.util.Log;
import com.minecolonies.coremod.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIStructureBuilder
extends AbstractEntityAIStructure<JobBuilder> {
    private static final int INTELLIGENCE_MULTIPLIER = 2;
    private static final int STRENGTH_MULTIPLIER = 1;
    private static final int ACTIONS_UNTIL_DUMP = 1024;
    @Nullable
    private BlockPos workFrom = null;

    public EntityAIStructureBuilder(@NotNull JobBuilder job) {
        super(job);
        super.registerTargets(new AITarget(AIState.IDLE, AIState.START_WORKING), new AITarget(this::checkIfCanceled, AIState.IDLE), new AITarget(this::checkIfExecute, this::getState), new AITarget(AIState.START_WORKING, this::startWorkingAtOwnBuilding));
        this.worker.setSkillModifier(2 * this.worker.getCitizenData().getIntelligence() + 1 * this.worker.getCitizenData().getStrength());
        this.worker.func_98053_h(true);
    }

    @Override
    public Block getSolidSubstitution(BlockPos location) {
        IBlockState filler = this.world.func_180494_b((BlockPos)location).field_76753_B;
        if (filler.func_177230_c() instanceof BlockFalling) {
            return Blocks.field_150346_d;
        }
        return filler.func_177230_c();
    }

    private boolean checkIfCanceled() {
        WorkOrderBuild wo = ((JobBuilder)this.job).getWorkOrder();
        if (wo == null) {
            this.cancelTask();
            return true;
        }
        return false;
    }

    public void cancelTask() {
        super.func_75251_c();
        ((JobBuilder)this.job).setWorkOrder(null);
        this.workFrom = null;
        ((JobBuilder)this.job).setStructure(null);
    }

    private boolean checkIfExecute() {
        this.setDelay(1);
        if (!((JobBuilder)this.job).hasWorkOrder()) {
            return true;
        }
        WorkOrderBuild wo = ((JobBuilder)this.job).getWorkOrder();
        if (((JobBuilder)this.job).getColony().getBuilding(wo.getBuildingLocation()) == null && !(wo instanceof WorkOrderBuildDecoration)) {
            ((JobBuilder)this.job).complete();
            return true;
        }
        if (!((JobBuilder)this.job).hasStructure()) {
            this.initiate();
        }
        return false;
    }

    private void initiate() {
        if (!((JobBuilder)this.job).hasStructure()) {
            this.workFrom = null;
            this.loadStructure();
            WorkOrderBuild wo = ((JobBuilder)this.job).getWorkOrder();
            if (wo == null) {
                Log.getLogger().error(String.format("Builder (%d:%d) ERROR - Starting and missing work order(%d)", this.worker.getColony().getID(), this.worker.getCitizenData().getId(), ((JobBuilder)this.job).getWorkOrderId()));
                return;
            }
            if (wo instanceof WorkOrderBuildDecoration) {
                LanguageHandler.sendPlayersLocalizedMessage(this.worker.getColony().getMessageEntityPlayers(), "entity.builder.messageBuildStart", ((JobBuilder)this.job).getStructure().getName());
            } else {
                AbstractBuilding building = ((JobBuilder)this.job).getColony().getBuilding(wo.getBuildingLocation());
                if (building == null) {
                    Log.getLogger().error(String.format("Builder (%d:%d) ERROR - Starting and missing building(%s)", this.worker.getColony().getID(), this.worker.getCitizenData().getId(), wo.getBuildingLocation()));
                    return;
                }
                LanguageHandler.sendPlayersLocalizedMessage(this.worker.getColony().getMessageEntityPlayers(), "entity.builder.messageBuildStart", ((JobBuilder)this.job).getStructure().getName());
                if (building.getBuildingLevel() > 0) {
                    wo.setCleared(true);
                }
            }
        }
    }

    private AIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIState.START_BUILDING;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1024;
    }

    @Override
    protected boolean neededForWorker(@Nullable ItemStack stack) {
        return Utils.isMiningTool(stack);
    }
}

