/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.farmer;

import com.minecolonies.coremod.blocks.BlockHutField;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.BuildingFarmer;
import com.minecolonies.coremod.colony.jobs.JobFarmer;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.entity.ai.citizen.farmer.Field;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.util.BlockUtils;
import com.minecolonies.coremod.util.InventoryUtils;
import com.minecolonies.coremod.util.Utils;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkFarmer
extends AbstractEntityAIInteract<JobFarmer> {
    private static final int STANDARD_DELAY = 40;
    private static final int SMALLEST_DELAY = 5;
    private static final double DELAY_DIVIDER = 1.0;
    private static final double XP_PER_HARVEST = 0.5;
    private static final int LOOK_WAIT = 100;
    private boolean shouldDumpInventory = false;
    @Nullable
    private BlockPos workingOffset;
    private boolean requestSeeds = true;
    private boolean shouldTryToGetSeed = true;
    private int totalDis;
    private int dist;
    private boolean horizontal;

    public EntityAIWorkFarmer(@NotNull JobFarmer job) {
        super(job);
        super.registerTargets(new AITarget(AIState.IDLE, () -> AIState.START_WORKING), new AITarget(AIState.START_WORKING, this::startWorkingAtOwnBuilding), new AITarget(AIState.PREPARING, this::prepareForFarming), new AITarget(AIState.FARMER_INITIALIZE, this::initialize), new AITarget(AIState.FARMER_OBSERVE, this::lookAtField), new AITarget(AIState.FARMER_WORK, this::cycle));
        this.worker.setSkillModifier(2 * this.worker.getCitizenData().getEndurance() + this.worker.getCitizenData().getCharisma());
        this.worker.func_98053_h(true);
    }

    private AIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIState.PREPARING;
    }

    @NotNull
    private AIState prepareForFarming() {
        BuildingFarmer building = this.getOwnBuilding();
        if (building == null || building.getBuildingLevel() < 1) {
            return AIState.PREPARING;
        }
        building.syncWithColony(this.world);
        if (building.getFarmerFields().size() < this.getOwnBuilding().getBuildingLevel() && !building.assignManually()) {
            this.searchAndAddFields();
        }
        if (building.hasNoFields()) {
            this.chatSpamFilter.talkWithoutSpam("entity.farmer.noFreeFields", new String[0]);
            return AIState.PREPARING;
        }
        if (building.getCurrentField() == null && building.getFieldToWorkOn() == null) {
            building.resetFields();
            return AIState.IDLE;
        }
        Field currentField = building.getCurrentField();
        if (currentField.needsWork()) {
            if (currentField.isInitialized()) {
                this.walkToBlock(currentField.getLocation());
                return AIState.FARMER_OBSERVE;
            }
            if (this.canGoPlanting(currentField, building) && !this.checkForHoe()) {
                return this.walkToBlock(currentField.getLocation()) ? AIState.PREPARING : AIState.FARMER_INITIALIZE;
            }
            if (this.containsPlants(currentField) && !this.walkToBuilding() && !this.canGoPlanting(currentField, building)) {
                currentField.setInitialized(true);
                currentField.setNeedsWork(false);
            }
        } else {
            this.getOwnBuilding().setCurrentField(null);
        }
        return AIState.PREPARING;
    }

    private void searchAndAddFields() {
        Field newField;
        Colony colony = this.worker.getColony();
        if (colony != null && (newField = colony.getFreeField(this.worker.func_70005_c_())) != null && this.getOwnBuilding() != null) {
            this.getOwnBuilding().addFarmerFields(newField);
        }
    }

    private boolean canGoPlanting(@NotNull Field currentField, @NotNull BuildingFarmer buildingFarmer) {
        if (currentField.getSeed() == null) {
            this.chatSpamFilter.talkWithoutSpam("entity.farmer.noSeedSet", new String[0]);
            buildingFarmer.setCurrentField(null);
            return false;
        }
        if (this.shouldTryToGetSeed) {
            int slot = this.worker.findFirstSlotInInventoryWith(currentField.getSeed());
            ItemStack seeds = new ItemStack(currentField.getSeed());
            if (slot != -1) {
                this.requestSeeds = false;
            }
            if (!this.walkToBuilding()) {
                if (this.isInHut(seeds)) {
                    this.requestSeeds = false;
                    this.isInHut(seeds);
                }
                this.shouldTryToGetSeed = this.requestSeeds;
                if (this.requestSeeds) {
                    this.chatSpamFilter.talkWithoutSpam("entity.farmer.NeedSeed", currentField.getSeed().func_77653_i(seeds));
                }
            }
        }
        return !this.shouldTryToGetSeed;
    }

    private boolean containsPlants(Field field) {
        while (this.handleOffset(field)) {
            BlockPos position = field.getLocation().func_177977_b().func_177970_e(this.workingOffset.func_177952_p()).func_177965_g(this.workingOffset.func_177958_n());
            IBlockState blockState = this.world.func_180495_p(position.func_177984_a());
            if (!(blockState.func_177230_c() instanceof BlockCrops)) continue;
            return true;
        }
        return false;
    }

    private boolean handleOffset(@NotNull Field field) {
        if (this.workingOffset == null) {
            this.workingOffset = new BlockPos(0, 0, 0);
            this.totalDis = 1;
            this.dist = 0;
            this.horizontal = true;
        } else {
            if (this.workingOffset.func_177952_p() >= field.getWidthPlusZ() && this.workingOffset.func_177958_n() <= -field.getLengthMinusX()) {
                this.workingOffset = null;
                return false;
            }
            if (this.totalDis == this.dist) {
                this.horizontal = !this.horizontal;
                this.dist = 0;
                if (this.horizontal) {
                    ++this.totalDis;
                }
            }
            this.workingOffset = this.horizontal ? new BlockPos((double)this.workingOffset.func_177958_n(), 0.0, (double)this.workingOffset.func_177952_p() - Math.pow(-1.0, this.totalDis)) : new BlockPos((double)this.workingOffset.func_177958_n() - Math.pow(-1.0, this.totalDis), 0.0, (double)this.workingOffset.func_177952_p());
            ++this.dist;
        }
        return true;
    }

    private AIState cycle() {
        BuildingFarmer buildingFarmer = this.getOwnBuilding();
        if (buildingFarmer == null || this.checkForHoe() || buildingFarmer.getCurrentField() == null) {
            return AIState.PREPARING;
        }
        Field field = buildingFarmer.getCurrentField();
        if (this.workingOffset != null) {
            BlockPos position = field.getLocation().func_177977_b().func_177970_e(this.workingOffset.func_177952_p()).func_177965_g(this.workingOffset.func_177958_n());
            if (this.walkToBlock(position.func_177984_a())) {
                return AIState.FARMER_WORK;
            }
            if (this.harvestIfAble(position)) {
                this.setDelay(this.getLevelDelay());
            }
        }
        if (!this.handleOffsetHarvest(field)) {
            this.resetVariables();
            this.shouldDumpInventory = true;
            field.setNeedsWork(false);
            return AIState.IDLE;
        }
        return AIState.FARMER_WORK;
    }

    private boolean harvestIfAble(BlockPos position) {
        if (this.shouldHarvest(position)) {
            this.worker.addExperience(0.5);
            if (this.mineBlock(position.func_177984_a())) {
                this.world.func_175656_a(position, Blocks.field_150346_d.func_176223_P());
                return true;
            }
        }
        return false;
    }

    @Override
    protected int getLevelDelay() {
        return (int)Math.max(5.0, 40.0 - (double)this.worker.getLevel() * 1.0);
    }

    private boolean handleOffsetHarvest(@NotNull Field field) {
        if (this.workingOffset == null) {
            this.handleOffset(field);
        }
        BlockPos position = field.getLocation().func_177977_b().func_177970_e(this.workingOffset.func_177952_p()).func_177965_g(this.workingOffset.func_177958_n());
        while (!this.shouldHarvest(position)) {
            if (!this.handleOffset(field)) {
                return false;
            }
            position = field.getLocation().func_177977_b().func_177970_e(this.workingOffset.func_177952_p()).func_177965_g(this.workingOffset.func_177958_n());
        }
        return true;
    }

    private void resetVariables() {
        this.requestSeeds = true;
        this.shouldTryToGetSeed = true;
    }

    private boolean shouldHarvest(@NotNull BlockPos position) {
        IBlockState state = this.world.func_180495_p(position.func_177984_a());
        if (state.func_177230_c() instanceof IGrowable && state.func_177230_c() instanceof BlockCrops) {
            BlockCrops block = (BlockCrops)state.func_177230_c();
            return !block.func_176473_a(this.world, position.func_177984_a(), state, false);
        }
        return false;
    }

    private AIState initialize() {
        BuildingFarmer buildingFarmer = this.getOwnBuilding();
        if (buildingFarmer == null || this.checkForHoe() || buildingFarmer.getCurrentField() == null) {
            return AIState.PREPARING;
        }
        Field field = buildingFarmer.getCurrentField();
        if (this.workingOffset != null) {
            BlockPos position = field.getLocation().func_177977_b().func_177970_e(this.workingOffset.func_177952_p()).func_177965_g(this.workingOffset.func_177958_n());
            if (this.walkToBlock(position.func_177984_a())) {
                return AIState.FARMER_INITIALIZE;
            }
            IBlockState blockState = this.world.func_180495_p(position.func_177984_a());
            if (blockState.func_177230_c() instanceof IGrowable && (!(blockState.func_177230_c() instanceof BlockCrops) || ((BlockCrops)blockState.func_177230_c()).func_185473_a(this.world, position.func_177984_a(), blockState) != new ItemStack(field.getSeed()))) {
                this.mineBlock(position.func_177984_a());
                this.setDelay(this.getLevelDelay());
                return AIState.FARMER_INITIALIZE;
            }
            if (this.hoeIfAble(position, field)) {
                this.setDelay(this.getLevelDelay());
                return AIState.FARMER_INITIALIZE;
            }
            if (this.shouldPlant(position, field) && !this.plantCrop(field.getSeed(), position)) {
                this.resetVariables();
                return AIState.PREPARING;
            }
        }
        if (!this.handleOffset(field)) {
            this.resetVariables();
            this.shouldDumpInventory = true;
            field.setInitialized(true);
            field.setNeedsWork(false);
            return AIState.IDLE;
        }
        this.setDelay(this.getLevelDelay());
        return AIState.FARMER_INITIALIZE;
    }

    private boolean hoeIfAble(BlockPos position, Field field) {
        if (this.shouldHoe(position, field)) {
            this.equipHoe();
            this.worker.func_184609_a(this.worker.func_184600_cs());
            this.world.func_175656_a(position, Blocks.field_150458_ak.func_176223_P());
            this.worker.damageItemInHand(1);
            this.mineBlock(position.func_177984_a());
            return true;
        }
        return false;
    }

    private boolean shouldPlant(@NotNull BlockPos position, @NotNull Field field) {
        ItemStack itemStack = BlockUtils.getItemStackFromBlockState(this.world.func_180495_p(position.func_177984_a()));
        if (itemStack != null && itemStack.func_77973_b() == field.getSeed()) {
            this.requestSeeds = false;
        }
        return !field.isNoPartOfField(this.world, position) && !(this.world.func_180495_p(position.func_177984_a()).func_177230_c() instanceof BlockCrops) && !(this.world.func_180495_p(position).func_177230_c() instanceof BlockHutField) && this.world.func_180495_p(position).func_177230_c() == Blocks.field_150458_ak;
    }

    private boolean plantCrop(Item item, @NotNull BlockPos position) {
        int slot = this.worker.findFirstSlotInInventoryWith(item);
        if (slot == -1) {
            return false;
        }
        IPlantable seed = (IPlantable)item;
        this.world.func_175656_a(position.func_177984_a(), seed.getPlant((IBlockAccess)this.world, position));
        this.getInventory().func_70298_a(slot, 1);
        this.requestSeeds = false;
        return true;
    }

    private boolean shouldHoe(@NotNull BlockPos position, @NotNull Field field) {
        return !field.isNoPartOfField(this.world, position) && !BlockUtils.isBlockSeed(this.world, position.func_177984_a()) && !(this.world.func_180495_p(position).func_177230_c() instanceof BlockHutField) && (this.world.func_180495_p(position).func_177230_c() == Blocks.field_150346_d || this.world.func_180495_p(position).func_177230_c() == Blocks.field_150349_c);
    }

    private void equipHoe() {
        this.worker.setHeldItem(this.getHoeSlot());
    }

    private int getHoeSlot() {
        return InventoryUtils.getFirstSlotContainingTool(this.getInventory(), "hoe");
    }

    private AIState lookAtField() {
        BuildingFarmer buildingFarmer = this.getOwnBuilding();
        if (buildingFarmer == null || this.checkForHoe() || buildingFarmer.getCurrentField() == null) {
            return AIState.PREPARING;
        }
        Field field = buildingFarmer.getCurrentField();
        this.setDelay(100);
        if (this.handleOffsetHarvest(field)) {
            return AIState.FARMER_WORK;
        }
        if (this.containsPlants(field)) {
            field.setNeedsWork(false);
            return AIState.PREPARING;
        }
        field.setInitialized(false);
        return AIState.PREPARING;
    }

    @Override
    protected boolean wantInventoryDumped() {
        if (this.shouldDumpInventory) {
            this.shouldDumpInventory = false;
            return true;
        }
        return false;
    }

    @Override
    protected BuildingFarmer getOwnBuilding() {
        return (BuildingFarmer)this.worker.getWorkBuilding();
    }

    @Override
    protected boolean neededForWorker(@Nullable ItemStack stack) {
        return stack != null && Utils.isHoe(stack);
    }

    @Nullable
    public EntityCitizen getCitizen() {
        return this.worker;
    }
}

