/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.coremod.colony.jobs.JobGuard;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.util.InventoryFunctions;
import com.minecolonies.coremod.util.Utils;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import org.jetbrains.annotations.NotNull;

public class EntityAIMeleeGuard
extends AbstractEntityAIGuard {
    private static final int BASE_RELOAD_TIME = 30;
    private static final double PITCH_DIVIDER = 1.0;
    private static final double BASE_PITCH = 0.8;
    private static final double PITCH_MULTIPLIER = 0.4;
    private static final double MOVE_MINIMAL = 0.01;
    private static final double TURN_AROUND = 180.0;
    private static final double BASIC_VOLUME = 1.0;
    private static final double XP_EACH_HIT = 0.2;
    private static final int BASE_FOLLOW_SPEED = 1;
    private static final double BASE_FOLLOW_SPEED_MULTIPLIER = 0.25;
    private static final double MIN_ATTACK_DISTANCE = 2.0;
    private static final double DAMAGE_PER_ATTACK = 0.5;
    private static final int FIRE_CHANCE_MULTIPLIER = 4;

    public EntityAIMeleeGuard(@NotNull JobGuard job) {
        super(job);
        super.registerTargets(new AITarget(AIState.GUARD_SEARCH_TARGET, this::searchTarget), new AITarget(AIState.GUARD_GET_TARGET, this::getTarget), new AITarget(AIState.GUARD_HUNT_DOWN_TARGET, this::huntDown), new AITarget(AIState.GUARD_PATROL, this::patrol), new AITarget(AIState.GUARD_RESTOCK, this::goToBuilding));
        if (this.worker.getCitizenData() != null) {
            this.worker.setSkillModifier(2 * this.worker.getCitizenData().getStrength() + this.worker.getCitizenData().getEndurance());
            this.worker.func_98053_h(true);
        }
    }

    @Override
    protected AIState searchTarget() {
        if (this.checkForWeapon()) {
            return AIState.GUARD_SEARCH_TARGET;
        }
        InventoryFunctions.matchFirstInInventory(this.worker.getInventoryCitizen(), stack -> stack != null && Utils.doesItemServeAsWeapon(stack), this.worker::setHeldItem);
        return super.searchTarget();
    }

    protected AIState huntDown() {
        if (!this.targetEntity.func_70089_S() || this.checkForWeapon()) {
            this.targetEntity = null;
            this.worker.func_70659_e(1.0f);
            return AIState.GUARD_GATHERING;
        }
        if (this.worker.func_70635_at().func_75522_a((Entity)this.targetEntity) && (double)this.worker.func_70032_d((Entity)this.targetEntity) <= 2.0) {
            this.worker.func_184602_cy();
            this.attackEntity(this.targetEntity, 0.5f);
            this.setDelay(this.getReloadTime());
            ++this.attacksExecuted;
            this.currentSearchDistance = 5;
            if (this.attacksExecuted >= this.getMaxAttacksUntilRestock()) {
                return AIState.GUARD_RESTOCK;
            }
            return AIState.GUARD_HUNT_DOWN_TARGET;
        }
        if (this.shouldReturnToTarget(this.targetEntity.func_180425_c(), 10.0)) {
            return AIState.GUARD_PATROL;
        }
        this.worker.func_70659_e((float)(1.0 + 0.25 * (double)this.worker.getExperienceLevel()));
        this.worker.isWorkerAtSiteWithMove(this.targetEntity.func_180425_c(), 2);
        return AIState.GUARD_SEARCH_TARGET;
    }

    private void attackEntity(@NotNull EntityLivingBase entityToAttack, float baseDamage) {
        ItemStack heldItem;
        double damgeToBeDealt = baseDamage;
        if (this.worker.func_110143_aJ() <= 2.0f) {
            damgeToBeDealt *= 2.0;
        }
        if ((heldItem = this.worker.func_184586_b(EnumHand.MAIN_HAND)) != null) {
            if (heldItem.func_77973_b() instanceof ItemSword) {
                damgeToBeDealt += (double)((ItemSword)heldItem.func_77973_b()).func_150931_i();
            }
            damgeToBeDealt += (double)EnchantmentHelper.func_152377_a((ItemStack)heldItem, (EnumCreatureAttribute)this.targetEntity.func_70668_bt());
        }
        this.targetEntity.func_70097_a(new DamageSource(this.worker.func_70005_c_()), (float)damgeToBeDealt);
        this.targetEntity.func_70604_c((EntityLivingBase)this.worker);
        int fireAspectModifier = EnchantmentHelper.func_90036_a((EntityLivingBase)this.worker);
        if (fireAspectModifier > 0) {
            this.targetEntity.func_70015_d(fireAspectModifier * 4);
        }
        this.worker.addExperience(0.2);
        if (this.targetEntity.func_110143_aJ() <= 0.0f) {
            this.onKilledEntity(this.targetEntity);
        }
        this.worker.func_70625_a((Entity)entityToAttack, 180.0f, 180.0f);
        this.worker.func_70671_ap().func_75651_a((Entity)entityToAttack, 180.0f, 180.0f);
        double xDiff = this.targetEntity.field_70165_t - this.worker.field_70165_t;
        double zDiff = this.targetEntity.field_70161_v - this.worker.field_70161_v;
        double goToX = xDiff > 0.0 ? 0.01 : -0.01;
        double goToZ = zDiff > 0.0 ? 0.01 : -0.01;
        this.worker.func_70091_d(goToX, 0.0, goToZ);
        this.worker.func_184609_a(EnumHand.MAIN_HAND);
        this.worker.func_184185_a(SoundEvents.field_187730_dW, 1.0f, (float)this.getRandomPitch());
        this.worker.damageItemInHand(1);
    }

    private int getReloadTime() {
        return 30 / (this.worker.getExperienceLevel() + 1);
    }

    private double getRandomPitch() {
        return 1.0 / (this.worker.func_70681_au().nextDouble() * 0.4 + 0.8);
    }
}

