/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.util;

import com.minecolonies.coremod.entity.EntityCitizen;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ChatSpamFilter {
    protected static final int BASE_TIMEOUT = 600;
    protected static final int MAX_TIMEOUT = 12000;
    private final EntityCitizen worker;
    private int speechDelay = 0;
    @NotNull
    private String speechDelayString = "";
    private int speechRepeat = 0;

    public ChatSpamFilter(EntityCitizen worker) {
        this.worker = worker;
    }

    public void requestWithoutSpam(@NotNull String chat) {
        this.talkWithoutSpam("entity.miner.messageNeedBlockAndItem", chat);
    }

    public void talkWithoutSpam(String key, String ... chat) {
        String curstring = key + Arrays.toString(chat);
        if (Objects.equals(this.speechDelayString, curstring)) {
            if (this.speechDelay > this.worker.getOffsetTicks()) {
                return;
            }
            if (600 << this.speechRepeat < 12000) {
                ++this.speechRepeat;
            }
        } else {
            this.speechRepeat = 0;
        }
        this.worker.sendLocalizedChat(key, chat);
        this.speechDelayString = key + Arrays.toString(chat);
        this.speechDelay = Math.min(600 << this.speechRepeat, 12000) + this.worker.getOffsetTicks();
    }
}

