/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding;

import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.BuildingMiner;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.citizen.miner.Level;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.EntityUtils;
import java.util.ArrayList;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class WalkToProxy {
    private static final int MIN_RANGE_FOR_DIRECT_PATH = 400;
    private static final int MIN_DISTANCE = 25;
    private final EntityCitizen worker;
    private BlockPos currentProxy;
    private ArrayList<BlockPos> proxyList = new ArrayList();

    public WalkToProxy(EntityCitizen worker) {
        this.worker = worker;
    }

    public boolean walkToBlock(@NotNull BlockPos target, int range) {
        return this.walkToBlock(target, range, false);
    }

    private boolean takeTheDirectPath(@NotNull BlockPos target, int range, boolean onMove) {
        if (onMove) {
            return EntityUtils.isWorkerAtSiteWithMove(this.worker, target.func_177958_n(), target.func_177956_o(), target.func_177952_p(), range) || EntityUtils.isWorkerAtSite(this.worker, target.func_177958_n(), target.func_177956_o(), target.func_177952_p(), range + 1);
        }
        return !EntityUtils.isWorkerAtSite(this.worker, target.func_177958_n(), target.func_177956_o(), target.func_177952_p(), range);
    }

    public boolean walkToBlock(@NotNull BlockPos target, int range, boolean onMove) {
        double distanceProxyNextProxy;
        double distanceToPath = BlockPosUtil.getDistanceSquared(this.worker.func_180425_c(), target);
        if (distanceToPath <= 400.0) {
            this.currentProxy = distanceToPath <= 25.0 ? null : target;
            this.proxyList = new ArrayList();
            return this.takeTheDirectPath(target, range, onMove);
        }
        if (this.currentProxy == null) {
            this.currentProxy = this.fillProxyList(target, distanceToPath);
        }
        double distanceToProxy = BlockPosUtil.getDistanceSquared2D(this.worker.func_180425_c(), this.currentProxy);
        double distanceToNextProxy = this.proxyList.isEmpty() ? (double)BlockPosUtil.getDistanceSquared2D(this.worker.func_180425_c(), target) : (double)BlockPosUtil.getDistanceSquared2D(this.worker.func_180425_c(), this.proxyList.get(0));
        double d = distanceProxyNextProxy = this.proxyList.isEmpty() ? (double)BlockPosUtil.getDistanceSquared2D(this.currentProxy, target) : (double)BlockPosUtil.getDistanceSquared2D(this.currentProxy, this.proxyList.get(0));
        if (distanceToProxy < 25.0 || distanceToNextProxy < distanceProxyNextProxy) {
            if (this.proxyList.isEmpty()) {
                this.currentProxy = target;
            }
            if (this.proxyList.isEmpty()) {
                return this.takeTheDirectPath(target, range, onMove);
            }
            this.worker.getNavigator().func_75499_g();
            this.currentProxy = this.proxyList.get(0);
            this.proxyList.remove(0);
        }
        if (this.currentProxy != null && !EntityUtils.isWorkerAtSiteWithMove(this.worker, this.currentProxy.func_177958_n(), this.currentProxy.func_177956_o(), this.currentProxy.func_177952_p(), range)) {
            return !onMove;
        }
        return !onMove;
    }

    @NotNull
    private BlockPos fillProxyList(@NotNull BlockPos target, double distanceToPath) {
        BlockPos proxyPoint = this.worker.getColonyJob() != null && this.worker.getColonyJob() instanceof JobMiner ? this.getMinerProxy(target, distanceToPath) : this.getProxy(target, this.worker.func_180425_c(), distanceToPath);
        if (!this.proxyList.isEmpty()) {
            this.proxyList.remove(0);
        }
        return proxyPoint;
    }

    @NotNull
    private BlockPos getMinerProxy(BlockPos target, double distanceToPath) {
        AbstractBuildingWorker building = this.worker.getWorkBuilding();
        if (building == null || !(building instanceof BuildingMiner)) {
            return this.getProxy(target, this.worker.func_180425_c(), distanceToPath);
        }
        ((BuildingMiner)building).getLadderLocation();
        Level level = ((BuildingMiner)building).getCurrentLevel();
        BlockPos ladderPos = ((BuildingMiner)building).getLadderLocation();
        if (level != null) {
            int levelDepth = level.getDepth() + 2;
            int targetY = target.func_177956_o();
            int workerY = this.worker.func_180425_c().func_177956_o();
            if (workerY <= levelDepth && targetY > levelDepth) {
                this.proxyList.add(new BlockPos(ladderPos.func_177958_n(), level.getDepth(), ladderPos.func_177952_p()));
                return this.getProxy(target, this.worker.func_180425_c(), distanceToPath);
            }
            if (targetY <= levelDepth && workerY > levelDepth) {
                BlockPos buildingPos = building.getLocation();
                BlockPos newProxy = this.getProxy(buildingPos, this.worker.func_180425_c(), BlockPosUtil.getDistanceSquared(this.worker.func_180425_c(), buildingPos));
                this.proxyList.add(new BlockPos(ladderPos.func_177958_n(), level.getDepth(), ladderPos.func_177952_p()));
                return newProxy;
            }
            if (targetY <= levelDepth) {
                return target;
            }
        }
        return this.getProxy(target, this.worker.func_180425_c(), distanceToPath);
    }

    @NotNull
    private BlockPos getProxy(@NotNull BlockPos target, @NotNull BlockPos position, double distanceToPath) {
        if (this.worker.getColony() == null) {
            return target;
        }
        double weight = Double.MAX_VALUE;
        BlockPos proxyPoint = null;
        for (BlockPos wayPoint : this.worker.getColony().getWayPoints(position, target)) {
            double simpleDistance = BlockPosUtil.getDistanceSquared(position, wayPoint);
            double currentWeight = simpleDistance * simpleDistance + (double)BlockPosUtil.getDistanceSquared(wayPoint, target);
            if (!(currentWeight < weight) || !((double)BlockPosUtil.getDistanceSquared2D(wayPoint, target) < distanceToPath) || !(simpleDistance > 25.0) || !(simpleDistance < distanceToPath) || this.proxyList.contains(proxyPoint)) continue;
            proxyPoint = wayPoint;
            weight = currentWeight;
        }
        if (this.proxyList.contains(proxyPoint)) {
            proxyPoint = null;
        }
        if (proxyPoint != null) {
            this.proxyList.add(proxyPoint);
            this.getProxy(target, proxyPoint, distanceToPath);
            return this.proxyList.get(0);
        }
        return target;
    }
}

