/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.LanguageHandler;
import com.minecolonies.coremod.util.Log;
import com.minecolonies.coremod.util.Utils;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecallCitizenMessage
extends AbstractMessage<RecallCitizenMessage, IMessage> {
    private static final double MIDDLE_BLOCK_OFFSET = 0.5;
    private int colonyId;
    private BlockPos buildingId;

    public RecallCitizenMessage() {
    }

    public RecallCitizenMessage(@NotNull AbstractBuildingWorker.View building) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
    }

    @Override
    public void messageOnServerThread(RecallCitizenMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Permissions.Action.MANAGE_HUTS)) {
                return;
            }
            AbstractBuildingWorker building = colony.getBuilding(message.buildingId, AbstractBuildingWorker.class);
            if (building != null) {
                BlockPos loc = building.getLocation();
                CitizenData citizenData = building.getWorker();
                if (citizenData != null) {
                    EntityCitizen citizen = building.getWorkerEntity();
                    if (citizen == null) {
                        Log.getLogger().warn(String.format("Citizen #%d:%d has gone AWOL, respawning them!", colony.getID(), citizenData.getId()));
                        colony.spawnCitizen(citizenData);
                    }
                    citizen = citizenData.getCitizenEntity();
                    World world = colony.getWorld();
                    if (citizen != null && world != null) {
                        BlockPos spawnPoint = Utils.scanForBlockNearPoint(world, loc, 1, 0, 1, 2, new Block[]{Blocks.field_150350_a, Blocks.field_150431_aC, Blocks.field_150329_H, Blocks.field_150328_O, Blocks.field_150327_N});
                        RecallCitizenMessage.setSpawnPoint(spawnPoint, citizen, (EntityPlayer)player);
                    }
                }
            }
        }
    }

    private static void setSpawnPoint(@Nullable BlockPos spawnPoint, @NotNull EntityCitizen citizen, @NotNull EntityPlayer player) {
        if (spawnPoint == null) {
            LanguageHandler.sendPlayerMessage(player, LanguageHandler.format("com.minecolonies.coremod.workerHuts.recallFail", new Object[0]));
            return;
        }
        citizen.func_70012_b((double)spawnPoint.func_177958_n() + 0.5, spawnPoint.func_177956_o(), (double)spawnPoint.func_177952_p() + 0.5, citizen.field_70177_z, citizen.field_70125_A);
        citizen.getNavigator().func_75499_g();
    }
}

