/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.util.ClientStructureWrapper;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveScanMessage
implements IMessage,
IMessageHandler<SaveScanMessage, IMessage> {
    private NBTTagCompound nbttagcompound;
    private String storeLocation;

    public SaveScanMessage() {
    }

    public SaveScanMessage(NBTTagCompound nbttagcompound, String storeAt) {
        this.nbttagcompound = nbttagcompound;
        this.storeLocation = storeAt;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.nbttagcompound = ByteBufUtils.readTag((ByteBuf)buf);
        this.storeLocation = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbttagcompound);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.storeLocation);
    }

    @Nullable
    public IMessage onMessage(@NotNull SaveScanMessage message, MessageContext ctx) {
        ClientStructureWrapper.handleSaveScanMessage(message.nbttagcompound, message.storeLocation);
        return null;
    }
}

