/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.permissions;

import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.permissions.Permissions;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ColonyPermissionEventHandler {
    private final Colony colony;

    public ColonyPermissionEventHandler(Colony colony) {
        this.colony = colony;
    }

    @SubscribeEvent
    public void on(BlockEvent.PlaceEvent event) {
        if (this.checkBlockEventDenied(event.getWorld(), event.getPos(), event.getPlayer(), event.getPlacedBlock())) {
            ColonyPermissionEventHandler.cancelEvent((Event)event);
        }
    }

    private boolean checkBlockEventDenied(World worldIn, BlockPos posIn, EntityPlayer playerIn, IBlockState blockState) {
        if (this.colony.isCoordInColony(worldIn, posIn)) {
            if (!this.colony.getPermissions().isColonyMember(playerIn)) {
                return true;
            }
            Permissions.Rank rank = this.colony.getPermissions().getRank(playerIn);
            if (rank.ordinal() >= Permissions.Rank.FRIEND.ordinal()) {
                return true;
            }
            if (blockState.func_177230_c() instanceof AbstractBlockHut && rank.ordinal() >= Permissions.Rank.OFFICER.ordinal()) {
                return true;
            }
        }
        return false;
    }

    private static void cancelEvent(Event event) {
        event.setResult(Event.Result.DENY);
        if (event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void on(BlockEvent.BreakEvent event) {
        if (this.checkBlockEventDenied(event.getWorld(), event.getPos(), event.getPlayer(), event.getWorld().func_180495_p(event.getPos()))) {
            ColonyPermissionEventHandler.cancelEvent((Event)event);
        }
    }

    @SubscribeEvent
    public void on(ExplosionEvent.Detonate event) {
        World eventWorld = event.getWorld();
        Predicate<BlockPos> getBlocksInColony = pos -> this.colony.isCoordInColony(eventWorld, (BlockPos)pos);
        Predicate<Entity> getEntitiesInColony = entity -> this.colony.isCoordInColony(entity.func_130014_f_(), entity.func_180425_c());
        List blocksToRemove = event.getAffectedBlocks().stream().filter(getBlocksInColony).collect(Collectors.toList());
        List entitiesToRemove = event.getAffectedEntities().stream().filter(getEntitiesInColony).collect(Collectors.toList());
        event.getAffectedBlocks().removeAll(blocksToRemove);
        event.getAffectedEntities().removeAll(entitiesToRemove);
    }

    @SubscribeEvent
    public void on(ExplosionEvent.Start event) {
        if (this.colony.isCoordInColony(event.getWorld(), new BlockPos(event.getExplosion().getPosition()))) {
            ColonyPermissionEventHandler.cancelEvent((Event)event);
        }
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent event) {
        Block block;
        if (this.colony.isCoordInColony(event.getWorld(), event.getPos()) && (block = event.getWorld().func_180495_p(event.getPos()).func_177230_c()) instanceof AbstractBlockHut && !this.colony.getPermissions().hasPermission(event.getEntityPlayer(), Permissions.Action.ACCESS_HUTS)) {
            ColonyPermissionEventHandler.cancelEvent((Event)event);
        }
    }

    @SubscribeEvent
    public void on(PlayerContainerEvent.Open event) {
        Permissions.Rank rank;
        if (this.colony.isCoordInColony(event.getEntity().func_130014_f_(), event.getEntity().func_180425_c()) && (rank = this.colony.getPermissions().getRank(event.getEntityPlayer())).ordinal() >= Permissions.Rank.FRIEND.ordinal()) {
            ColonyPermissionEventHandler.cancelEvent((Event)event);
        }
    }

    @SubscribeEvent
    public void on(ItemTossEvent event) {
        Permissions.Rank rank;
        EntityPlayer playerIn = event.getPlayer();
        if (this.colony.isCoordInColony(playerIn.func_130014_f_(), playerIn.func_180425_c()) && (rank = this.colony.getPermissions().getRank(playerIn)).ordinal() > Permissions.Rank.NEUTRAL.ordinal()) {
            ColonyPermissionEventHandler.cancelEvent((Event)event);
        }
    }

    public void on() {
    }
}

