/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.inventory.InventoryField;
import com.minecolonies.coremod.util.EntityUtils;
import com.minecolonies.coremod.util.LanguageHandler;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ScarecrowTileEntity
extends TileEntityChest {
    private static final String TAG_TYPE = "type";
    private static final String TAG_NAME = "name";
    private final Random random = new Random();
    private InventoryField inventoryField;
    private ScareCrowType type;
    private String name = LanguageHandler.format("com.minecolonies.coremod.gui.scarecrow.user", LanguageHandler.format("com.minecolonies.coremod.gui.scarecrow.user.noone", new Object[0]));

    public ScarecrowTileEntity() {
        this.inventoryField = new InventoryField(this.name);
    }

    public String getDesc() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @NotNull
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, tag);
    }

    public void onDataPacket(NetworkManager net, @NotNull SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void onLoad() {
        Entity entity;
        super.onLoad();
        World world = this.func_145831_w();
        Colony colony = ColonyManager.getColony(world, this.field_174879_c);
        if (colony != null && colony.getField(this.field_174879_c) == null && (entity = EntityUtils.getEntityFromUUID(world, colony.getPermissions().getOwner())) instanceof EntityPlayer) {
            colony.addNewField(this, ((EntityPlayer)entity).field_71071_by, this.field_174879_c, world);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.type = ScareCrowType.values()[compound.func_74762_e(TAG_TYPE)];
        this.getInventoryField().readFromNBT(compound);
        this.name = compound.func_74779_i(TAG_NAME);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a(TAG_TYPE, this.getType().ordinal());
        this.getInventoryField().writeToNBT(compound);
        compound.func_74778_a(TAG_NAME, this.name);
        return compound;
    }

    public ScareCrowType getType() {
        if (this.type == null) {
            this.type = ScareCrowType.values()[this.random.nextInt(2)];
        }
        return this.type;
    }

    public InventoryField getInventoryField() {
        return this.inventoryField;
    }

    public final void setInventoryField(InventoryField inventoryField) {
        this.inventoryField = inventoryField;
    }

    public static enum ScareCrowType {
        PUMPKINHEAD,
        NORMAL;

    }
}

