/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.coremod.util.LanguageHandler;
import com.minecolonies.coremod.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public final class ClientStructureWrapper {
    private ClientStructureWrapper() {
    }

    public static void handleSaveScanMessage(NBTTagCompound nbttagcompound, String storeLocation) {
        File file = new File(Minecraft.func_71410_x().field_71412_D, storeLocation);
        ClientStructureWrapper.createScanDirectory((World)Minecraft.func_71410_x().field_71441_e);
        try (FileOutputStream outputstream = new FileOutputStream(file);){
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound, (OutputStream)outputstream);
        }
        catch (IOException e) {
            LanguageHandler.sendPlayerLocalizedMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, LanguageHandler.format("item.scepterSteel.scanFailure", new Object[0]), new Object[0]);
            Log.getLogger().warn("Exception while trying to scan.", (Throwable)e);
            return;
        }
        LanguageHandler.sendPlayerLocalizedMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, LanguageHandler.format("item.scepterSteel.scanSuccess", storeLocation), new Object[0]);
    }

    private static void createScanDirectory(@NotNull World world) {
        File minecolonies;
        if (world.field_72995_K) {
            minecolonies = new File(Minecraft.func_71410_x().field_71412_D, "minecolonies/");
        } else {
            MinecraftServer server = world.func_73046_m();
            if (server == null) {
                return;
            }
            minecolonies = server.func_71209_f("minecolonies/");
        }
        ClientStructureWrapper.checkDirectory(minecolonies);
        File scans = new File(minecolonies, "scans/");
        ClientStructureWrapper.checkDirectory(scans);
    }

    private static void checkDirectory(@NotNull File directory) {
        if (!directory.exists() && !directory.mkdirs()) {
            Log.getLogger().error("Directory doesn't exist and failed to be created: " + directory.toString());
        }
    }
}

