/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.coremod.inventory.InventoryCitizen;
import com.minecolonies.coremod.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryUtils {
    public static final int FREE_TOOL_CHOICE_LEVEL = 4;
    public static final int EFFECT_TOOL_CHOICE_LEVEL = 2;

    private InventoryUtils() {
    }

    @NotNull
    public static List<ItemStack> getInventoryAsList(@NotNull IInventory inventory) {
        ArrayList<ItemStack> filtered = new ArrayList<ItemStack>();
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack stack = inventory.func_70301_a(slot);
            if (stack == null) continue;
            filtered.add(inventory.func_70301_a(slot));
        }
        return filtered;
    }

    @NotNull
    public static List<ItemStack> filterInventory(@NotNull IInventory inventory, Block block) {
        return InventoryUtils.filterInventory(inventory, InventoryUtils.getItemFromBlock(block));
    }

    @NotNull
    public static List<ItemStack> filterInventory(@NotNull IInventory inventory, @Nullable Item targetItem) {
        ArrayList<ItemStack> filtered = new ArrayList<ItemStack>();
        if (targetItem == null) {
            return filtered;
        }
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack stack = inventory.func_70301_a(slot);
            if (!InventoryUtils.compareItems(stack, targetItem)) continue;
            filtered.add(stack);
        }
        return filtered;
    }

    public static Item getItemFromBlock(Block block) {
        return new ItemStack(block).func_77973_b();
    }

    private static boolean compareItems(@Nullable ItemStack itemStack, Item targetItem) {
        return itemStack != null && itemStack.func_77973_b() == targetItem;
    }

    public static int findFirstSlotInInventoryWith(@NotNull IInventory inventory, Block block) {
        return InventoryUtils.findFirstSlotInInventoryWith(inventory, InventoryUtils.getItemFromBlock(block));
    }

    public static int findFirstSlotInInventoryWith(@NotNull IInventory inventory, Item targetItem) {
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            if (!InventoryUtils.compareItems(inventory.func_70301_a(slot), targetItem)) continue;
            return slot;
        }
        return -1;
    }

    public static int getItemCountInInventory(@NotNull IInventory inventory, Block block) {
        return InventoryUtils.getItemCountInInventory(inventory, InventoryUtils.getItemFromBlock(block));
    }

    public static int getItemCountInInventory(@NotNull IInventory inventory, Item targetitem) {
        int count = 0;
        for (ItemStack is : InventoryUtils.filterInventory(inventory, targetitem)) {
            count += is.field_77994_a;
        }
        return count;
    }

    public static boolean hasitemInInventory(@NotNull IInventory inventory, Block block) {
        return InventoryUtils.hasitemInInventory(inventory, InventoryUtils.getItemFromBlock(block));
    }

    public static boolean hasitemInInventory(@NotNull IInventory inventory, Item item) {
        return InventoryUtils.getItemCountInInventory(inventory, item) > 0;
    }

    public static boolean isInventoryFull(@NotNull IInventory inventory) {
        return InventoryUtils.getOpenSlot(inventory) == -1;
    }

    public static int getOpenSlot(@NotNull IInventory inventory) {
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            if (inventory.func_70301_a(slot) != null) continue;
            return slot;
        }
        return -1;
    }

    public static boolean takeStackInSlot(IInventory sendingInv, IInventory receivingInv, int slotID) {
        return InventoryUtils.takeStackInSlot(sendingInv, receivingInv, slotID, 1, true);
    }

    public static boolean takeStackInSlot(@Nullable IInventory sendingInv, @Nullable IInventory receivingInv, int slotID, int amount, boolean takeAll) {
        ItemStack stack;
        if (receivingInv != null && sendingInv != null && slotID >= 0 && amount >= 0 && (stack = sendingInv.func_70298_a(slotID, amount)) != null) {
            if ((stack = InventoryUtils.setStack(receivingInv, stack)) == null) {
                if (takeAll && (stack = sendingInv.func_70301_a(slotID)) != null) {
                    stack = sendingInv.func_70298_a(slotID, stack.field_77994_a);
                    stack = InventoryUtils.setStack(receivingInv, stack);
                    InventoryUtils.setStack(sendingInv, stack);
                }
                return true;
            }
            InventoryUtils.setStack(sendingInv, stack);
            return false;
        }
        return false;
    }

    @Nullable
    public static ItemStack setStack(@NotNull IInventory inventory, @Nullable ItemStack stack) {
        if (stack != null) {
            int slot;
            ItemStack returnStack = stack.func_77946_l();
            while ((slot = InventoryUtils.containsPartialStack(inventory, stack)) != -1 && returnStack != null) {
                ItemStack current = inventory.func_70301_a(slot);
                int spaceLeft = current.func_77976_d() - current.field_77994_a;
                if (spaceLeft <= 0) continue;
                ItemStack toBeAdded = returnStack.func_77979_a(Math.min(returnStack.field_77994_a, spaceLeft));
                if (returnStack.field_77994_a == 0) {
                    returnStack = null;
                }
                current.field_77994_a += toBeAdded.field_77994_a;
                inventory.func_70299_a(slot, current);
            }
            while ((slot = InventoryUtils.getOpenSlot(inventory)) != -1 && returnStack != null) {
                inventory.func_70299_a(slot, returnStack);
                if (returnStack.field_77994_a > inventory.func_70297_j_()) {
                    returnStack.field_77994_a -= inventory.func_70297_j_();
                    continue;
                }
                returnStack = null;
            }
            return returnStack;
        }
        return null;
    }

    public static int containsPartialStack(@NotNull IInventory inventory, ItemStack stack) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack testStack = inventory.func_70301_a(i);
            if (testStack == null || !testStack.func_77969_a(stack) || testStack.field_77994_a == testStack.func_77976_d()) continue;
            return i;
        }
        return -1;
    }

    public static boolean takeStackInSlot(IInventory sendingInv, IInventory receivingInv, int slotID, int amount) {
        return InventoryUtils.takeStackInSlot(sendingInv, receivingInv, slotID, amount, false);
    }

    @NotNull
    public static ItemStack[] getAllItemStacks(@NotNull IInventory inventory) {
        ItemStack[] itemStack = new ItemStack[inventory.func_70302_i_()];
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            itemStack[i] = inventory.func_70301_a(i);
        }
        return itemStack;
    }

    public static int getAmountOfStacks(@NotNull IInventory inventory) {
        int count = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack is = inventory.func_70301_a(i);
            if (is == null) continue;
            ++count;
        }
        return count;
    }

    public static void clear(@NotNull IInventory inventory) {
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            inventory.func_70299_a(slot, null);
        }
    }

    public static int getFirstSlotContainingTool(@NotNull IInventory inventory, @NotNull String tool) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (item == null || !item.func_77973_b().getToolClasses(item).contains(tool) && (!"hoe".equals(tool) || !item.func_77977_a().contains("hoe")) && (!"rod".equals(tool) || !item.func_77977_a().contains("fishingRod"))) continue;
            return i;
        }
        return -1;
    }

    public static boolean addItemStackToInventory(@NotNull IInventory inventory, @Nullable ItemStack itemStack) {
        if (itemStack != null && itemStack.field_77994_a != 0 && itemStack.func_77973_b() != null) {
            int stackSize;
            if (itemStack.func_77951_h()) {
                int stackSize2 = InventoryUtils.getOpenSlot(inventory);
                if (stackSize2 >= 0) {
                    ItemStack copy = ItemStack.func_77944_b((ItemStack)itemStack);
                    copy.field_77992_b = 5;
                    inventory.func_70299_a(stackSize2, copy);
                    itemStack.field_77994_a = 0;
                    return true;
                }
                return false;
            }
            do {
                stackSize = itemStack.field_77994_a;
                itemStack.field_77994_a = InventoryUtils.storePartialItemStack(inventory, itemStack);
            } while (itemStack.field_77994_a > 0 && itemStack.field_77994_a < stackSize);
            return itemStack.field_77994_a < stackSize;
        }
        return false;
    }

    private static int storePartialItemStack(@NotNull IInventory inventory, @NotNull ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        int stackSize = itemStack.field_77994_a;
        if (itemStack.func_77976_d() == 1) {
            int slot = InventoryUtils.getOpenSlot(inventory);
            if (slot < 0) {
                return stackSize;
            }
            if (inventory.func_70301_a(slot) == null) {
                inventory.func_70299_a(slot, ItemStack.func_77944_b((ItemStack)itemStack));
            }
            return 0;
        }
        int slot = InventoryUtils.findSlotForItemStack(inventory, itemStack);
        if (slot < 0) {
            slot = InventoryUtils.getOpenSlot(inventory);
        }
        if (slot < 0) {
            return stackSize;
        }
        ItemStack stack = inventory.func_70301_a(slot);
        if (stack == null) {
            stack = new ItemStack(item, 0, itemStack.func_77952_i());
            if (itemStack.func_77942_o()) {
                stack.func_77982_d(itemStack.func_77978_p().func_74737_b());
            }
        }
        int inventoryStackSpace = stackSize;
        if (stackSize > stack.func_77976_d() - stack.field_77994_a) {
            inventoryStackSpace = stack.func_77976_d() - stack.field_77994_a;
        }
        if (inventoryStackSpace > inventory.func_70297_j_() - stack.field_77994_a) {
            inventoryStackSpace = inventory.func_70297_j_() - stack.field_77994_a;
        }
        if (inventoryStackSpace == 0) {
            return stackSize;
        }
        stack.field_77994_a += inventoryStackSpace;
        stack.field_77992_b = 5;
        inventory.func_70299_a(slot, stack);
        return stackSize -= inventoryStackSpace;
    }

    private static int findSlotForItemStack(@NotNull IInventory inventory, @NotNull ItemStack itemStack) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack inventoryItem = inventory.func_70301_a(i);
            if (inventoryItem == null || inventoryItem.func_77973_b() != itemStack.func_77973_b() || !inventoryItem.func_77985_e() || inventoryItem.field_77994_a >= inventoryItem.func_77976_d() || inventoryItem.field_77994_a >= inventory.func_70297_j_() || inventoryItem.func_77981_g() && inventoryItem.func_77952_i() != itemStack.func_77952_i() || !ItemStack.func_77970_a((ItemStack)inventoryItem, (ItemStack)itemStack)) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasToolLevel(String tool, @NotNull InventoryCitizen inventory, int hutLevel) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            int level = Utils.getMiningLevel(item, tool);
            if (!Utils.isTool(item, tool) || !InventoryUtils.verifyToolLevel(item, level, hutLevel)) continue;
            return true;
        }
        return false;
    }

    public static boolean verifyToolLevel(ItemStack item, int level, int hutLevel) {
        if (item == null || hutLevel > 4) {
            return true;
        }
        if (item.func_77962_s() && hutLevel <= 2) {
            return false;
        }
        return hutLevel >= level;
    }

    public static String swapToolGrade(int toolGrade) {
        switch (toolGrade) {
            case 0: {
                return "Wood or Gold";
            }
            case 1: {
                return "Stone";
            }
            case 2: {
                return "Iron";
            }
            case 3: {
                return "Diamond";
            }
        }
        return "";
    }
}

