/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.structures.helpers;

import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.structures.helpers.Structure;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import org.jetbrains.annotations.NotNull;

public class StructureProxy {
    private final Structure structure;
    private final List<TileEntity> tileEntities = new ArrayList<TileEntity>();
    private final List<Entity> entities = new ArrayList<Entity>();
    private Block[][][] blocks;
    private IBlockState[][][] metadata;
    private int width;
    private int height;
    private int length;
    private BlockPos offset;

    public StructureProxy(World worldObj, String name) {
        this.structure = new Structure(worldObj, name, new PlacementSettings());
        BlockPos size = this.structure.getSize(Rotation.NONE);
        this.width = size.func_177958_n();
        this.height = size.func_177956_o();
        this.length = size.func_177952_p();
        this.blocks = new Block[this.width][this.height][this.length];
        this.metadata = new IBlockState[this.width][this.height][this.length];
        for (Template.BlockInfo info : this.structure.getBlockInfo()) {
            BlockPos tempPos = info.field_186242_a;
            this.blocks[tempPos.func_177958_n()][tempPos.func_177956_o()][tempPos.func_177952_p()] = info.field_186243_b.func_177230_c();
            this.metadata[tempPos.func_177958_n()][tempPos.func_177956_o()][tempPos.func_177952_p()] = info.field_186243_b;
            if (!(info.field_186243_b.func_177230_c() instanceof AbstractBlockHut)) continue;
            this.offset = info.field_186242_a;
        }
    }

    public BlockPos getOffset() {
        return this.offset;
    }

    public void setOffset(BlockPos pos) {
        this.offset = pos;
    }

    public String getType() {
        if (this.hasOffset()) {
            return "Hut";
        }
        return "Decoration";
    }

    private boolean hasOffset() {
        return !BlockPosUtil.isEqual(this.offset, 0, 0, 0);
    }

    public Structure getStructure() {
        return this.structure;
    }

    public IBlockState getBlockState(@NotNull BlockPos pos) {
        return this.metadata[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()];
    }

    public TileEntity getTileEntity(BlockPos pos) {
        for (TileEntity tileEntity : this.tileEntities) {
            if (!tileEntity.func_174877_v().equals((Object)pos)) continue;
            return tileEntity;
        }
        return null;
    }

    public List<TileEntity> getTileEntities() {
        return this.tileEntities;
    }

    public void setTileEntity(BlockPos pos, TileEntity tileEntity) {
        if (this.isInvalid(pos)) {
            return;
        }
        this.removeTileEntity(pos);
        if (tileEntity != null) {
            this.tileEntities.add(tileEntity);
        }
    }

    private boolean isInvalid(BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return x < 0 || y < 0 || z < 0 || x >= this.width || y >= this.height || z >= this.length;
    }

    private void removeTileEntity(BlockPos pos) {
        Iterator<TileEntity> iterator = this.tileEntities.iterator();
        while (iterator.hasNext()) {
            TileEntity tileEntity = iterator.next();
            if (!tileEntity.func_174877_v().equals((Object)pos)) continue;
            iterator.remove();
        }
    }

    @NotNull
    public List<Entity> getEntities() {
        return this.entities;
    }

    public void addEntity(Entity entity) {
        if (entity == null || entity instanceof EntityPlayer) {
            return;
        }
        for (Entity e : this.entities) {
            if (!entity.func_110124_au().equals(e.func_110124_au())) continue;
            return;
        }
        this.entities.add(entity);
    }

    public void removeEntity(Entity entity) {
        if (entity == null) {
            return;
        }
        Iterator<Entity> iterator = this.entities.iterator();
        while (iterator.hasNext()) {
            Entity e = iterator.next();
            if (!entity.func_110124_au().equals(e.func_110124_au())) continue;
            iterator.remove();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getLength() {
        return this.length;
    }

    public int getHeight() {
        return this.height;
    }

    public void rotate(int times) {
        Rotation rotation;
        switch (times) {
            case 1: {
                rotation = Rotation.CLOCKWISE_90;
                break;
            }
            case 2: {
                rotation = Rotation.CLOCKWISE_180;
                break;
            }
            case 3: {
                rotation = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
            default: {
                rotation = Rotation.NONE;
            }
        }
        this.structure.setPlacementSettings(new PlacementSettings().func_186220_a(rotation));
        BlockPos size = this.structure.getSize(rotation);
        this.width = size.func_177958_n();
        this.height = size.func_177956_o();
        this.length = size.func_177952_p();
        this.blocks = new Block[this.width][this.height][this.length];
        this.metadata = new IBlockState[this.width][this.height][this.length];
        int minX = 0;
        int minY = 0;
        int minZ = 0;
        for (Template.BlockInfo info : this.structure.getBlockInfoWithSettings(new PlacementSettings().func_186220_a(rotation))) {
            BlockPos tempPos = info.field_186242_a;
            int x = tempPos.func_177958_n();
            int y = tempPos.func_177956_o();
            int z = tempPos.func_177952_p();
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (z >= minZ) continue;
            minZ = z;
        }
        minX = Math.abs(minX);
        minY = Math.abs(minY);
        minZ = Math.abs(minZ);
        boolean foundHut = false;
        for (Template.BlockInfo info : this.structure.getBlockInfoWithSettings(new PlacementSettings().func_186220_a(rotation))) {
            BlockPos tempPos = info.field_186242_a;
            int x = tempPos.func_177958_n() + minX;
            int y = tempPos.func_177956_o() + minY;
            int z = tempPos.func_177952_p() + minZ;
            this.blocks[x][y][z] = info.field_186243_b.func_177230_c();
            this.metadata[x][y][z] = info.field_186243_b;
            if (!(info.field_186243_b.func_177230_c() instanceof AbstractBlockHut)) continue;
            foundHut = true;
            this.offset = info.field_186242_a.func_177982_a(minX, minY, minZ);
        }
        this.updateOffSetIfDecoration(foundHut, size, times, minX, minY, minZ);
    }

    private void updateOffSetIfDecoration(boolean foundHut, BlockPos size, int rotation, int minX, int minY, int minZ) {
        if (!foundHut) {
            BlockPos tempSize = size;
            if (rotation == 1) {
                tempSize = new BlockPos(-size.func_177958_n(), size.func_177956_o(), size.func_177952_p());
            }
            if (rotation == 2) {
                tempSize = new BlockPos(-size.func_177958_n(), size.func_177956_o(), -size.func_177952_p());
            }
            if (rotation == 3) {
                tempSize = new BlockPos(size.func_177958_n(), size.func_177956_o(), -size.func_177952_p());
            }
            this.offset = new BlockPos(tempSize.func_177958_n() / 2, 0, tempSize.func_177952_p() / 2).func_177982_a(minX, minY, minZ);
        }
    }
}

