/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.SwitchView;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.colony.buildings.BuildingBuilder;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class WindowHutBuilder
extends AbstractWindowWorkerBuilding<BuildingBuilder.View> {
    private static final String HUT_BUILDER_RESOURCE_SUFFIX = ":gui/windowHutBuilder.xml";
    private static final String LIST_RESOURCES = "resources";
    private static final String PAGE_RESOURCES = "resourceActions";
    private static final String VIEW_PAGES = "pages";
    private final BuildingBuilder.View builder;
    private Map<String, Integer> resources;

    public WindowHutBuilder(BuildingBuilder.View building) {
        super(building, "minecolonies:gui/windowHutBuilder.xml");
        this.builder = building;
        this.pullResourcesFromHut();
    }

    private void pullResourcesFromHut() {
        if (this.builder.getColony().getBuilding(this.builder.getID()) != null) {
            this.resources = this.builder.getNeededResources();
        }
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerHuts.buildersHut";
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.pullResourcesFromHut();
        final Object[] entries = this.resources.entrySet().toArray();
        ScrollingList resourceList = this.findPaneOfTypeByID(LIST_RESOURCES, ScrollingList.class);
        resourceList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowHutBuilder.this.resources.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                Object obj = entries[index];
                if (obj instanceof Map.Entry && ((Map.Entry)obj).getKey() instanceof String && ((Map.Entry)obj).getValue() instanceof Integer) {
                    String key = (String)((Map.Entry)obj).getKey();
                    int value = (Integer)((Map.Entry)obj).getValue();
                    rowPane.findPaneOfTypeByID("resource", Label.class).setLabelText(key);
                    rowPane.findPaneOfTypeByID("amount", Label.class).setLabelText(Integer.toString(value));
                }
            }
        });
    }

    @Override
    public void onUpdate() {
        String currentPage = this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).getCurrentView().getID();
        if (currentPage.equals(PAGE_RESOURCES)) {
            this.pullResourcesFromHut();
            this.window.findPaneOfTypeByID(LIST_RESOURCES, ScrollingList.class).refreshElementPanes();
        }
    }
}

