/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.SwitchView;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.colony.buildings.BuildingFarmer;
import com.minecolonies.coremod.entity.ai.citizen.farmer.FieldView;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.LanguageHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class WindowHutFarmer
extends AbstractWindowWorkerBuilding<BuildingFarmer.View> {
    private static final String BUTTON_PREV_PAGE = "prevPage";
    private static final String BUTTON_NEXT_PAGE = "nextPage";
    private static final String VIEW_PAGES = "pages";
    private static final String HUT_FARMER_RESOURCE_SUFFIX = ":gui/windowHutFarmer.xml";
    private static final String PAGE_FIELDS = "pageFields";
    private static final String LIST_FIELDS = "fields";
    private static final String TAG_WORKER = "worker";
    private static final String TAG_DISTANCE = "dist";
    private static final String TAG_DIRECTION = "dir";
    private static final String TAG_BUTTON_ASSIGN = "assignFarm";
    private static final String TAG_BUTTON_ASSIGNMENT_MODE = "assignmentMode";
    private static final String RED_X = "\u00a7n\u00a74X";
    private static final String APPROVE = "\u2713";
    private static final String TAG_ICON = "icon";
    private Button buttonPrevPage;
    private Button buttonNextPage;
    private List<FieldView> fields = new ArrayList<FieldView>();
    private ScrollingList fieldList;

    public WindowHutFarmer(BuildingFarmer.View building) {
        super(building, "minecolonies:gui/windowHutFarmer.xml");
        this.registerButton(BUTTON_PREV_PAGE, this::prevClicked);
        this.registerButton(BUTTON_NEXT_PAGE, this::nextClicked);
        this.registerButton(TAG_BUTTON_ASSIGNMENT_MODE, this::assignmentModeClicked);
        this.registerButton(TAG_BUTTON_ASSIGN, this::assignClicked);
    }

    private void assignClicked(@NotNull Button button) {
        int row = this.fieldList.getListElementIndexByPane(button);
        FieldView field = this.fields.get(row);
        if (button.getLabel().equals(RED_X)) {
            button.setLabel(APPROVE);
            ((BuildingFarmer.View)this.building).changeFields(field.getId(), false, row);
        } else {
            button.setLabel(RED_X);
            ((BuildingFarmer.View)this.building).changeFields(field.getId(), true, row);
        }
        this.pullLevelsFromHut();
        this.window.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class).refreshElementPanes();
    }

    private void pullLevelsFromHut() {
        this.fields = ((BuildingFarmer.View)this.building).getFields();
    }

    private void assignmentModeClicked(@NotNull Button button) {
        if (button.getLabel().equals(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.off", new Object[0]))) {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.on", new Object[0]));
            ((BuildingFarmer.View)this.building).setAssignFieldManually(true);
        } else {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.off", new Object[0]));
            ((BuildingFarmer.View)this.building).setAssignFieldManually(false);
        }
        this.window.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class).refreshElementPanes();
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "tile.minecolonies.blockHutFarmer.name";
    }

    @Override
    public void onOpened() {
        super.onOpened();
        if (((BuildingFarmer.View)this.building).assignFieldManually()) {
            this.findPaneOfTypeByID(TAG_BUTTON_ASSIGNMENT_MODE, Button.class).setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.on", new Object[0]));
        } else {
            this.findPaneOfTypeByID(TAG_BUTTON_ASSIGNMENT_MODE, Button.class).setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.off", new Object[0]));
        }
        this.findPaneOfTypeByID(BUTTON_PREV_PAGE, Button.class).setEnabled(false);
        this.buttonPrevPage = this.findPaneOfTypeByID(BUTTON_PREV_PAGE, Button.class);
        this.buttonNextPage = this.findPaneOfTypeByID(BUTTON_NEXT_PAGE, Button.class);
        this.fieldList = this.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class);
        this.fieldList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowHutFarmer.this.fields.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                FieldView field = (FieldView)WindowHutFarmer.this.fields.get(index);
                String distance = Integer.toString((int)Math.sqrt(BlockPosUtil.getDistanceSquared(field.getId(), ((BuildingFarmer.View)WindowHutFarmer.this.building).getLocation())));
                String direction = WindowHutFarmer.calcDirection(((BuildingFarmer.View)WindowHutFarmer.this.building).getLocation(), field.getId());
                String owner = field.getOwner().isEmpty() ? "<" + LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.farmerHut.unused", new Object[0]) + ">" : field.getOwner();
                rowPane.findPaneOfTypeByID(WindowHutFarmer.TAG_WORKER, Label.class).setLabelText(owner);
                rowPane.findPaneOfTypeByID(WindowHutFarmer.TAG_DISTANCE, Label.class).setLabelText(distance + "m");
                rowPane.findPaneOfTypeByID(WindowHutFarmer.TAG_DIRECTION, Label.class).setLabelText(direction);
                Button assignButton = rowPane.findPaneOfTypeByID(WindowHutFarmer.TAG_BUTTON_ASSIGN, Button.class);
                assignButton.setEnabled(((BuildingFarmer.View)WindowHutFarmer.this.building).assignFieldManually());
                if (field.isTaken()) {
                    assignButton.setLabel(WindowHutFarmer.RED_X);
                } else {
                    assignButton.setLabel(WindowHutFarmer.APPROVE);
                    if (((BuildingFarmer.View)WindowHutFarmer.this.building).getBuildingLevel() <= ((BuildingFarmer.View)WindowHutFarmer.this.building).getAmountOfFields()) {
                        assignButton.disable();
                    }
                }
                if (field.getItem() != null) {
                    rowPane.findPaneOfTypeByID(WindowHutFarmer.TAG_ICON, ItemIcon.class).setItem(new ItemStack(field.getItem(), 1));
                }
            }
        });
    }

    private static String calcDirection(@NotNull BlockPos building, @NotNull BlockPos field) {
        String dist = "";
        if (field.func_177952_p() > building.func_177952_p() + 1) {
            dist = LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.farmerHut.South", new Object[0]);
        } else if (field.func_177952_p() < building.func_177952_p() - 1) {
            dist = LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.farmerHut.North", new Object[0]);
        }
        if (field.func_177958_n() > building.func_177958_n() + 1) {
            dist = dist + LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.farmerHut.East", new Object[0]);
        } else if (field.func_177958_n() < building.func_177958_n() - 1) {
            dist = dist + LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.farmerHut.West", new Object[0]);
        }
        return dist;
    }

    @Override
    public void onUpdate() {
        String currentPage = this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).getCurrentView().getID();
        if (currentPage.equals(PAGE_FIELDS)) {
            this.pullLevelsFromHut();
            this.window.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class).refreshElementPanes();
        }
    }

    private void prevClicked() {
        this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).previousView();
        this.buttonPrevPage.setEnabled(false);
        this.buttonNextPage.setEnabled(true);
    }

    private void nextClicked() {
        this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).nextView();
        this.buttonPrevPage.setEnabled(true);
        this.buttonNextPage.setEnabled(false);
    }
}

