/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManagerWorldAccess;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.IColony;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.configuration.Configurations;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.util.AchievementUtils;
import com.minecolonies.coremod.util.LanguageHandler;
import com.minecolonies.coremod.util.Log;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColonyManager {
    private static final String FILENAME_MINECOLONIES_PATH = "minecolonies";
    private static final String FILENAME_MINECOLONIES = "colonies.dat";
    private static final String TAG_COLONIES = "colonies";
    private static final DamageSource CONSOLE_DAMAGE_SOURCE = new DamageSource("Console");
    @NotNull
    private static final Map<Integer, Colony> colonies = new HashMap<Integer, Colony>();
    @NotNull
    private static final Map<Integer, List<Colony>> coloniesByWorld = new HashMap<Integer, List<Colony>>();
    private static int topColonyId = 0;
    @NotNull
    private static final Map<Integer, ColonyView> colonyViews = new HashMap<Integer, ColonyView>();
    private static int numWorldsLoaded;
    private static boolean saveNeeded;

    private ColonyManager() {
    }

    @NotNull
    public static Colony createColony(@NotNull World w, BlockPos pos, @NotNull EntityPlayer player) {
        Colony colony = new Colony(++topColonyId, w, pos);
        colonies.put(colony.getID(), colony);
        if (!coloniesByWorld.containsKey(colony.getDimension())) {
            coloniesByWorld.put(colony.getDimension(), new ArrayList());
        }
        coloniesByWorld.get(colony.getDimension()).add(colony);
        String colonyName = LanguageHandler.format("com.minecolonies.coremod.gui.townHall.defaultName", player.getDisplayNameString());
        colony.setName(colonyName);
        colony.getPermissions().setPlayerRank(player.func_146103_bH().getId(), Permissions.Rank.OWNER, w);
        colony.triggerAchievement(ModAchievements.achievementGetSupply);
        colony.triggerAchievement(ModAchievements.achievementTownhall);
        ColonyManager.markDirty();
        Log.getLogger().info(String.format("New Colony Id: %d by %s", colony.getID(), player.func_70005_c_()));
        return colony;
    }

    public static void markDirty() {
        saveNeeded = true;
    }

    public static void deleteColony(int id) {
        try {
            Colony colony = ColonyManager.getColony(id);
            Log.getLogger().info("Deleting colony " + id);
            colonies.remove(id);
            coloniesByWorld.get(colony.getDimension()).remove(colony);
            HashSet<World> colonyWorlds = new HashSet<World>();
            Log.getLogger().info("Removing citizens for " + id);
            for (CitizenData citizenData : new ArrayList<CitizenData>(colony.getCitizens().values())) {
                Log.getLogger().info("Kill Citizen " + citizenData.getName());
                EntityCitizen entityCitizen = citizenData.getCitizenEntity();
                if (entityCitizen == null) continue;
                World world = entityCitizen.func_130014_f_();
                citizenData.getCitizenEntity().func_70645_a(CONSOLE_DAMAGE_SOURCE);
                colonyWorlds.add(world);
            }
            Log.getLogger().info("Removing buildings for " + id);
            for (AbstractBuilding building : new ArrayList<AbstractBuilding>(colony.getBuildings().values())) {
                BlockPos location = building.getLocation();
                Log.getLogger().info("Delete Building at " + location);
                building.destroy();
                for (World world : colonyWorlds) {
                    if (!(world.func_180495_p(location).func_177230_c() instanceof AbstractBlockHut)) continue;
                    Log.getLogger().info("Found Block, deleting " + world.func_180495_p(location).func_177230_c());
                    world.func_175698_g(location);
                }
            }
            Log.getLogger().info("Done with " + id);
        }
        catch (RuntimeException e) {
            Log.getLogger().warn("Deleting Colony " + id + " errored:", (Throwable)e);
        }
    }

    public static Colony getColony(int id) {
        return colonies.get(id);
    }

    public static void syncAllColoniesAchievements() {
        colonies.values().forEach(AchievementUtils::syncAchievements);
    }

    public static AbstractBuilding getBuilding(@NotNull World w, @NotNull BlockPos pos) {
        AbstractBuilding building;
        Colony colony = ColonyManager.getColony(w, pos);
        if (colony != null && (building = colony.getBuilding(pos)) != null) {
            return building;
        }
        if (coloniesByWorld.containsKey(w.field_73011_w.getDimension())) {
            for (Colony otherColony : coloniesByWorld.get(w.field_73011_w.getDimension())) {
                AbstractBuilding building2 = otherColony.getBuilding(pos);
                if (building2 == null) continue;
                return building2;
            }
        }
        return null;
    }

    public static Colony getColony(@NotNull World w, @NotNull BlockPos pos) {
        List<Colony> coloniesInWorld = coloniesByWorld.get(w.field_73011_w.getDimension());
        if (coloniesInWorld == null) {
            return null;
        }
        for (Colony c : coloniesInWorld) {
            if (!c.isCoordInColony(w, pos)) continue;
            return c;
        }
        return null;
    }

    @NotNull
    public static List<Colony> getColonies(@NotNull World w) {
        List<Colony> coloniesInWorld = coloniesByWorld.get(w.field_73011_w.getDimension());
        if (coloniesInWorld == null) {
            return new ArrayList<Colony>();
        }
        return coloniesInWorld;
    }

    @NotNull
    public static List<Colony> getColonies() {
        return new ArrayList<Colony>(colonies.values());
    }

    public static AbstractBuilding.View getBuildingView(BlockPos pos) {
        for (ColonyView colony : colonyViews.values()) {
            AbstractBuilding.View building = colony.getBuilding(pos);
            if (building == null) continue;
            return building;
        }
        return null;
    }

    @Nullable
    public static IColony getIColony(@NotNull World w, @NotNull BlockPos pos) {
        return w.field_72995_K ? ColonyManager.getColonyView(w, pos) : ColonyManager.getColony(w, pos);
    }

    private static ColonyView getColonyView(@NotNull World w, @NotNull BlockPos pos) {
        for (ColonyView c : colonyViews.values()) {
            if (!c.isCoordInColony(w, pos)) continue;
            return c;
        }
        return null;
    }

    @Nullable
    public static IColony getClosestIColony(@NotNull World w, @NotNull BlockPos pos) {
        return w.field_72995_K ? ColonyManager.getClosestColonyView(w, pos) : ColonyManager.getClosestColony(w, pos);
    }

    @Nullable
    public static ColonyView getClosestColonyView(@NotNull World w, @NotNull BlockPos pos) {
        ColonyView closestColony = null;
        long closestDist = Long.MAX_VALUE;
        for (ColonyView c : colonyViews.values()) {
            long dist;
            if (c.getDimension() != w.field_73011_w.getDimension() || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
            closestColony = c;
            closestDist = dist;
        }
        return closestColony;
    }

    public static Colony getClosestColony(@NotNull World w, @NotNull BlockPos pos) {
        List<Colony> coloniesInWorld = coloniesByWorld.get(w.field_73011_w.getDimension());
        if (coloniesInWorld == null) {
            return null;
        }
        Colony closestColony = null;
        long closestDist = Long.MAX_VALUE;
        for (Colony c : coloniesInWorld) {
            long dist;
            if (c.getDimension() != w.field_73011_w.getDimension() || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
            closestColony = c;
            closestDist = dist;
        }
        return closestColony;
    }

    @Nullable
    public static IColony getIColonyByOwner(@NotNull World w, @NotNull EntityPlayer owner) {
        return ColonyManager.getIColonyByOwner(w, w.field_72995_K ? owner.func_110124_au() : owner.func_146103_bH().getId());
    }

    @Nullable
    public static IColony getIColonyByOwner(@NotNull World w, UUID owner) {
        return w.field_72995_K ? ColonyManager.getColonyViewByOwner(owner) : ColonyManager.getColonyByOwner(owner);
    }

    private static IColony getColonyViewByOwner(UUID owner) {
        for (ColonyView c : colonyViews.values()) {
            Permissions.Player p = c.getPlayers().get(owner);
            if (p == null || !p.getRank().equals((Object)Permissions.Rank.OWNER)) continue;
            return c;
        }
        return null;
    }

    @Nullable
    private static IColony getColonyByOwner(@Nullable UUID owner) {
        if (owner == null) {
            return null;
        }
        return colonies.values().stream().filter(c -> owner.equals(c.getPermissions().getOwner())).findFirst().orElse(null);
    }

    public static double getMinimumDistanceBetweenTownHalls() {
        return 2.0 * (double)Configurations.workingRangeTownHall + (double)Configurations.townHallPadding;
    }

    public static void onServerTick(@NotNull TickEvent.ServerTickEvent event) {
        for (Colony c : colonies.values()) {
            c.onServerTick(event);
        }
        if (saveNeeded) {
            ColonyManager.saveColonies();
        }
    }

    private static void saveColonies() {
        NBTTagCompound compound = new NBTTagCompound();
        ColonyManager.writeToNBT(compound);
        File file = ColonyManager.getSaveLocation();
        ColonyManager.saveNBTToPath(file, compound);
        saveNeeded = false;
    }

    public static void writeToNBT(@NotNull NBTTagCompound compound) {
        NBTTagList colonyTagList = new NBTTagList();
        for (Colony colony : colonies.values()) {
            NBTTagCompound colonyTagCompound = new NBTTagCompound();
            colony.writeToNBT(colonyTagCompound);
            colonyTagList.func_74742_a((NBTBase)colonyTagCompound);
        }
        compound.func_74782_a(TAG_COLONIES, (NBTBase)colonyTagList);
    }

    @NotNull
    private static File getSaveLocation() {
        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), FILENAME_MINECOLONIES_PATH);
        return new File(saveDir, FILENAME_MINECOLONIES);
    }

    private static void saveNBTToPath(@Nullable File file, @NotNull NBTTagCompound compound) {
        try {
            if (file != null) {
                file.getParentFile().mkdir();
                CompressedStreamTools.func_74793_a((NBTTagCompound)compound, (File)file);
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when saving ColonyManager", (Throwable)exception);
        }
    }

    public static void onClientTick(@NotNull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71441_e == null && !colonyViews.isEmpty()) {
            colonyViews.clear();
        }
    }

    public static void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        HashMap<Integer, Colony> coloniesCopy = new HashMap<Integer, Colony>(colonies);
        coloniesCopy.values().stream().filter(c -> c.getDimension() == worldTickEvent.world.field_73011_w.getDimension()).forEach(c -> c.onWorldTick(event));
    }

    public static void onWorldLoad(@NotNull World world) {
        if (!world.field_72995_K) {
            File file;
            NBTTagCompound data;
            if (numWorldsLoaded == 0 && (data = ColonyManager.loadNBTFromPath(file = ColonyManager.getSaveLocation())) != null) {
                ColonyManager.readFromNBT(data);
            }
            ++numWorldsLoaded;
            List<Colony> worldColonies = coloniesByWorld.get(world.field_73011_w.getDimension());
            if (worldColonies != null) {
                for (Colony c : worldColonies) {
                    c.onWorldLoad(world);
                }
            }
            world.func_72954_a((IWorldEventListener)new ColonyManagerWorldAccess());
        }
    }

    private static NBTTagCompound loadNBTFromPath(@Nullable File file) {
        try {
            if (file != null && file.exists()) {
                return CompressedStreamTools.func_74797_a((File)file);
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when loading ColonyManger", (Throwable)exception);
        }
        return null;
    }

    public static void readFromNBT(@NotNull NBTTagCompound compound) {
        NBTTagList colonyTags = compound.func_150295_c(TAG_COLONIES, 10);
        for (int i = 0; i < colonyTags.func_74745_c(); ++i) {
            Colony colony = Colony.loadColony(colonyTags.func_150305_b(i));
            colonies.put(colony.getID(), colony);
            if (!coloniesByWorld.containsKey(colony.getDimension())) {
                coloniesByWorld.put(colony.getDimension(), new ArrayList());
            }
            coloniesByWorld.get(colony.getDimension()).add(colony);
            topColonyId = Math.max(topColonyId, colony.getID());
        }
        Log.getLogger().info(String.format("Loaded %d colonies", colonies.size()));
    }

    public static void onWorldSave(@NotNull World world) {
        if (!world.field_72995_K && world.field_73011_w.getDimension() == 0) {
            ColonyManager.saveColonies();
        }
    }

    public static void onWorldUnload(@NotNull World world) {
        if (!world.field_72995_K) {
            List<Colony> worldColonies = coloniesByWorld.get(world.field_73011_w.getDimension());
            if (worldColonies != null) {
                for (Colony c : worldColonies) {
                    c.onWorldUnload(world);
                }
            }
            if (--numWorldsLoaded == 0) {
                colonies.clear();
                coloniesByWorld.clear();
            }
        }
    }

    @Nullable
    public static IMessage handleColonyViewMessage(int colonyId, @NotNull ByteBuf colonyData, boolean isNewSubscription) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view == null) {
            view = ColonyView.createFromNetwork(colonyId);
            colonyViews.put(colonyId, view);
        }
        return view.handleColonyViewMessage(colonyData, isNewSubscription);
    }

    public static ColonyView getColonyView(int id) {
        return colonyViews.get(id);
    }

    public static IMessage handlePermissionsViewMessage(int colonyID, @NotNull ByteBuf data) {
        ColonyView view = ColonyManager.getColonyView(colonyID);
        if (view == null) {
            Log.getLogger().error(String.format("Colony view does not exist for ID #%d", colonyID));
            return null;
        }
        return view.handlePermissionsViewMessage(data);
    }

    public static IMessage handleColonyViewCitizensMessage(int colonyId, int citizenId, ByteBuf buf) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view == null) {
            return null;
        }
        return view.handleColonyViewCitizensMessage(citizenId, buf);
    }

    public static IMessage handleColonyViewWorkOrderMessage(int colonyId, ByteBuf buf) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view == null) {
            return null;
        }
        return view.handleColonyViewWorkOrderMessage(buf);
    }

    public static IMessage handleColonyViewRemoveCitizenMessage(int colonyId, int citizenId) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            return view.handleColonyViewRemoveCitizenMessage(citizenId);
        }
        return null;
    }

    public static IMessage handleColonyBuildingViewMessage(int colonyId, BlockPos buildingId, @NotNull ByteBuf buf) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            return view.handleColonyBuildingViewMessage(buildingId, buf);
        }
        Log.getLogger().error(String.format("Colony view does not exist for ID #%d", colonyId));
        return null;
    }

    public static IMessage handleColonyViewRemoveBuildingMessage(int colonyId, BlockPos buildingId) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            return view.handleColonyViewRemoveBuildingMessage(buildingId);
        }
        return null;
    }

    public static IMessage handleColonyViewRemoveWorkOrderMessage(int colonyId, int workOrderId) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            return view.handleColonyViewRemoveWorkOrderMessage(workOrderId);
        }
        return null;
    }
}

