/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.client.gui.WindowHutBuilder;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.util.Utils;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingBuilder
extends AbstractBuildingWorker {
    public static final int MAX_BUILDING_LEVEL = 5;
    private static final String BUILDER = "Builder";
    private static final String TAG_RESOURCE_LIST = "resourcesItem";
    private HashMap<String, ItemStack> neededResources = new HashMap();

    public BuildingBuilder(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BUILDER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().triggerAchievement(ModAchievements.achievementBuildingBuilder);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().triggerAchievement(ModAchievements.achievementUpgradeBuilderMax);
        }
    }

    @Override
    @NotNull
    public String getJobName() {
        return BUILDER;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobBuilder(citizen);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagList neededResTagList = compound.func_150295_c(TAG_RESOURCE_LIST, 10);
        for (int i = 0; i < neededResTagList.func_74745_c(); ++i) {
            NBTTagCompound neededRes = neededResTagList.func_150305_b(i);
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)neededRes);
            this.neededResources.put(stack.func_77977_a(), stack);
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList neededResTagList = new NBTTagList();
        for (ItemStack stack : this.neededResources.values()) {
            NBTTagCompound neededRes = new NBTTagCompound();
            stack.func_77955_b(neededRes);
            neededResTagList.func_74742_a((NBTBase)neededRes);
        }
        compound.func_74782_a(TAG_RESOURCE_LIST, (NBTBase)neededResTagList);
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.neededResources.size());
        for (Map.Entry<String, ItemStack> entry : this.neededResources.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getValue().func_82833_r());
            buf.writeInt(entry.getValue().field_77994_a);
        }
    }

    public Map<String, ItemStack> getNeededResources() {
        return new HashMap<String, ItemStack>(this.neededResources);
    }

    public void addNeededResource(@Nullable ItemStack res, int amount) {
        int preAmount = 0;
        if (this.neededResources.containsKey(res.func_77977_a())) {
            preAmount = this.neededResources.get((Object)res.func_77977_a()).field_77994_a;
        }
        res.field_77994_a = preAmount + amount;
        this.neededResources.put(res.func_77977_a(), res);
        this.markDirty();
    }

    @Override
    public boolean neededForWorker(@Nullable ItemStack stack) {
        return Utils.isMiningTool(stack);
    }

    public void reduceNeededResource(ItemStack res, int amount) {
        int preAmount = 0;
        if (this.neededResources.containsKey(res.func_77977_a())) {
            preAmount = this.neededResources.get((Object)res.func_77977_a()).field_77994_a;
        }
        if (preAmount - amount <= 0) {
            this.neededResources.remove(res.func_77977_a());
        } else {
            this.neededResources.get((Object)res.func_77977_a()).field_77994_a = preAmount - amount;
        }
        this.markDirty();
    }

    public void resetNeededResources() {
        this.neededResources = new HashMap();
        this.markDirty();
    }

    public boolean requiresResourceForBuilding(ItemStack stack) {
        return this.neededResources.containsKey(stack.func_77977_a());
    }

    public static class View
    extends AbstractBuildingWorker.View {
        private HashMap<String, Integer> neededResources;

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutBuilder(this);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            int size = buf.readInt();
            this.neededResources = new HashMap();
            for (int i = 0; i < size; ++i) {
                String block = ByteBufUtils.readUTF8String((ByteBuf)buf);
                int amount = buf.readInt();
                this.neededResources.put(block, amount);
            }
        }

        public Map<String, Integer> getNeededResources() {
            return new HashMap<String, Integer>(this.neededResources);
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.INTELLIGENCE;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.STRENGTH;
        }
    }
}

