/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public class AddOfficerCommand
extends AbstractSingleCommand {
    public static final String DESC = "addOfficer";
    private static final String SUCCESS_MESSAGE = "Succesfully added Player %s to colony %d";
    private static final String COLONY_NULL = "Couldn't find colony %d.";

    public AddOfficerCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId> <(Optional)Player>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        Colony colony;
        int colonyId = AddOfficerCommand.getIthArgument(args, 0, -1);
        String playerName = null;
        if (args.length >= 2) {
            playerName = args[1];
        }
        if (playerName == null || playerName.isEmpty()) {
            playerName = sender.func_70005_c_();
        }
        if ((colony = ColonyManager.getColony(colonyId)) == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format(COLONY_NULL, colonyId, colonyId)));
            return;
        }
        colony.getPermissions().addPlayer(playerName, Permissions.Rank.OFFICER, colony.getWorld());
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format(SUCCESS_MESSAGE, playerName, colonyId)));
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return false;
    }
}

