/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.GetColonyAndCitizen;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.util.Log;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public class RespawnCitizenCommand
extends AbstractSingleCommand {
    public static final String DESC = "respawn";
    private static final String CITIZEN_DESCRIPTION = "\u00a72ID: \u00a7f %d \u00a72 Name: \u00a7f %s";
    private static final String REMOVED_MESSAGE = "Has been removed";
    private static final String COORDINATES_XYZ = "\u00a74x=\u00a7f%s \u00a74y=\u00a7f%s \u00a74z=\u00a7f%s";

    public RespawnCitizenCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId> <CitizenId>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        int citizenId;
        int colonyId;
        try {
            colonyId = GetColonyAndCitizen.getColonyId(sender.func_174793_f().func_110124_au(), sender.func_130014_f_(), args);
            citizenId = GetColonyAndCitizen.getCitizenId(colonyId, args);
        }
        catch (IllegalArgumentException e) {
            sender.func_145747_a((ITextComponent)new TextComponentString(e.getMessage()));
            return;
        }
        Colony colony = ColonyManager.getColony(colonyId);
        CitizenData citizenData = colony.getCitizen(citizenId);
        EntityCitizen entityCitizen = citizenData.getCitizenEntity();
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format(CITIZEN_DESCRIPTION, citizenData.getId(), citizenData.getName())));
        BlockPos position = entityCitizen.func_180425_c();
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format(COORDINATES_XYZ, position.func_177958_n(), position.func_177956_o(), position.func_177952_p())));
        sender.func_145747_a((ITextComponent)new TextComponentString(REMOVED_MESSAGE));
        Log.getLogger().info("client? " + sender.func_130014_f_().field_72995_K);
        server.func_152344_a(() -> ((EntityCitizen)entityCitizen).func_70106_y());
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return false;
    }
}

