/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.coremod.entity.EntityCitizen;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;

public class EntityAICitizenWander
extends EntityAIBase {
    private final EntityCitizen citizen;
    private double xPosition;
    private double yPosition;
    private double zPosition;
    private final double speed;

    public EntityAICitizenWander(EntityCitizen citizen, double speed) {
        this.citizen = citizen;
        this.speed = speed;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.isToOld() || this.checkForRandom() || this.citizen.getDesiredActivity() == EntityCitizen.DesiredActivity.SLEEP) {
            return false;
        }
        Vec3d Vec3d2 = RandomPositionGenerator.func_75463_a((EntityCreature)this.citizen, (int)10, (int)7);
        if (Vec3d2 == null) {
            return false;
        }
        Vec3d2 = new Vec3d(Vec3d2.field_72450_a, this.getValidHeight(Vec3d2), Vec3d2.field_72449_c);
        this.xPosition = Vec3d2.field_72450_a;
        this.yPosition = Vec3d2.field_72448_b;
        this.zPosition = Vec3d2.field_72449_c;
        return true;
    }

    private boolean isToOld() {
        return this.citizen.func_70654_ax() >= 100;
    }

    private boolean checkForRandom() {
        return this.citizen.func_70681_au().nextInt(120) != 0;
    }

    private double getValidHeight(@NotNull Vec3d position) {
        double returnHeight = position.field_72448_b;
        if (position.field_72448_b < 0.0) {
            returnHeight = 0.0;
        }
        while (returnHeight >= 1.0 && this.citizen.field_70170_p.func_175623_d(new BlockPos(MathHelper.func_76128_c((double)position.field_72450_a), (int)returnHeight, MathHelper.func_76128_c((double)position.field_72449_c)))) {
            returnHeight -= 1.0;
        }
        while (!this.citizen.field_70170_p.func_175623_d(new BlockPos(MathHelper.func_76128_c((double)position.field_72450_a), (int)returnHeight, MathHelper.func_76128_c((double)position.field_72449_c)))) {
            returnHeight += 1.0;
        }
        return returnHeight;
    }

    public boolean func_75253_b() {
        return !this.citizen.getNavigator().func_75500_f();
    }

    public void func_75249_e() {
        this.citizen.getNavigator().func_75492_a(this.xPosition, this.yPosition, this.zPosition, this.speed);
    }
}

