/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.util;

import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.configuration.Configurations;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.StructureWrapper;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Structure {
    private Stage stage;
    @Nullable
    private final StructureWrapper structure;
    private final World targetWorld;

    public Structure(World targetWorld, BlockPos buildingLocation, String schematicFileName, int rotation) throws StructureException {
        this(targetWorld, buildingLocation, schematicFileName, rotation, Stage.CLEAR, null);
    }

    public Structure(World targetWorld, BlockPos buildingLocation, String structureFileName, int rotation, Stage stageProgress, BlockPos blockProgress) throws StructureException {
        this.structure = Structure.loadStructure(targetWorld, buildingLocation, structureFileName, rotation, stageProgress, blockProgress);
        this.stage = stageProgress;
        this.targetWorld = targetWorld;
    }

    public Structure(World targetWorld, StructureWrapper structure, Stage stageProgress) {
        this.structure = structure;
        this.stage = stageProgress;
        this.targetWorld = targetWorld;
    }

    @Nullable
    private static StructureWrapper loadStructure(@Nullable World targetWorld, @Nullable BlockPos buildingLocation, @Nullable String schematicFileName, int rotation, Stage stageProgress, @Nullable BlockPos blockProgress) throws StructureException {
        if (targetWorld == null || buildingLocation == null || schematicFileName == null) {
            throw new StructureException(String.format("Some parameters were null! (targetWorld: %s), (buildingLocation: %s), (schematicFileName: %s)", targetWorld, buildingLocation, schematicFileName));
        }
        StructureWrapper tempSchematic = null;
        try {
            tempSchematic = new StructureWrapper(targetWorld, schematicFileName);
        }
        catch (IllegalStateException e) {
            throw new StructureException("failed to load structure file!", e);
        }
        tempSchematic.rotate(rotation, targetWorld, buildingLocation);
        tempSchematic.setPosition(buildingLocation);
        if (blockProgress != null) {
            tempSchematic.setLocalPosition(blockProgress);
        }
        return tempSchematic;
    }

    public static boolean checkBlocksEqual(@NotNull StructureBlock blocksToTest) {
        return blocksToTest.block == blocksToTest.worldBlock && Objects.equals(blocksToTest.metadata, blocksToTest.worldMetadata);
    }

    public Stage getStage() {
        return this.stage;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public BlockPos getCurrentBlockPosition() {
        return this.structure.getBlockPosition();
    }

    @NotNull
    public Result advanceBlock() {
        switch (this.stage) {
            case CLEAR: {
                return this.advanceBlocks(this.structure::decrementBlock, structureBlock -> structureBlock.doesStructureBlockEqualWorldBlock() || structureBlock.worldBlock == Blocks.field_150350_a);
            }
            case BUILD: {
                return this.advanceBlocks(this.structure::incrementBlock, structureBlock -> structureBlock.doesStructureBlockEqualWorldBlock() && structureBlock.block == Blocks.field_150350_a && !structureBlock.metadata.func_185904_a().func_76220_a());
            }
            case DECORATE: {
                return this.advanceBlocks(this.structure::decrementBlock, structureBlock -> structureBlock.doesStructureBlockEqualWorldBlock() || structureBlock.metadata.func_185904_a().func_76220_a());
            }
            case SPAWN: {
                return this.advanceBlocks(this.structure::incrementBlock, structureBlock -> structureBlock.entity == null);
            }
        }
        return Result.NEW_BLOCK;
    }

    @NotNull
    private Result advanceBlocks(@NotNull Supplier<Boolean> moveOneBlock, @NotNull Function<StructureBlock, Boolean> checkIfApplies) {
        for (int i = 0; i < Configurations.maxBlocksCheckedByBuilder; ++i) {
            if (!moveOneBlock.get().booleanValue()) {
                return Result.AT_END;
            }
            if (checkIfApplies.apply(this.getCurrentBlock()).booleanValue()) continue;
            return Result.NEW_BLOCK;
        }
        return Result.CONFIG_LIMIT;
    }

    @NotNull
    public StructureBlock getCurrentBlock() {
        return new StructureBlock(this.structure.getBlock(), this.structure.getBlockPosition(), this.structure.getBlockState(), this.structure.getEntityinfo(), this.structure.getItem(), BlockPosUtil.getBlock(this.targetWorld, this.structure.getBlockPosition()), BlockPosUtil.getBlockState(this.targetWorld, this.structure.getBlockPosition()));
    }

    public int getWidth() {
        return this.structure.getWidth();
    }

    public int getLength() {
        return this.structure.getLength();
    }

    public static enum Stage {
        CLEAR,
        BUILD,
        DECORATE,
        SPAWN,
        COMPLETE;

    }

    public static enum Result {
        NEW_BLOCK,
        AT_END,
        CONFIG_LIMIT;

    }

    public static final class StructureBlock {
        public final Block block;
        public final BlockPos blockPosition;
        public final IBlockState metadata;
        public final Item item;
        public final Block worldBlock;
        public final IBlockState worldMetadata;
        public final Template.EntityInfo entity;

        public StructureBlock(Block block, BlockPos blockPosition, IBlockState metadata, Template.EntityInfo entity, Item item, Block worldBlock, IBlockState worldMetadata) {
            this.block = block;
            this.blockPosition = blockPosition;
            this.metadata = metadata;
            this.entity = entity;
            this.item = item;
            this.worldBlock = worldBlock;
            this.worldMetadata = worldMetadata;
        }

        public boolean doesStructureBlockEqualWorldBlock() {
            IBlockState structureBlockState = this.metadata;
            Block structureBlock = structureBlockState.func_177230_c();
            if (structureBlock == ModBlocks.blockSubstitution || structureBlock == ModBlocks.blockSolidSubstitution && this.worldMetadata.func_185904_a().func_76220_a() && !(this.worldBlock instanceof BlockOre) && this.worldBlock != Blocks.field_150350_a) {
                return true;
            }
            IBlockState worldBlockState = this.worldMetadata;
            if (structureBlock instanceof BlockDoor || structureBlock == Blocks.field_150457_bL) {
                return structureBlock == worldBlockState.func_177230_c();
            }
            if (structureBlock instanceof BlockStairs && structureBlockState.equals(worldBlockState)) {
                return true;
            }
            return structureBlockState.equals(worldBlockState);
        }
    }

    public static final class StructureException
    extends Exception {
        public static final long serialVersionUID = 8632728763984762837L;

        public StructureException(String message, Throwable cause) {
            super(message, cause);
        }

        public StructureException(String message) {
            super(message);
        }
    }
}

