/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.util.Log;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class TileEntityColonyBuilding
extends TileEntityChest {
    private static final String TAG_COLONY = "colony";
    private int colonyId = 0;
    private Colony colony;
    private AbstractBuilding building;

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a(TAG_COLONY, this.colonyId);
        return new SPacketUpdateTileEntity(this.getPosition(), 0, compound);
    }

    @NotNull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.colonyId = compound.func_74762_e(TAG_COLONY);
    }

    public void onChunkUnload() {
        if (this.building != null) {
            this.building.setTileEntity(null);
        }
    }

    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    public int getColonyId() {
        return this.colonyId;
    }

    public Colony getColony() {
        if (this.colony == null) {
            this.updateColonyReferences();
        }
        return this.colony;
    }

    private void updateColonyReferences() {
        if (this.colony == null && this.field_145850_b != null) {
            this.colony = this.colonyId == 0 ? ColonyManager.getColony(this.field_145850_b, this.func_174877_v()) : ColonyManager.getColony(this.colonyId);
            if (this.colony == null && !this.field_145850_b.field_72995_K) {
                Log.getLogger().warn(String.format("TileEntityColonyBuilding at %s:[%d,%d,%d] had colony.", this.field_145850_b.func_72912_H().func_76065_j(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
            }
        }
        if (this.building == null && this.colony != null) {
            this.building = this.colony.getBuilding(this.getPosition());
            if (!(this.building == null || this.field_145850_b != null && this.field_145850_b.field_72995_K)) {
                this.building.setTileEntity(this);
            }
        }
    }

    public void func_73660_a() {
        Colony tempColony;
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.colonyId == 0 && (tempColony = ColonyManager.getColony(this.field_145850_b, this.getPosition())) != null) {
            this.colonyId = tempColony.getID();
        }
    }

    public void setColony(Colony c) {
        this.colony = c;
        this.colonyId = c.getID();
        this.func_70296_d();
    }

    public AbstractBuilding getBuilding() {
        if (this.building == null) {
            this.updateColonyReferences();
        }
        return this.building;
    }

    public void setBuilding(AbstractBuilding b) {
        this.building = b;
    }

    public AbstractBuilding.View getBuildingView() {
        ColonyView c = ColonyManager.getColonyView(this.colonyId);
        return c == null ? null : c.getBuilding(this.getPosition());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b(TAG_COLONY)) {
            this.colonyId = compound.func_74762_e(TAG_COLONY);
        }
        this.updateColonyReferences();
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a(TAG_COLONY, this.colonyId);
        return compound;
    }

    public boolean func_70300_a(@NotNull EntityPlayer player) {
        return super.func_70300_a(player) && this.hasAccessPermission(player);
    }

    public boolean hasAccessPermission(EntityPlayer player) {
        return this.building == null || this.building.getColony().getPermissions().hasPermission(player, Permissions.Action.ACCESS_HUTS);
    }
}

