/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.pathfinding.PathResult;
import com.minecolonies.coremod.util.EntityUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public final class BlockPosUtil {
    private static final double CLOSE_DISTANCE = 4.84;

    private BlockPosUtil() {
    }

    public static void writeToNBT(@NotNull NBTTagCompound compound, String name, @NotNull BlockPos pos) {
        NBTTagCompound coordsCompound = new NBTTagCompound();
        coordsCompound.func_74768_a("x", pos.func_177958_n());
        coordsCompound.func_74768_a("y", pos.func_177956_o());
        coordsCompound.func_74768_a("z", pos.func_177952_p());
        compound.func_74782_a(name, (NBTBase)coordsCompound);
    }

    @NotNull
    public static BlockPos readFromNBT(@NotNull NBTTagCompound compound, String name) {
        NBTTagCompound coordsCompound = compound.func_74775_l(name);
        int x = coordsCompound.func_74762_e("x");
        int y = coordsCompound.func_74762_e("y");
        int z = coordsCompound.func_74762_e("z");
        return new BlockPos(x, y, z);
    }

    public static void writeToNBTTagList(@NotNull NBTTagList tagList, @NotNull BlockPos pos) {
        NBTTagCompound coordsCompound = new NBTTagCompound();
        coordsCompound.func_74768_a("x", pos.func_177958_n());
        coordsCompound.func_74768_a("y", pos.func_177956_o());
        coordsCompound.func_74768_a("z", pos.func_177952_p());
        tagList.func_74742_a((NBTBase)coordsCompound);
    }

    @NotNull
    public static BlockPos readFromNBTTagList(@NotNull NBTTagList tagList, int index) {
        NBTTagCompound coordsCompound = tagList.func_150305_b(index);
        int x = coordsCompound.func_74762_e("x");
        int y = coordsCompound.func_74762_e("y");
        int z = coordsCompound.func_74762_e("z");
        return new BlockPos(x, y, z);
    }

    public static void writeToByteBuf(@NotNull ByteBuf buf, @NotNull BlockPos pos) {
        buf.writeInt(pos.func_177958_n());
        buf.writeInt(pos.func_177956_o());
        buf.writeInt(pos.func_177952_p());
    }

    @NotNull
    public static BlockPos readFromByteBuf(@NotNull ByteBuf buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        return new BlockPos(x, y, z);
    }

    public static boolean isClose(@NotNull BlockPos coordinate, @NotNull EntityCitizen citizen) {
        return (double)BlockPosUtil.getDistanceSquared(coordinate, citizen.func_180425_c()) < 4.84;
    }

    public static long getDistanceSquared(@NotNull BlockPos block1, @NotNull BlockPos block2) {
        long zDiff;
        long yDiff;
        long xDiff = (long)block1.func_177958_n() - (long)block2.func_177958_n();
        long result = xDiff * xDiff + (yDiff = (long)block1.func_177956_o() - (long)block2.func_177956_o()) * yDiff + (zDiff = (long)block1.func_177952_p() - (long)block2.func_177952_p()) * zDiff;
        if (result < 0L) {
            throw new IllegalStateException("max-sqrt is to high! Failure to catch overflow with " + xDiff + " | " + yDiff + " | " + zDiff);
        }
        return result;
    }

    public static long getDistance(@NotNull BlockPos block1, @NotNull BlockPos block2) {
        long xDiff = (long)block1.func_177958_n() - (long)block2.func_177958_n();
        long yDiff = (long)block1.func_177956_o() - (long)block2.func_177956_o();
        long zDiff = (long)block1.func_177952_p() - (long)block2.func_177952_p();
        return Math.abs(xDiff + yDiff + zDiff);
    }

    public static long getDistance2D(@NotNull BlockPos block1, @NotNull BlockPos block2) {
        long xDiff = Math.abs((long)block1.func_177958_n() - (long)block2.func_177958_n());
        long zDiff = Math.abs((long)block1.func_177952_p() - (long)block2.func_177952_p());
        return Math.abs(xDiff + zDiff);
    }

    public static long getDistanceSquared2D(@NotNull BlockPos block1, @NotNull BlockPos block2) {
        long zDiff;
        long xDiff = (long)block1.func_177958_n() - (long)block2.func_177958_n();
        long result = xDiff * xDiff + (zDiff = (long)block1.func_177952_p() - (long)block2.func_177952_p()) * zDiff;
        if (result < 0L) {
            throw new IllegalStateException("max-sqrt is to high! Failure to catch overflow with " + xDiff + " | " + zDiff);
        }
        return result;
    }

    public static TileEntity getTileEntity(@NotNull World world, @NotNull BlockPos pos) {
        return world.func_175625_s(pos);
    }

    public static List<ItemStack> getBlockDrops(@NotNull World world, @NotNull BlockPos coords, int fortune) {
        return BlockPosUtil.getBlock(world, coords).getDrops((IBlockAccess)world, new BlockPos(coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p()), BlockPosUtil.getBlockState(world, coords), fortune);
    }

    public static Block getBlock(@NotNull World world, @NotNull BlockPos coords) {
        return world.func_180495_p(coords).func_177230_c();
    }

    public static IBlockState getBlockState(@NotNull World world, @NotNull BlockPos coords) {
        return world.func_180495_p(coords);
    }

    public static boolean setBlock(@NotNull World world, BlockPos coords, @NotNull Block block) {
        return world.func_175656_a(coords, block.func_176223_P());
    }

    public static boolean setBlock(@NotNull World worldIn, @NotNull BlockPos coords, IBlockState state, int flag) {
        return worldIn.func_180501_a(coords, state, flag);
    }

    public static boolean isPathingTo(@NotNull EntityCitizen citizen, @NotNull BlockPos pos) {
        return EntityUtils.isPathingTo(citizen, pos.func_177958_n(), pos.func_177952_p());
    }

    public static boolean isWorkerAtSiteWithMove(@NotNull EntityCitizen worker, @NotNull BlockPos site) {
        return EntityUtils.isWorkerAtSiteWithMove(worker, site.func_177958_n(), site.func_177956_o(), site.func_177952_p());
    }

    public static boolean isWorkerAtSiteWithMove(@NotNull EntityCitizen worker, @NotNull BlockPos site, int range) {
        return EntityUtils.isWorkerAtSiteWithMove(worker, site.func_177958_n(), site.func_177956_o(), site.func_177952_p(), range);
    }

    public static boolean tryMoveLivingToXYZ(@NotNull EntityLiving living, @NotNull BlockPos destination) {
        return EntityUtils.tryMoveLivingToXYZ(living, destination.func_177958_n(), destination.func_177956_o(), destination.func_177952_p());
    }

    public static PathResult moveLivingToXYZ(@NotNull EntityCitizen citizen, @NotNull BlockPos destination) {
        return citizen.getNavigator().moveToXYZ(destination.func_177958_n(), destination.func_177956_o(), destination.func_177952_p(), 1.0);
    }

    public static void set(@NotNull BlockPos.MutableBlockPos pos, @NotNull BlockPos newPos) {
        pos.func_181079_c(newPos.func_177958_n(), newPos.func_177956_o(), newPos.func_177952_p());
    }

    public static boolean isEqual(@NotNull BlockPos coords, int x, int y, int z) {
        return coords.func_177958_n() == x && coords.func_177956_o() == y && coords.func_177952_p() == z;
    }

    @NotNull
    public static BlockPos fromEntity(@NotNull Entity entity) {
        return new BlockPos(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70163_u), MathHelper.func_76128_c((double)entity.field_70161_v));
    }
}

