/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.structures.helpers;

import com.minecolonies.coremod.util.Log;
import com.minecolonies.structures.fake.FakeEntity;
import com.minecolonies.structures.fake.FakeWorld;
import com.minecolonies.structures.lib.ModelHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class Structure {
    private static final double NINETY_DEGREES = 90.0;
    private static final double TWO_HUNDRED_SEVENTY_DEGREES = 270.0;
    private static final double ONE_HUNDED_EIGHTY_DEGREES = 270.0;
    private static final double SCALE = 1.001;
    private Template template;
    private Minecraft mc;
    private PlacementSettings settings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Structure(@Nullable World world, String structureName, PlacementSettings settings) {
        InputStream inputstream = MinecraftServer.class.getResourceAsStream("/assets/minecolonies/schematics/" + structureName + ".nbt");
        if (world == null || world.field_72995_K) {
            this.settings = settings;
            this.mc = Minecraft.func_71410_x();
        }
        if (inputstream == null) {
            try {
                File decorationFolder = FMLCommonHandler.instance().getMinecraftServerInstance() == null ? new File(Minecraft.func_71410_x().field_71412_D, "minecolonies/") : new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_71238_n(), "minecolonies/");
                inputstream = new FileInputStream(decorationFolder.getPath() + "/" + structureName + ".nbt");
            }
            catch (FileNotFoundException e) {
                Log.getLogger().warn("Couldn't find any structure with this name anywhere", (Throwable)e);
            }
        }
        if (inputstream == null) {
            return;
        }
        try {
            this.template = Structure.readTemplateFromStream(inputstream);
        }
        catch (IOException e) {
            Log.getLogger().warn(String.format("Failed to load template %s", structureName), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputstream);
        }
    }

    private static Template readTemplateFromStream(InputStream stream) throws IOException {
        NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)stream);
        Template template = new Template();
        template.func_186256_b(nbttagcompound);
        return template;
    }

    public boolean isTemplateMissing() {
        return this.template == null;
    }

    public Template.BlockInfo[] getBlockInfo() {
        Template.BlockInfo[] blockList = new Template.BlockInfo[this.template.field_186270_a.size()];
        blockList = this.template.field_186270_a.toArray(blockList);
        return blockList;
    }

    public Entity[] getEntityInfo(World world, BlockPos pos) {
        Template.EntityInfo[] entityInfoList = new Template.EntityInfo[this.template.field_186271_b.size()];
        entityInfoList = this.template.field_186270_a.toArray(entityInfoList);
        Entity[] entityList = null;
        for (int i = 0; i < entityInfoList.length; ++i) {
            Entity finalEntity = EntityList.func_75615_a((NBTTagCompound)entityInfoList[i].field_186249_c, (World)world);
            Vec3d entityVec = entityInfoList[i].field_186247_a.func_178787_e(new Vec3d((Vec3i)pos));
            finalEntity.func_70107_b(entityVec.field_72450_a, entityVec.field_72448_b, entityVec.field_72449_c);
        }
        return entityList;
    }

    public BlockPos getSize(Rotation rotation) {
        return this.template.func_186257_a(rotation);
    }

    public void setPlacementSettings(PlacementSettings settings) {
        this.settings = settings;
    }

    public void renderStructure(@NotNull BlockPos startingPos, @NotNull World clientWorld, @NotNull EntityPlayer player, float partialTicks) {
        Template.BlockInfo[] blockList = this.getBlockInfoWithSettings(this.settings);
        Entity[] entityList = this.getEntityInfoWithSettings(clientWorld, startingPos, this.settings);
        for (Template.BlockInfo blockInfo : blockList) {
            Block block = blockInfo.field_186243_b.func_177230_c();
            IBlockState iblockstate = blockInfo.field_186243_b;
            BlockPos blockpos = blockInfo.field_186242_a.func_177971_a((Vec3i)startingPos);
            IBlockState iBlockExtendedState = block.getExtendedState(iblockstate, (IBlockAccess)clientWorld, blockpos);
            IBakedModel ibakedmodel = Minecraft.func_71410_x().func_175602_ab().func_184389_a(iblockstate);
            TileEntity tileentity = null;
            if (block.hasTileEntity(iblockstate) && blockInfo.field_186244_c != null) {
                tileentity = block.createTileEntity(clientWorld, iblockstate);
                tileentity.func_145839_a(blockInfo.field_186244_c);
            }
            ModelHolder models = new ModelHolder(blockpos, iblockstate, iBlockExtendedState, tileentity, ibakedmodel);
            Structure.getQuads(models, models.quads);
            this.renderGhost(clientWorld, models, player, partialTicks);
        }
        for (Template.BlockInfo blockInfo : entityList) {
            if (blockInfo == null) continue;
            Minecraft.func_71410_x().func_175598_ae().func_188388_a((Entity)blockInfo, 0.0f, true);
        }
    }

    public Template.BlockInfo[] getBlockInfoWithSettings(PlacementSettings settings) {
        Template.BlockInfo[] blockList = new Template.BlockInfo[this.template.field_186270_a.size()];
        blockList = this.template.field_186270_a.toArray(blockList);
        for (int i = 0; i < blockList.length; ++i) {
            Template.BlockInfo finalInfo;
            IBlockState finalState = blockList[i].field_186243_b.func_185902_a(settings.func_186212_b()).func_185907_a(settings.func_186215_c());
            BlockPos finalPos = Template.func_186266_a((PlacementSettings)settings, (BlockPos)blockList[i].field_186242_a);
            blockList[i] = finalInfo = new Template.BlockInfo(finalPos, finalState, blockList[i].field_186244_c);
        }
        return blockList;
    }

    public Template.EntityInfo transformEntityInfoWithSettings(Template.EntityInfo entityInfo, World world, BlockPos pos, PlacementSettings settings) {
        Entity finalEntity = EntityList.func_75615_a((NBTTagCompound)entityInfo.field_186249_c, (World)world);
        Vec3d entityVec = Structure.transformedVec3d(settings, entityInfo.field_186247_a).func_178787_e(new Vec3d((Vec3i)pos));
        if (finalEntity != null) {
            finalEntity.field_70126_B = (float)((double)finalEntity.func_184217_a(settings.func_186212_b()) - 90.0);
            double rotationYaw = (double)finalEntity.func_184217_a(settings.func_186212_b()) + ((double)finalEntity.field_70177_z - (double)finalEntity.func_184229_a(settings.func_186215_c()));
            finalEntity.func_70012_b(entityVec.field_72450_a, entityVec.field_72448_b, entityVec.field_72449_c, (float)rotationYaw, finalEntity.field_70125_A);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            finalEntity.func_70039_c(nbttagcompound);
            return new Template.EntityInfo(entityInfo.field_186247_a, entityInfo.field_186248_b, nbttagcompound);
        }
        return null;
    }

    public double getRotatedYaw(Rotation transformRotation, double previousYaw) {
        switch (transformRotation) {
            case CLOCKWISE_180: {
                return previousYaw + 90.0;
            }
            case COUNTERCLOCKWISE_90: {
                return previousYaw + 270.0;
            }
            case CLOCKWISE_90: {
                return previousYaw + 270.0;
            }
        }
        return previousYaw;
    }

    public Entity[] getEntityInfoWithSettings(World world, BlockPos pos, PlacementSettings settings) {
        Template.EntityInfo[] entityInfoList = new Template.EntityInfo[this.template.field_186271_b.size()];
        entityInfoList = this.template.field_186271_b.toArray(entityInfoList);
        Entity[] entityList = new Entity[entityInfoList.length];
        for (int i = 0; i < entityInfoList.length; ++i) {
            Entity finalEntity = EntityList.func_75615_a((NBTTagCompound)entityInfoList[i].field_186249_c, (World)world);
            Vec3d entityVec = Structure.transformedVec3d(settings, entityInfoList[i].field_186247_a).func_178787_e(new Vec3d((Vec3i)pos));
            if (finalEntity != null) {
                finalEntity.field_70126_B = (float)((double)finalEntity.func_184217_a(settings.func_186212_b()) - 90.0);
                double rotation = (double)finalEntity.func_184217_a(settings.func_186212_b()) + ((double)finalEntity.field_70177_z - (double)finalEntity.func_184229_a(settings.func_186215_c()));
                finalEntity.func_70012_b(entityVec.field_72450_a, entityVec.field_72448_b, entityVec.field_72449_c, (float)rotation, finalEntity.field_70125_A);
            }
            entityList[i] = finalEntity;
        }
        return entityList;
    }

    private static void getQuads(ModelHolder holder, List<BakedQuad> quads) {
        if (holder.actualState.func_185901_i() == EnumBlockRenderType.MODEL) {
            BlockRenderLayer originalLayer = MinecraftForgeClient.getRenderLayer();
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                if (!holder.actualState.func_177230_c().canRenderInLayer(holder.actualState, layer)) continue;
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                for (EnumFacing facing : EnumFacing.values()) {
                    quads.addAll(holder.model.func_188616_a(holder.extendedState, facing, 0L));
                }
                quads.addAll(holder.model.func_188616_a(holder.extendedState, null, 0L));
            }
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)originalLayer);
        }
    }

    private void renderGhost(World world, ModelHolder holder, EntityPlayer player, float partialTicks) {
        boolean existingModel = !this.mc.field_71441_e.func_175623_d(holder.pos);
        IBlockState actualState = holder.actualState;
        Block block = actualState.func_177230_c();
        if (actualState.func_185901_i() == EnumBlockRenderType.MODEL) {
            BlockRenderLayer originalLayer = MinecraftForgeClient.getRenderLayer();
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                if (!block.canRenderInLayer(actualState, layer)) continue;
                this.mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                this.renderGhostBlock(world, holder, player, layer, existingModel, partialTicks);
                holder.setRendered(true);
            }
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)originalLayer);
        }
        if (holder.te != null && !holder.isRendered()) {
            TileEntity te = holder.te;
            te.func_174878_a(holder.pos);
            FakeWorld fakeWorld = new FakeWorld(holder.actualState, world.func_72860_G(), world.func_72912_H(), world.field_73011_w, world.field_72984_F, true);
            te.func_145834_a((World)fakeWorld);
            boolean pass = false;
            if (te.shouldRenderInPass(0)) {
                TileEntityRendererDispatcher terd = TileEntityRendererDispatcher.field_147556_a;
                terd.func_190056_a((World)fakeWorld, Minecraft.func_71410_x().field_71446_o, Minecraft.func_71410_x().field_71466_p, (Entity)new FakeEntity(fakeWorld), null, 0.0f);
                GL11.glPushMatrix();
                terd.field_147553_e = Minecraft.func_71410_x().field_71446_o;
                terd.preDrawBatch();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                terd.func_180546_a(te, partialTicks, -1);
                terd.drawBatch(0);
                GL11.glPopMatrix();
            }
        }
    }

    public static Vec3d transformedVec3d(PlacementSettings settings, Vec3d vec) {
        Mirror mirrorIn = settings.func_186212_b();
        Rotation rotationIn = settings.func_186215_c();
        double xCoord = vec.field_72450_a;
        double yCoord = vec.field_72448_b;
        double zCoord = vec.field_72449_c;
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                zCoord = 1.0 - zCoord;
                break;
            }
            case FRONT_BACK: {
                xCoord = 1.0 - xCoord;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3d(zCoord, yCoord, 1.0 - xCoord);
            }
            case CLOCKWISE_90: {
                return new Vec3d(1.0 - zCoord, yCoord, xCoord);
            }
            case CLOCKWISE_180: {
                return new Vec3d(1.0 - xCoord, yCoord, 1.0 - zCoord);
            }
        }
        return flag ? new Vec3d(xCoord, yCoord, zCoord) : vec;
    }

    private void renderGhostBlock(World world, ModelHolder holder, EntityPlayer player, BlockRenderLayer layer, boolean existingModel, float partialTicks) {
        double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        BlockPos pos = holder.pos;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)pos.func_177958_n() - dx), (double)((double)pos.func_177956_o() - dy), (double)((double)pos.func_177952_p() - dz));
        if (existingModel) {
            GlStateManager.func_179139_a((double)1.001, (double)1.001, (double)1.001);
        }
        RenderHelper.func_74518_a();
        if (layer == BlockRenderLayer.CUTOUT) {
            this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int alpha = -16777216;
        GlStateManager.func_179147_l();
        GlStateManager.func_179098_w();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        this.renderModel(world, holder, pos, -16777216);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179143_c((int)515);
        this.renderModel(world, holder, pos, -16777216);
        GlStateManager.func_179084_k();
        if (layer == BlockRenderLayer.CUTOUT) {
            this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        }
        GlStateManager.func_179121_F();
    }

    private void renderModel(World world, ModelHolder holder, BlockPos pos, int alpha) {
        for (EnumFacing facing : EnumFacing.values()) {
            this.renderQuads(world, holder.actualState, pos, holder.model.func_188616_a(holder.extendedState, facing, 0L), alpha);
        }
        this.renderQuads(world, holder.actualState, pos, holder.model.func_188616_a(holder.extendedState, null, 0L), alpha);
    }

    private void renderQuads(World world, IBlockState actualState, BlockPos pos, List<BakedQuad> quads, int alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        for (BakedQuad quad : quads) {
            buffer.func_181668_a(7, quad.getFormat());
            int color = quad.func_178212_b() ? this.getTint(world, actualState, pos, alpha, quad.func_178211_c()) : alpha | 0xFFFFFF;
            LightUtil.renderQuadColor((VertexBuffer)buffer, (BakedQuad)quad, (int)color);
            tessellator.func_78381_a();
        }
    }

    private int getTint(World world, IBlockState actualState, BlockPos pos, int alpha, int tintIndex) {
        return alpha | this.mc.func_184125_al().func_186724_a(actualState, (IBlockAccess)world, pos, tintIndex);
    }

    public List<Template.EntityInfo> getTileEntities() {
        return this.template.field_186271_b;
    }

    public PlacementSettings getSettings() {
        return this.settings;
    }
}

