/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.inventory.InventoryCitizen;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import com.minecolonies.coremod.util.InventoryUtils;
import com.minecolonies.coremod.util.Utils;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingBuilder
extends AbstractBuildingWorker {
    public static final int MAX_BUILDING_LEVEL = 5;
    private static final String BUILDER = "Builder";
    private static final String TAG_RESOURCE_LIST = "resourcesItem";
    private HashMap<String, BuildingBuilderResource> neededResources = new HashMap();

    public BuildingBuilder(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BUILDER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().triggerAchievement(ModAchievements.achievementBuildingBuilder);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().triggerAchievement(ModAchievements.achievementUpgradeBuilderMax);
        }
    }

    @Override
    @NotNull
    public String getJobName() {
        return BUILDER;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobBuilder(citizen);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagList neededResTagList = compound.func_150295_c(TAG_RESOURCE_LIST, 10);
        for (int i = 0; i < neededResTagList.func_74745_c(); ++i) {
            NBTTagCompound neededRes = neededResTagList.func_150305_b(i);
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)neededRes);
            BuildingBuilderResource resource = new BuildingBuilderResource(stack.func_77973_b(), stack.func_77952_i(), stack.field_77994_a);
            this.neededResources.put(stack.func_77977_a(), resource);
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList neededResTagList = new NBTTagList();
        for (BuildingBuilderResource resource : this.neededResources.values()) {
            NBTTagCompound neededRes = new NBTTagCompound();
            ItemStack itemStack = new ItemStack(resource.getItem(), resource.getAmount(), resource.getDamageValue());
            itemStack.func_77955_b(neededRes);
            neededResTagList.func_74742_a((NBTBase)neededRes);
        }
        compound.func_74782_a(TAG_RESOURCE_LIST, (NBTBase)neededResTagList);
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        this.updateAvailableResources();
        buf.writeInt(this.neededResources.size());
        for (Map.Entry<String, BuildingBuilderResource> entry : this.neededResources.entrySet()) {
            BuildingBuilderResource resource = this.neededResources.get(entry.getKey());
            int itemId = Item.func_150891_b((Item)resource.getItem());
            int damage = resource.getDamageValue();
            buf.writeInt(itemId);
            buf.writeInt(damage);
            buf.writeInt(resource.getAvailable());
            buf.writeInt(resource.getAmount());
        }
    }

    public Map<String, BuildingBuilderResource> getNeededResources() {
        return new HashMap<String, BuildingBuilderResource>(this.neededResources);
    }

    public void addNeededResource(@Nullable ItemStack res, int amount) {
        if (res == null || res.func_77973_b() == null || res.field_77994_a == 0 || amount == 0) {
            return;
        }
        BuildingBuilderResource resource = this.neededResources.get(res.func_77977_a());
        if (resource == null) {
            resource = new BuildingBuilderResource(res.func_77973_b(), res.func_77952_i(), amount);
        } else {
            resource.setAmount(resource.getAmount() + amount);
        }
        this.neededResources.put(res.func_77977_a(), resource);
        this.markDirty();
    }

    @Override
    public boolean neededForWorker(@Nullable ItemStack stack) {
        return Utils.isMiningTool(stack);
    }

    public void reduceNeededResource(ItemStack res, int amount) {
        int preAmount = 0;
        if (this.neededResources.containsKey(res.func_77977_a())) {
            preAmount = this.neededResources.get(res.func_77977_a()).getAmount();
        }
        if (preAmount - amount <= 0) {
            this.neededResources.remove(res.func_77977_a());
        } else {
            this.neededResources.get(res.func_77977_a()).setAmount(preAmount - amount);
        }
        this.markDirty();
    }

    public void resetNeededResources() {
        this.neededResources = new HashMap();
        this.markDirty();
    }

    private void updateAvailableResources() {
        EntityCitizen builder = this.getWorkerEntity();
        InventoryCitizen builderInventory = null;
        if (builder != null) {
            builderInventory = builder.getInventoryCitizen();
        }
        for (Map.Entry<String, BuildingBuilderResource> entry : this.neededResources.entrySet()) {
            TileEntityColonyBuilding chestInventory;
            BuildingBuilderResource resource = entry.getValue();
            resource.setAvailable(0);
            if (builderInventory != null) {
                resource.addAvailable(InventoryUtils.getItemCountInInventory((IInventory)builderInventory, resource.getItem(), resource.getDamageValue()));
            }
            if ((chestInventory = this.getTileEntity()) != null) {
                resource.addAvailable(InventoryUtils.getItemCountInInventory((IInventory)chestInventory, resource.getItem(), resource.getDamageValue()));
            }
            if (builder == null) continue;
            for (BlockPos pos : this.getAdditionalCountainers()) {
                TileEntity entity = builder.field_70170_p.func_175625_s(pos);
                if (!(entity instanceof TileEntityChest)) continue;
                resource.addAvailable(InventoryUtils.getItemCountInInventory((IInventory)((TileEntityChest)entity), resource.getItem(), resource.getDamageValue()));
            }
        }
    }

    public boolean requiresResourceForBuilding(ItemStack stack) {
        return this.neededResources.containsKey(stack.func_77977_a());
    }

    @Override
    public boolean transferStack(@NotNull ItemStack stack, @NotNull World world) {
        if (super.transferStack(stack, world)) {
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public ItemStack forceTransferStack(ItemStack stack, World world) {
        ItemStack itemStack = super.forceTransferStack(stack, world);
        if (itemStack != null) {
            this.markDirty();
            return itemStack;
        }
        return itemStack;
    }
}

