/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.IColony;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public class DeleteColonyCommand
extends AbstractSingleCommand {
    public static final String DESC = "delete";
    private static final String NO_COLONY_FOUND_MESSAGE_ID = "Colony with ID %d not found.";
    private static final String NO_ARGUMENTS = "Please define a colony to delete";

    public DeleteColonyCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId|OwnerName>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        int colonyId;
        if (args.length == 0) {
            sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString(NO_ARGUMENTS));
            return;
        }
        if (args.length == 0) {
            IColony colony = null;
            if (sender instanceof EntityPlayer) {
                colony = ColonyManager.getIColonyByOwner(((EntityPlayer)sender).field_70170_p, (EntityPlayer)sender);
            }
            if (colony == null) {
                sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString(NO_ARGUMENTS));
                return;
            }
            colonyId = colony.getID();
        } else {
            colonyId = DeleteColonyCommand.getIthArgument(args, 0, -1);
        }
        EntityPlayer player = (EntityPlayer)sender;
        if (!this.canPlayerUseCommand(player, AbstractSingleCommand.Commands.valueOf("DELETECOLONY"), colonyId)) {
            sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString("You are not allowed to do that!"));
            return;
        }
        Colony colony = ColonyManager.getColony(colonyId);
        if (colony == null) {
            sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString(NO_COLONY_FOUND_MESSAGE_ID));
            return;
        }
        if (sender instanceof EntityPlayer) {
            if (this.canPlayerUseCommand(player, AbstractSingleCommand.Commands.DELETECOLONY, colonyId)) {
                server.func_152344_a(() -> ColonyManager.deleteColony(colony.getID()));
                return;
            }
            sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString("You are not allowed to do that!"));
            return;
        }
        server.func_152344_a(() -> ColonyManager.deleteColony(colony.getID()));
    }

    @Override
    public boolean canRankUseCommand(@NotNull Colony colony, @NotNull EntityPlayer player) {
        return colony.getPermissions().getRank(player).equals((Object)Permissions.Rank.OWNER);
    }

    @NotNull
    private static UUID getUUIDFromName(@NotNull ICommandSender sender, String ... args) {
        GameProfile profile;
        MinecraftServer tempServer = sender.func_130014_f_().func_73046_m();
        if (tempServer != null && (profile = tempServer.func_152358_ax().func_152655_a(args[0])) != null) {
            return profile.getId();
        }
        return null;
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return index == 0 && args.length > 0 && !args[0].isEmpty() && DeleteColonyCommand.getIthArgument(args, 0, Integer.MAX_VALUE) == Integer.MAX_VALUE;
    }
}

