/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.configuration.Configurations;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.ServerUtils;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.jetbrains.annotations.NotNull;

public class RandomTeleportCommand
extends AbstractSingleCommand {
    public static final String DESC = "rtp";
    private static final int ATTEMPTS = Configurations.numberOfAttemptsForSafeTP;
    private static final int UPPER_BOUNDS = Configurations.maxDistanceFromWorldSpawn * 2;
    private static final int LOWER_BOUNDS = Configurations.maxDistanceFromWorldSpawn;
    private static final int SPAWN_NO_TP = Configurations.minDistanceFromWorldSpawn;
    private static final int STARTING_Y = 250;
    private static final double SAFETY_DROP = 4.0;
    private static final String CANT_FIND_PLAYER = "No player found for teleport, please define one.";

    public RandomTeleportCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + DESC + "<playerName>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        if (SPAWN_NO_TP >= LOWER_BOUNDS) {
            sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString("Please have an admin raise the maxDistanceFromWorldSpawn number in config."));
            return;
        }
        if (!this.canCommandSenderUseCommand(AbstractSingleCommand.Commands.COLONYTP)) {
            sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString("Not happenin bro!!, ask an OP to TP you."));
            return;
        }
        EntityPlayer playerToTeleport = null;
        if (sender instanceof EntityPlayer) {
            playerToTeleport = (EntityPlayer)sender;
        }
        if (args.length != 0 && this.isPlayerOpped(sender, "ctp")) {
            World world = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_();
            playerToTeleport = ServerUtils.getPlayerFromUUID(FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152655_a(args[0]).getId(), world);
            sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString("TPin Player: " + playerToTeleport.func_70005_c_()));
        }
        if (playerToTeleport == null) {
            sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString(CANT_FIND_PLAYER));
            return;
        }
        playerToTeleport.func_174793_f().func_145747_a((ITextComponent)new TextComponentString("Buckle up buttercup, this ain't no joy ride!!!"));
        RandomTeleportCommand.teleportPlayer(sender, playerToTeleport);
    }

    private static int getRandCoordinate() {
        Random rnd = new Random();
        int x = rnd.nextInt(UPPER_BOUNDS) - LOWER_BOUNDS;
        while (x > -SPAWN_NO_TP && x < SPAWN_NO_TP) {
            x = rnd.nextInt(UPPER_BOUNDS) - LOWER_BOUNDS;
        }
        return x;
    }

    private static void teleportPlayer(ICommandSender sender, EntityPlayer playerToTeleport) {
        for (int attCounter = 0; attCounter <= ATTEMPTS; ++attCounter) {
            boolean foundPosition;
            BlockPos groundPosition;
            int x = RandomTeleportCommand.getRandCoordinate();
            int z = RandomTeleportCommand.getRandCoordinate();
            if (ColonyManager.getColony(sender.func_130014_f_(), new BlockPos(x, 250, z)) != null || (groundPosition = BlockPosUtil.findLand(new BlockPos(x, 250, z), sender.func_130014_f_())) == null || !(foundPosition = BlockPosUtil.isPositionSafe(sender, groundPosition))) continue;
            playerToTeleport.func_70634_a((double)groundPosition.func_177958_n(), (double)groundPosition.func_177956_o() + 4.0, (double)groundPosition.func_177952_p());
            return;
        }
        playerToTeleport.func_174793_f().func_145747_a((ITextComponent)new TextComponentString("Couldn't find a safe spot.  Try again in a moment."));
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return index == 0;
    }
}

