/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.IColony;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public class ShowColonyInfoCommand
extends AbstractSingleCommand {
    public static final String DESC = "info";
    private static final String ID_TEXT = "\u00a72ID: \u00a7f";
    private static final String NAME_TEXT = "\u00a72 Name: \u00a7f";
    private static final String MAYOR_TEXT = "\u00a72Mayor: \u00a7f";
    private static final String COORDINATES_TEXT = "\u00a72Coordinates: \u00a7f";
    private static final String COORDINATES_XYZ = "\u00a74x=\u00a7f%s \u00a74y=\u00a7f%s \u00a74z=\u00a7f%s";
    private static final String CITIZENS = "\u00a72Citizens: \u00a7f";
    private static final String NO_COLONY_FOUND_MESSAGE = "Colony with mayor %s not found.";
    private static final String NO_COLONY_FOUND_MESSAGE_ID = "Colony with ID %d not found.";

    public ShowColonyInfoCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId|OwnerName>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        int colonyId = ShowColonyInfoCommand.getIthArgument(args, 0, -1);
        IColony tempColony = ColonyManager.getColony(colonyId);
        if (sender instanceof EntityPlayer) {
            EntityPlayer player;
            UUID mayorID = sender.func_174793_f().func_110124_au();
            if (tempColony == null) {
                tempColony = ColonyManager.getIColonyByOwner(sender.func_130014_f_(), mayorID);
            }
            if (!this.canPlayerUseCommand(player = (EntityPlayer)sender, AbstractSingleCommand.Commands.SHOWCOLONYINFO, colonyId)) {
                sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString("You are not allowed to do that!"));
                return;
            }
        }
        if (tempColony == null) {
            if (colonyId == -1 && args.length != 0) {
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format(NO_COLONY_FOUND_MESSAGE, args[0])));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format(NO_COLONY_FOUND_MESSAGE_ID, colonyId)));
            }
            return;
        }
        Colony colony = ColonyManager.getColony(colonyId);
        if (colony == null) {
            if (colonyId == -1 && args.length != 0) {
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format(NO_COLONY_FOUND_MESSAGE, args[0])));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format(NO_COLONY_FOUND_MESSAGE_ID, colonyId)));
            }
            return;
        }
        BlockPos position = colony.getCenter();
        sender.func_145747_a((ITextComponent)new TextComponentString(ID_TEXT + colony.getID() + NAME_TEXT + colony.getName()));
        String mayor = colony.getPermissions().getOwnerName();
        sender.func_145747_a((ITextComponent)new TextComponentString(MAYOR_TEXT + mayor));
        sender.func_145747_a((ITextComponent)new TextComponentString(CITIZENS + colony.getCitizens().size() + "/" + colony.getMaxCitizens()));
        sender.func_145747_a((ITextComponent)new TextComponentString(COORDINATES_TEXT + String.format(COORDINATES_XYZ, position.func_177958_n(), position.func_177956_o(), position.func_177952_p())));
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return index == 0 && args.length > 0 && !args[0].isEmpty() && ShowColonyInfoCommand.getIthArgument(args, 0, Integer.MAX_VALUE) == Integer.MAX_VALUE;
    }
}

