/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.configuration;

import com.minecolonies.coremod.configuration.Configurations;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public final class ConfigurationHandler {
    private static final String CATEGORY_GAMEPLAY = "gameplay";
    private static final String CATEGORY_PATHFINDING = "pathfinding";
    private static final String CATEGORY_NAMES = "names";
    private static final String FORMAT_RANGE = "%s (range: %s ~ %s, default: %s)";

    private ConfigurationHandler() {
    }

    public static synchronized void init(File file) {
        Configuration config = new Configuration(file);
        try {
            config.load();
            Configurations.builderPlaceConstructionTape = config.get(CATEGORY_GAMEPLAY, "placeConstructionTape", Configurations.builderPlaceConstructionTape, "Should builder place construction tape").getBoolean();
            Configurations.workingRangeTownHall = config.get(CATEGORY_GAMEPLAY, "workingRangeTownHall", Configurations.workingRangeTownHall, "Colony size (radius)").getInt();
            Configurations.townHallPadding = config.get(CATEGORY_GAMEPLAY, "townHallPadding", Configurations.townHallPadding, "Empty space between town hall boundaries").getInt();
            Configurations.supplyChests = config.get(CATEGORY_GAMEPLAY, "supplyChests", Configurations.supplyChests, "Allow crafting of a Supply Chest").getBoolean();
            Configurations.allowInfiniteSupplyChests = config.get(CATEGORY_GAMEPLAY, "allowInfiniteSupplyChests", Configurations.allowInfiniteSupplyChests, "Allow infinite placing of Supply Chests?").getBoolean();
            Configurations.citizenRespawnInterval = ConfigurationHandler.getClampedInt(config, CATEGORY_GAMEPLAY, "citizenRespawnInterval", Configurations.citizenRespawnInterval, 10, 600, "Citizen respawn interval in seconds");
            Configurations.builderInfiniteResources = config.get(CATEGORY_GAMEPLAY, "builderInfiniteResources", Configurations.builderInfiniteResources, "Does Builder have infinite resources?").getBoolean();
            Configurations.builderBuildBlockDelay = config.get(CATEGORY_GAMEPLAY, "builderBuildBlockDelay", Configurations.builderBuildBlockDelay, "How many tick between placing blocks for the builder?").getInt();
            Configurations.blockMiningDelayModifier = config.get(CATEGORY_GAMEPLAY, "blockMiningDelayModifier", Configurations.blockMiningDelayModifier, "Block mining Delay modifier, taken into account to determine how long a block need to be successfully mined").getInt();
            Configurations.enableColonyProtection = config.get(CATEGORY_GAMEPLAY, "enableColonyProtection", Configurations.enableColonyProtection, "Enable the automatic colony protection?").getBoolean();
            Configurations.turnOffExplosionsInColonies = config.get(CATEGORY_GAMEPLAY, "turnOffExplosionsInColonies", Configurations.turnOffExplosionsInColonies, "Turn off explosions inside the colonies radius?").getBoolean();
            Configurations.canPlayerUseCitizenInfoCommand = config.get(CATEGORY_GAMEPLAY, "canPlayerUseCitizenInfoCommand", Configurations.canPlayerUseCitizenInfoCommand, "Players get CitizenInfoCommand").getBoolean();
            Configurations.canPlayerUseRTPCommand = config.get(CATEGORY_GAMEPLAY, "canPlayerUseRTPCommand", Configurations.canPlayerUseRTPCommand, "Players can use the MC TP Command or not").getBoolean();
            Configurations.canPlayerUseDeleteColonyCommand = config.get(CATEGORY_GAMEPLAY, "canPlayerUseDeleteColonyCommand", Configurations.canPlayerUseDeleteColonyCommand, "Players get DeleteColonyCommand").getBoolean();
            Configurations.canPlayerUseKillCitizensCommand = config.get(CATEGORY_GAMEPLAY, "canPlayerUseKillCitizensCommand", Configurations.canPlayerUseKillCitizensCommand, "Players get KillCitizensCommand").getBoolean();
            Configurations.canPlayerUseListCitizensCommand = config.get(CATEGORY_GAMEPLAY, "canPlayerUseListCitizensCommand", Configurations.canPlayerUseListCitizensCommand, "Players get ListCitizensCommand").getBoolean();
            Configurations.canPlayerRespawnCitizensCommand = config.get(CATEGORY_GAMEPLAY, "canPlayerRespawnCitizensCommand", Configurations.canPlayerRespawnCitizensCommand, "Players get RespawnCitizensCommand").getBoolean();
            Configurations.canPlayerUseShowColonyInfoCommand = config.get(CATEGORY_GAMEPLAY, "canPlayerUseShowColonyInfoCommand", Configurations.canPlayerUseShowColonyInfoCommand, "Players get ShowColonyInfoCommand").getBoolean();
            Configurations.canPlayerUseAddOfficerCommand = config.get(CATEGORY_GAMEPLAY, "canPlayerUseAddOfficerCommand", Configurations.canPlayerUseAddOfficerCommand, "Players get AddOfficerCommand").getBoolean();
            Configurations.canPlayerUseRefreshColonyCommand = config.get(CATEGORY_GAMEPLAY, "canPlayerUseRefreshColonyCommand", Configurations.canPlayerUseRefreshColonyCommand, "Players get RefreshColonyCommand").getBoolean();
            Configurations.maxDistanceFromWorldSpawn = config.get(CATEGORY_GAMEPLAY, "maxDistanceFromWorldSpawn", Configurations.maxDistanceFromWorldSpawn, "Distance from spawn in all directions").getInt();
            Configurations.deliverymanInfiniteResources = config.get(CATEGORY_GAMEPLAY, "deliverymanInfiniteResources", Configurations.deliverymanInfiniteResources, "Does Deliveryman have infinite resources?").getBoolean();
            Configurations.maxCitizens = config.get(CATEGORY_GAMEPLAY, "maxCitizens", Configurations.maxCitizens, "Maximum number of citizens").getInt();
            Configurations.alwaysRenderNameTag = config.get(CATEGORY_GAMEPLAY, "alwaysRenderNameTag", Configurations.alwaysRenderNameTag, "Always render Citizen's name tag?").getBoolean();
            Configurations.maxBlocksCheckedByBuilder = config.get(CATEGORY_GAMEPLAY, "maxBlocksCheckedByBuilder", Configurations.maxBlocksCheckedByBuilder, "Limits the number of checked blocks per builder update").getInt();
            Configurations.chatFrequency = config.get(CATEGORY_GAMEPLAY, "chatFrequency", Configurations.chatFrequency, "Chat Frequency (seconds)").getInt();
            Configurations.enableInDevelopmentFeatures = config.get(CATEGORY_GAMEPLAY, "development", Configurations.enableInDevelopmentFeatures, "Display in-development features which do not work and may break your game").getBoolean();
            Configurations.pathfindingDebugDraw = config.get(CATEGORY_PATHFINDING, "debugDraw", Configurations.pathfindingDebugDraw, "Render pathfinding results for debugging purposes (SSP only)").getBoolean();
            Configurations.pathfindingDebugVerbosity = config.get(CATEGORY_PATHFINDING, "debugVerbosity", Configurations.pathfindingDebugVerbosity, "Debug output verbosity of pathfinding (0=none, 1=results, 2=live work)").getInt();
            Configurations.pathfindingMaxThreadCount = config.get(CATEGORY_PATHFINDING, "maxThreads", Configurations.pathfindingMaxThreadCount, "Maximum number of threads to use for pathfinding.").getInt();
            Configurations.maleFirstNames = config.get(CATEGORY_NAMES, "maleFirstNames", Configurations.maleFirstNames, "Male First Names").getStringList();
            Configurations.femaleFirstNames = config.get(CATEGORY_NAMES, "femaleFirstNames", Configurations.femaleFirstNames, "Female First Names").getStringList();
            Configurations.lastNames = config.get(CATEGORY_NAMES, "lastNames", Configurations.lastNames, "Last Names").getStringList();
        }
        finally {
            config.save();
        }
    }

    private static int getClampedInt(Configuration config, String category, String key, int defaultValue, int min, int max, String comment) {
        return config.get(category, key, defaultValue, String.format(FORMAT_RANGE, comment, min, max, defaultValue), min, max).getInt();
    }
}

