/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobDeliveryman;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.ai.item.handling.ItemStorage;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.entity.pathfinding.WalkToProxy;
import com.minecolonies.coremod.inventory.InventoryCitizen;
import com.minecolonies.coremod.util.InventoryFunctions;
import com.minecolonies.coremod.util.InventoryUtils;
import com.minecolonies.coremod.util.Log;
import com.minecolonies.coremod.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentTranslation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIBasic<J extends AbstractJob>
extends AbstractAISkeleton<J> {
    public static final int EXCEPTION_TIMEOUT = 100;
    private static final int DELAY_RECHECK = 10;
    private static final int DEFAULT_RANGE_FOR_DELAY = 4;
    private static final int ACTIONS_UNTIL_DUMP = 32;
    private static final int HIT_EVERY_X_TICKS = 5;
    @NotNull
    private final List<ItemStack> itemsNeeded = new ArrayList<ItemStack>();
    @Nullable
    protected BlockPos currentWorkingLocation = null;
    @Nullable
    protected BlockPos currentStandingLocation = null;
    private int delay = 0;
    private boolean hasDelayed = false;
    private int actionsDone = 0;
    private WalkToProxy proxy;
    private int exceptionTimer = 1;

    protected AbstractEntityAIBasic(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget(this::initSafetyChecks), new AITarget(this::updateVisualState), new AITarget(this::waitingForSomething, this::getState), new AITarget(() -> this.getOwnBuilding().areItemsNeeded(), this::waitForNeededItems), new AITarget(() -> this.getOwnBuilding().needsShovel(), this::waitForShovel), new AITarget(() -> this.getOwnBuilding().needsAxe(), this::waitForAxe), new AITarget(() -> this.getOwnBuilding().needsHoe(), this::waitForHoe), new AITarget(() -> this.getOwnBuilding().needsPickaxe(), this::waitForPickaxe), new AITarget(() -> this.getOwnBuilding().needsWeapon(), this::waitForWeapon), new AITarget(AIState.INVENTORY_FULL, this::dumpInventory), new AITarget(this::inventoryNeedsDump, AIState.INVENTORY_FULL));
    }

    @Override
    protected void onException(RuntimeException e) {
        try {
            int timeout = 100 * this.exceptionTimer;
            this.setDelay(timeout);
            this.exceptionTimer *= 2;
            if (this.worker != null) {
                String name = this.worker.func_70005_c_();
                BlockPos workerPosition = this.worker.func_180425_c();
                AbstractJob colonyJob = this.worker.getColonyJob();
                String jobName = colonyJob == null ? "null" : colonyJob.getName();
                Log.getLogger().error("Pausing Entity " + name + " (" + jobName + ") at " + workerPosition + " for " + timeout + " Seconds because of error:");
            } else {
                Log.getLogger().error("Pausing Entity that is null for " + timeout + " Seconds because of error:");
            }
            e.printStackTrace();
        }
        catch (RuntimeException exp) {
            Log.getLogger().error("Welp reporting crashed:");
            exp.printStackTrace();
            Log.getLogger().error("Caused by ai exception:");
            e.printStackTrace();
        }
    }

    protected final void setDelay(int timeout) {
        this.delay = timeout;
    }

    private boolean inventoryNeedsDump() {
        return (this.worker.isInventoryFull() || this.actionsDone >= this.getActionsDoneUntilDumping() || this.wantInventoryDumped()) && !(this.job instanceof JobDeliveryman);
    }

    protected int getActionsDoneUntilDumping() {
        return 32;
    }

    protected boolean wantInventoryDumped() {
        return false;
    }

    @Nullable
    private AIState initSafetyChecks() {
        if (null == this.getOwnBuilding()) {
            if (this.getState() == AIState.INIT) {
                return AIState.INIT;
            }
            return AIState.IDLE;
        }
        if (this.getState() == AIState.INIT) {
            return AIState.IDLE;
        }
        return null;
    }

    @Nullable
    protected AbstractBuildingWorker getOwnBuilding() {
        return this.worker.getWorkBuilding();
    }

    private AIState updateVisualState() {
        this.job.setNameTag(this.getState().toString());
        this.updateRenderMetaData();
        return null;
    }

    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata("");
    }

    private boolean waitingForSomething() {
        if (this.delay > 0) {
            if (this.currentStandingLocation != null && !this.worker.isWorkerAtSiteWithMove(this.currentStandingLocation, 4)) {
                return true;
            }
            if (this.delay % 5 == 0) {
                this.worker.hitBlockWithToolInHand(this.currentWorkingLocation);
            }
            --this.delay;
            return true;
        }
        this.clearWorkTarget();
        return false;
    }

    private void clearWorkTarget() {
        this.currentStandingLocation = null;
        this.currentWorkingLocation = null;
        this.delay = 0;
    }

    @NotNull
    private AIState waitForNeededItems() {
        this.delay = 10;
        return this.lookForNeededItems();
    }

    @NotNull
    private AIState lookForNeededItems() {
        this.syncNeededItemsWithInventory();
        if (!this.getOwnBuilding().areItemsNeeded()) {
            this.itemsNeeded.clear();
            this.job.clearItemsNeeded();
            return AIState.IDLE;
        }
        if (!this.walkToBuilding()) {
            this.delay += 10;
            ItemStack first = this.getOwnBuilding().getFirstNeededItem();
            if (this.isInHut(first)) {
                return AIState.NEEDS_ITEM;
            }
            if (!this.getOwnBuilding().hasOnGoingDelivery()) {
                this.requestWithoutSpam(first.field_77994_a + " " + first.func_82833_r());
            }
        }
        return AIState.NEEDS_ITEM;
    }

    private void syncNeededItemsWithInventory() {
        this.job.clearItemsNeeded();
        this.itemsNeeded.forEach(this.job::addItemNeeded);
        InventoryUtils.getInventoryAsList(this.worker.getInventoryCitizen()).forEach(this.job::removeItemNeeded);
        this.getOwnBuilding().setItemsCurrentlyNeeded(this.job.getItemsNeeded());
    }

    protected final boolean walkToBuilding() {
        AbstractBuildingWorker ownBuilding = this.getOwnBuilding();
        return ownBuilding == null || this.walkToBlock(ownBuilding.getLocation());
    }

    public boolean isInHut(@Nullable ItemStack is) {
        AbstractBuildingWorker building = this.getOwnBuilding();
        if (building != null) {
            boolean hasItem = this.isInTileEntity(building.getTileEntity(), is);
            if (hasItem) {
                return true;
            }
            for (BlockPos pos : building.getAdditionalCountainers()) {
                TileEntity entity = this.world.func_175625_s(pos);
                if (!(entity instanceof TileEntityChest) || !(hasItem = this.isInTileEntity((TileEntityChest)entity, is))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isToolInHut(String tool) {
        AbstractBuildingWorker building = this.getOwnBuilding();
        if (building != null) {
            boolean hasItem = this.isToolInTileEntity(building.getTileEntity(), tool);
            if (hasItem) {
                return true;
            }
            for (BlockPos pos : building.getAdditionalCountainers()) {
                TileEntity entity = this.world.func_175625_s(pos);
                if (!(entity instanceof TileEntityChest) || !(hasItem = this.isToolInTileEntity((TileEntityChest)entity, tool))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isToolInTileEntity(TileEntityChest entity, String tool) {
        return InventoryFunctions.matchFirstInInventoryWithInventory((IInventory)entity, stack -> Utils.isTool(stack, tool), this::takeItemStackFromChest);
    }

    public boolean isToolInTileEntity(TileEntityChest entity, String tool, int toolLevel) {
        return InventoryFunctions.matchFirstInInventoryWithInventory((IInventory)entity, stack -> Utils.isTool(stack, tool) && InventoryUtils.hasToolLevel(tool, stack, toolLevel), this::takeItemStackFromChest);
    }

    public boolean isInTileEntity(TileEntityChest entity, ItemStack is) {
        return is != null && InventoryFunctions.matchFirstInInventoryWithInventory((IInventory)entity, stack -> stack != null && is.func_77969_a(stack), this::takeItemStackFromChest);
    }

    private void requestWithoutSpam(@NotNull TextComponentBase chat) {
        this.chatSpamFilter.requestTextComponentWithoutSpam(chat);
    }

    private void requestWithoutSpam(@NotNull String chat) {
        this.chatSpamFilter.requestTextStringWithoutSpam(chat);
    }

    protected final boolean walkToBlock(@NotNull BlockPos stand) {
        return this.walkToBlock(stand, 4);
    }

    protected final boolean walkToBlock(@NotNull BlockPos stand, int range) {
        if (this.proxy == null) {
            this.proxy = new WalkToProxy(this.worker);
        }
        if (this.proxy.walkToBlock(stand, range)) {
            this.workOnBlock(null, stand, 10);
            return true;
        }
        return false;
    }

    private void workOnBlock(@Nullable BlockPos target, @Nullable BlockPos stand, int timeout) {
        this.currentWorkingLocation = target;
        this.currentStandingLocation = stand;
        this.delay = timeout;
    }

    public void takeItemStackFromChest(@NotNull Tuple<Integer, IInventory> tuple) {
        InventoryUtils.takeStackInSlot((IInventory)tuple.func_76340_b(), this.worker.getInventoryCitizen(), (Integer)tuple.func_76341_a());
    }

    @NotNull
    private AIState waitForShovel() {
        if (this.checkForShovel()) {
            this.delay += 10;
            return AIState.NEEDS_SHOVEL;
        }
        return AIState.IDLE;
    }

    private boolean checkForShovel() {
        this.getOwnBuilding().setNeedsShovel(this.checkForTool("shovel"));
        return this.getOwnBuilding().needsShovel();
    }

    private boolean checkForTool(@NotNull String tool) {
        boolean needsTool = !InventoryFunctions.matchFirstInInventory(this.worker.getInventoryCitizen(), stack -> Utils.isTool(stack, tool), xva$0 -> InventoryFunctions.doNothing(xva$0));
        int hutLevel = this.worker.getWorkBuilding().getBuildingLevel();
        InventoryCitizen inventory = this.worker.getInventoryCitizen();
        boolean isUsable = InventoryUtils.hasToolLevel(tool, inventory, hutLevel);
        if (!needsTool && isUsable) {
            return false;
        }
        this.delay += 10;
        if (this.walkToBuilding()) {
            return true;
        }
        if (this.isToolInHut(tool)) {
            return false;
        }
        if (!this.getOwnBuilding().hasOnGoingDelivery()) {
            this.chatSpamFilter.talkWithoutSpam("entity.worker.toolRequest", tool, InventoryUtils.swapToolGrade(hutLevel));
        }
        return true;
    }

    @NotNull
    private AIState waitForAxe() {
        if (this.checkForAxe()) {
            this.delay += 10;
            return AIState.NEEDS_AXE;
        }
        return AIState.IDLE;
    }

    protected boolean checkForAxe() {
        this.getOwnBuilding().setNeedsAxe(this.checkForTool("axe"));
        return this.getOwnBuilding().needsAxe();
    }

    @NotNull
    private AIState waitForHoe() {
        if (this.checkForHoe()) {
            this.delay += 10;
            return AIState.NEEDS_HOE;
        }
        return AIState.IDLE;
    }

    protected boolean checkForHoe() {
        this.getOwnBuilding().setNeedsHoe(this.checkForTool("hoe"));
        return this.getOwnBuilding().needsHoe();
    }

    @NotNull
    private AIState waitForPickaxe() {
        if (this.checkForPickaxe(this.getOwnBuilding().getNeededPickaxeLevel())) {
            this.delay += 10;
            return AIState.NEEDS_PICKAXE;
        }
        return AIState.IDLE;
    }

    private boolean checkForPickaxe(int minlevel) {
        this.getOwnBuilding().setNeedsPickaxe(!InventoryFunctions.matchFirstInInventory(this.worker.getInventoryCitizen(), stack -> Utils.checkIfPickaxeQualifies(minlevel, Utils.getMiningLevel(stack, "pickaxe")), xva$0 -> InventoryFunctions.doNothing(xva$0)));
        this.delay += 10;
        InventoryCitizen inventory = this.worker.getInventoryCitizen();
        int hutLevel = this.worker.getWorkBuilding().getBuildingLevel();
        boolean isUsable = InventoryUtils.hasToolLevel("pickaxe", inventory, hutLevel);
        if (!isUsable) {
            this.getOwnBuilding().setNeedsPickaxe(true);
        }
        if (this.getOwnBuilding().needsPickaxe()) {
            this.getOwnBuilding().setNeedsPickaxeLevel(minlevel);
            if (this.walkToBuilding()) {
                return false;
            }
            if (this.isPickaxeInHut(minlevel)) {
                return true;
            }
            if (!this.getOwnBuilding().hasOnGoingDelivery()) {
                this.chatSpamFilter.talkWithoutSpam("entity.worker.pickaxeRequest", InventoryUtils.swapToolGrade(minlevel), InventoryUtils.swapToolGrade(hutLevel));
            }
        }
        return this.getOwnBuilding().needsPickaxe();
    }

    private boolean isPickaxeInHut(int minlevel) {
        AbstractBuildingWorker buildingWorker = this.getOwnBuilding();
        return buildingWorker != null && InventoryFunctions.matchFirstInInventoryWithInventory((IInventory)buildingWorker.getTileEntity(), stack -> Utils.checkIfPickaxeQualifies(minlevel, Utils.getMiningLevel(stack, "pickaxe")), this::takeItemStackFromChest);
    }

    @NotNull
    private AIState waitForWeapon() {
        if (this.checkForWeapon()) {
            this.delay += 10;
            return AIState.NEEDS_WEAPON;
        }
        return AIState.IDLE;
    }

    public boolean checkForWeapon() {
        this.getOwnBuilding().setNeedsWeapon(!InventoryFunctions.matchFirstInInventory(this.worker.getInventoryCitizen(), stack -> stack != null && Utils.doesItemServeAsWeapon(stack), xva$0 -> InventoryFunctions.doNothing(xva$0)));
        this.delay += 10;
        if (this.getOwnBuilding().needsWeapon()) {
            if (this.walkToBuilding()) {
                return false;
            }
            if (this.isWeaponInHut()) {
                return true;
            }
            this.requestWithoutSpam((TextComponentBase)new TextComponentTranslation("com.minecolonies.coremod.job.guard.needWeapon", new Object[0]));
        }
        return this.getOwnBuilding().needsWeapon();
    }

    private boolean isWeaponInHut() {
        AbstractBuildingWorker buildingWorker = this.getOwnBuilding();
        return buildingWorker != null && InventoryFunctions.matchFirstInInventoryWithInventory((IInventory)buildingWorker.getTileEntity(), stack -> stack != null && Utils.doesItemServeAsWeapon(stack), this::takeItemStackFromChest);
    }

    @NotNull
    private AIState dumpInventory() {
        if (this.dumpOneMoreSlot()) {
            this.delay += 10;
            return AIState.INVENTORY_FULL;
        }
        if (this.isInventoryAndChestFull()) {
            this.chatSpamFilter.talkWithoutSpam("entity.worker.inventoryFullChestFull", new Object[0]);
        }
        this.itemsNiceToHave().forEach(this::isInHut);
        this.clearActionsDone();
        return AIState.IDLE;
    }

    private boolean dumpOneMoreSlot() {
        return this.dumpOneMoreSlot(this.getOwnBuilding()::neededForWorker);
    }

    private boolean isInventoryAndChestFull() {
        AbstractBuildingWorker buildingWorker = this.getOwnBuilding();
        return InventoryUtils.isInventoryFull(this.worker.getInventoryCitizen()) && buildingWorker != null && InventoryUtils.isInventoryFull((IInventory)buildingWorker.getTileEntity());
    }

    @NotNull
    protected List<ItemStack> itemsNiceToHave() {
        return new ArrayList<ItemStack>();
    }

    private void clearActionsDone() {
        this.actionsDone = 0;
    }

    private boolean dumpOneMoreSlot(@NotNull Predicate<ItemStack> keepIt) {
        HashMap alreadyKept = new HashMap();
        Map<ItemStorage, Integer> shouldKeep = this.getOwnBuilding().getRequiredItemsAndAmount();
        AbstractBuildingWorker buildingWorker = this.getOwnBuilding();
        return buildingWorker != null && (this.walkToBuilding() || InventoryFunctions.matchFirstInInventory((IInventory)this.worker.getInventoryCitizen(), (i, stack) -> stack != null && !keepIt.test((ItemStack)stack) && this.shouldDumpItem(alreadyKept, shouldKeep, buildingWorker, (ItemStack)stack, (int)i)));
    }

    private boolean shouldDumpItem(@NotNull Map<ItemStorage, Integer> alreadyKept, @NotNull Map<ItemStorage, Integer> shouldKeep, @NotNull AbstractBuildingWorker buildingWorker, @NotNull ItemStack stack, int i) {
        ItemStack returnStack;
        int amountToKeep = 0;
        if (AbstractEntityAIBasic.keptEnough(alreadyKept, shouldKeep, stack)) {
            returnStack = InventoryUtils.setStack((IInventory)buildingWorker.getTileEntity(), stack);
        } else {
            ItemStorage tempStorage = new ItemStorage(stack.func_77973_b(), stack.func_77952_i(), stack.field_77994_a, false);
            ItemStack tempStack = AbstractEntityAIBasic.handleKeepX(alreadyKept, shouldKeep, tempStorage);
            if (tempStack == null || tempStack.field_77994_a == 0) {
                return false;
            }
            amountToKeep = stack.field_77994_a - tempStorage.getAmount();
            returnStack = InventoryUtils.setStack((IInventory)buildingWorker.getTileEntity(), tempStack);
        }
        if (returnStack == null) {
            this.worker.getInventoryCitizen().func_70298_a(i, stack.field_77994_a - amountToKeep);
            return amountToKeep == 0;
        }
        this.worker.getInventoryCitizen().func_70298_a(i, stack.field_77994_a - returnStack.field_77994_a - amountToKeep);
        return stack.field_77994_a != returnStack.field_77994_a;
    }

    private static boolean keptEnough(@NotNull Map<ItemStorage, Integer> alreadyKept, @NotNull Map<ItemStorage, Integer> shouldKeep, @NotNull ItemStack stack) {
        ItemStorage tempStorage;
        ArrayList<Map.Entry<ItemStorage, Integer>> tempKeep = new ArrayList<Map.Entry<ItemStorage, Integer>>(shouldKeep.entrySet());
        for (Map.Entry<ItemStorage, Integer> tempEntry : tempKeep) {
            ItemStorage tempStorage2 = tempEntry.getKey();
            if (tempStorage2 == null || tempStorage2.getItem() != stack.func_77973_b() || tempStorage2.getDamageValue() == stack.func_77952_i()) continue;
            shouldKeep.put(new ItemStorage(stack.func_77973_b(), stack.func_77952_i(), 0, tempStorage2.ignoreDamageValue()), tempEntry.getValue());
            break;
        }
        return shouldKeep.get(tempStorage = new ItemStorage(stack.func_77973_b(), stack.func_77952_i(), 0, false)) == null || alreadyKept.get(tempStorage) != null && alreadyKept.get(tempStorage) >= shouldKeep.get(tempStorage);
    }

    private static ItemStack handleKeepX(@NotNull Map<ItemStorage, Integer> alreadyKept, @NotNull Map<ItemStorage, Integer> shouldKeep, @NotNull ItemStorage tempStorage) {
        int amountKept = 0;
        if (alreadyKept.get(tempStorage) != null) {
            amountKept = alreadyKept.remove(tempStorage);
        }
        if (shouldKeep.get(tempStorage) >= tempStorage.getAmount() + amountKept) {
            alreadyKept.put(tempStorage, tempStorage.getAmount() + amountKept);
            return null;
        }
        alreadyKept.put(tempStorage, shouldKeep.get(tempStorage));
        int dump = tempStorage.getAmount() + amountKept - shouldKeep.get(tempStorage);
        return new ItemStack(tempStorage.getItem(), dump, tempStorage.getDamageValue());
    }

    protected boolean checkOrRequestItems(ItemStack ... items) {
        return this.checkOrRequestItems(true, items);
    }

    protected boolean checkOrRequestItems(boolean useItemDamage, ItemStack ... items) {
        if (items == null) {
            return false;
        }
        boolean allClear = true;
        for (ItemStack stack : items) {
            if (stack == null || stack.func_77973_b() == null) continue;
            int countOfItem = useItemDamage ? this.worker.getItemCountInInventory(stack.func_77973_b(), stack.func_77952_i()) : this.worker.getItemCountInInventory(stack.func_77973_b(), -1);
            if (countOfItem < 1) {
                int itemsLeft = stack.field_77994_a - countOfItem;
                ItemStack requiredStack = new ItemStack(stack.func_77973_b(), itemsLeft);
                this.getOwnBuilding().addNeededItems(requiredStack);
                allClear = false;
                continue;
            }
            this.getOwnBuilding().clearNeededItems();
        }
        if (allClear) {
            return false;
        }
        this.itemsNeeded.clear();
        Collections.addAll(this.itemsNeeded, items);
        return true;
    }

    @NotNull
    protected InventoryCitizen getInventory() {
        return this.worker.getInventoryCitizen();
    }

    protected final boolean holdEfficientTool(@NotNull Block target) {
        int bestSlot = this.getMostEfficientTool(target);
        if (bestSlot >= 0) {
            this.worker.setHeldItem(bestSlot);
            return true;
        }
        this.requestTool(target);
        return false;
    }

    private void requestTool(@NotNull Block target) {
        String tool = target.getHarvestTool(target.func_176223_P());
        int required = target.getHarvestLevel(target.func_176223_P());
        this.updateToolFlag(tool, required);
    }

    private void updateToolFlag(@NotNull String tool, int required) {
        switch (tool) {
            case "axe": {
                this.checkForAxe();
                break;
            }
            case "shovel": {
                this.checkForShovel();
                break;
            }
            case "hoe": {
                this.checkForHoe();
                break;
            }
            case "pickaxe": {
                this.checkForPickaxe(required);
                break;
            }
            default: {
                Log.getLogger().error("Invalid tool " + tool + " not implemented as tool!");
            }
        }
    }

    private int getMostEfficientTool(@NotNull Block target) {
        String tool = target.getHarvestTool(target.func_176223_P());
        int required = target.getHarvestLevel(target.func_176223_P());
        int bestSlot = -1;
        int bestLevel = Integer.MAX_VALUE;
        InventoryCitizen inventory = this.worker.getInventoryCitizen();
        int hutLevel = this.worker.getWorkBuilding().getBuildingLevel();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            int level = Utils.getMiningLevel(item, tool);
            if (level < required || level >= bestLevel || tool != null && !InventoryUtils.verifyToolLevel(item, level, hutLevel)) continue;
            bestSlot = i;
            bestLevel = level;
        }
        return bestSlot;
    }

    protected final boolean hasNotDelayed(int time) {
        if (!this.hasDelayed) {
            this.setDelay(time);
            this.hasDelayed = true;
            return true;
        }
        this.hasDelayed = false;
        return false;
    }

    protected final void incrementActionsDone() {
        ++this.actionsDone;
    }
}

