/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.farmer;

import com.minecolonies.coremod.entity.ai.citizen.farmer.Field;
import com.minecolonies.coremod.util.BlockPosUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldView {
    private BlockPos id;
    private boolean taken;
    private String owner;
    @Nullable
    private Item item;

    public FieldView() {
    }

    public FieldView(@NotNull Field field) {
        this.id = field.getID();
        this.taken = field.isTaken();
        this.owner = field.getOwner();
        this.item = field.getSeed() == null ? null : field.getSeed().func_77973_b();
    }

    public BlockPos getId() {
        return this.id;
    }

    public boolean isTaken() {
        return this.taken;
    }

    public void setTaken(boolean taken) {
        this.taken = taken;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void serializeViewNetworkData(@NotNull ByteBuf buf) {
        BlockPosUtil.writeToByteBuf(buf, this.id);
        buf.writeBoolean(this.taken);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.owner);
        int itemId = this.item == null ? 0 : Item.func_150891_b((Item)this.item);
        buf.writeInt(itemId);
    }

    @NotNull
    public FieldView deserialize(@NotNull ByteBuf buf) {
        this.id = BlockPosUtil.readFromByteBuf(buf);
        this.taken = buf.readBoolean();
        this.owner = ByteBufUtils.readUTF8String((ByteBuf)buf);
        int itemId = buf.readInt();
        this.item = itemId == 0 ? null : Item.func_150899_d((int)itemId);
        return this;
    }

    @Nullable
    public Item getItem() {
        return this.item;
    }
}

