/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.blockout.Log;
import com.minecolonies.coremod.util.ClientStructureWrapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.IOException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveScanMessage
implements IMessage,
IMessageHandler<SaveScanMessage, IMessage> {
    private NBTTagCompound nbttagcompound;
    private String storeLocation;

    public SaveScanMessage() {
    }

    public SaveScanMessage(NBTTagCompound nbttagcompound, String storeAt) {
        this.nbttagcompound = nbttagcompound;
        this.storeLocation = storeAt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromBytes(@NotNull ByteBuf buf) {
        long nbtSizeTrackerMax = 200097152L;
        PacketBuffer pb = new PacketBuffer(buf);
        ByteBufInputStream stream = new ByteBufInputStream((ByteBuf)pb);
        try {
            this.nbttagcompound = CompressedStreamTools.func_152456_a((DataInput)stream, (NBTSizeTracker)new NBTSizeTracker(200097152L));
        }
        catch (RuntimeException e) {
            Log.getLogger().info("Structure to big to be processed", (Throwable)e);
        }
        catch (IOException e) {
            Log.getLogger().info("Problem at retrieving structure on server.", (Throwable)e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                Log.getLogger().info("Problem at retrieving structure on server.", (Throwable)e);
            }
        }
        this.storeLocation = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbttagcompound);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.storeLocation);
    }

    @Nullable
    public IMessage onMessage(@NotNull SaveScanMessage message, MessageContext ctx) {
        ClientStructureWrapper.handleSaveScanMessage(message.nbttagcompound, message.storeLocation);
        return null;
    }
}

