/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.InventoryUtils;
import com.minecolonies.coremod.util.Log;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class TransferItemsRequestMessage
extends AbstractMessage<TransferItemsRequestMessage, IMessage> {
    private BlockPos buildingId;
    private int colonyId;
    private ItemStack itemStack;
    private int quantity;

    public TransferItemsRequestMessage() {
    }

    public TransferItemsRequestMessage(@NotNull AbstractBuilding.View building, ItemStack itemStack, int quantity) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.itemStack = itemStack;
        this.quantity = quantity;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.itemStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.quantity = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.itemStack);
        buf.writeInt(this.quantity);
    }

    @Override
    public void messageOnServerThread(TransferItemsRequestMessage message, EntityPlayerMP player) {
        ItemStack itemsTaken;
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony == null) {
            Log.getLogger().warn("TransferItemsRequestMessage colony is null");
            return;
        }
        AbstractBuilding building = colony.getBuilding(message.buildingId);
        if (building == null) {
            Log.getLogger().warn("TransferItemsRequestMessage building is null");
            return;
        }
        if (message.quantity <= 0) {
            Log.getLogger().warn("TransferItemsRequestMessage quantity below 0");
            return;
        }
        Item item = message.itemStack.func_77973_b();
        int amountToTake = Math.min(message.quantity, InventoryUtils.getItemCountInInventory((IInventory)player.field_71071_by, item, message.itemStack.func_77952_i()));
        ItemStack itemStackToTake = new ItemStack(item, amountToTake, message.itemStack.func_77952_i());
        ItemStack remainingItemStack = InventoryUtils.setOverSizedStack((IInventory)building.getTileEntity(), itemStackToTake);
        if (remainingItemStack.field_77994_a > 0) {
            World world = colony.getWorld();
            for (BlockPos pos : building.getAdditionalCountainers()) {
                TileEntity entity = world.func_175625_s(pos);
                if (!(entity instanceof TileEntityChest)) continue;
                remainingItemStack = InventoryUtils.setOverSizedStack((IInventory)((TileEntityChest)entity), remainingItemStack);
                if (remainingItemStack.field_77994_a != 0) continue;
                break;
            }
        }
        if (remainingItemStack.field_77994_a != itemStackToTake.field_77994_a) {
            building.getTileEntity().func_70296_d();
        }
        for (int amountToRemoveFromPlayer = amountToTake - remainingItemStack.field_77994_a; amountToRemoveFromPlayer > 0; amountToRemoveFromPlayer -= itemsTaken.field_77994_a) {
            int slot = InventoryUtils.findFirstSlotInInventoryWith((IInventory)player.field_71071_by, item, message.itemStack.func_77952_i());
            itemsTaken = player.field_71071_by.func_70298_a(slot, amountToRemoveFromPlayer);
        }
    }
}

