/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.network.messages.HireFireMessage;
import com.minecolonies.coremod.util.LanguageHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowHireWorker
extends Window
implements Button.Handler {
    private static final String BUTTON_DONE = "done";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String CITIZEN_LABEL = "citizen";
    private static final String ID_LABEL = "id";
    private static final String CITIZEN_LIST = "unemployed";
    private static final String ATTRIBUTES_LABEL = "attributes";
    private static final String BUILDING_NAME_RESOURCE_SUFFIX = ":gui/windowHireWorker.xml";
    private static final int CITIZEN_ID_LABEL_POSITION = 3;
    private static final String GREEN_STRING = "\u00a72";
    private static final String YELLOW_STRING = "\u00a7e";
    private List<CitizenDataView> citizens = new ArrayList<CitizenDataView>();
    private final AbstractBuilding.View building;
    private final ColonyView colony;

    public WindowHireWorker(ColonyView c, BlockPos buildingId) {
        super("minecolonies:gui/windowHireWorker.xml");
        this.colony = c;
        this.building = this.colony.getBuilding(buildingId);
        this.updateCitizens();
    }

    private void updateCitizens() {
        this.citizens.clear();
        this.citizens.addAll(this.colony.getCitizens().values());
        this.citizens = this.colony.getCitizens().values().stream().filter(citizen -> citizen.getWorkBuilding() == null).collect(Collectors.toList());
    }

    @Override
    public void onOpened() {
        this.updateCitizens();
        ScrollingList citizenList = this.findPaneOfTypeByID(CITIZEN_LIST, ScrollingList.class);
        citizenList.enable();
        citizenList.show();
        citizenList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowHireWorker.this.citizens.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                CitizenDataView citizen = (CitizenDataView)WindowHireWorker.this.citizens.get(index);
                if (WindowHireWorker.this.building instanceof AbstractBuildingWorker.View) {
                    AbstractBuildingWorker.Skill primary = ((AbstractBuildingWorker.View)WindowHireWorker.this.building).getPrimarySkill();
                    AbstractBuildingWorker.Skill secondary = ((AbstractBuildingWorker.View)WindowHireWorker.this.building).getSecondarySkill();
                    String strength = (primary.equals((Object)AbstractBuildingWorker.Skill.STRENGTH) ? WindowHireWorker.GREEN_STRING : (secondary.equals((Object)AbstractBuildingWorker.Skill.STRENGTH) ? WindowHireWorker.YELLOW_STRING : "")) + LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.strength", citizen.getStrength()) + " \u00a7f ";
                    String charisma = (primary.equals((Object)AbstractBuildingWorker.Skill.CHARISMA) ? WindowHireWorker.GREEN_STRING : (secondary.equals((Object)AbstractBuildingWorker.Skill.CHARISMA) ? WindowHireWorker.YELLOW_STRING : "")) + LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.charisma", citizen.getCharisma()) + " \u00a7f ";
                    String dexterity = (primary.equals((Object)AbstractBuildingWorker.Skill.DEXTERITY) ? WindowHireWorker.GREEN_STRING : (secondary.equals((Object)AbstractBuildingWorker.Skill.DEXTERITY) ? WindowHireWorker.YELLOW_STRING : "")) + LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.dexterity", citizen.getDexterity()) + " \u00a7f ";
                    String endurance = (primary.equals((Object)AbstractBuildingWorker.Skill.ENDURANCE) ? WindowHireWorker.GREEN_STRING : (secondary.equals((Object)AbstractBuildingWorker.Skill.ENDURANCE) ? WindowHireWorker.YELLOW_STRING : "")) + LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.endurance", citizen.getEndurance()) + " \u00a7f ";
                    String intelligence = (primary.equals((Object)AbstractBuildingWorker.Skill.INTELLIGENCE) ? WindowHireWorker.GREEN_STRING : (secondary.equals((Object)AbstractBuildingWorker.Skill.INTELLIGENCE) ? WindowHireWorker.YELLOW_STRING : "")) + LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.intelligence", citizen.getStrength()) + " \u00a7f ";
                    String attributes = strength + charisma + dexterity + endurance + intelligence;
                    rowPane.findPaneOfTypeByID(WindowHireWorker.CITIZEN_LABEL, Label.class).setLabelText(citizen.getName());
                    rowPane.findPaneOfTypeByID(WindowHireWorker.ATTRIBUTES_LABEL, Label.class).setLabelText(attributes);
                    rowPane.findPaneOfTypeByID(WindowHireWorker.ID_LABEL, Label.class).setLabelText(Integer.toString(citizen.getID()));
                }
            }
        });
    }

    @Override
    public void onUpdate() {
        this.updateCitizens();
        this.window.findPaneOfTypeByID(CITIZEN_LIST, ScrollingList.class).refreshElementPanes();
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        if (button.getID().equals(BUTTON_DONE)) {
            Label idLabel = (Label)button.getParent().getChildren().get(3);
            int id = Integer.parseInt(idLabel.getLabelText());
            if (this.building instanceof AbstractBuildingWorker.View) {
                ((AbstractBuildingWorker.View)this.building).setWorkerId(id);
            }
            MineColonies.getNetwork().sendToServer((IMessage)new HireFireMessage(this.building, true, id));
        } else if (!button.getID().equals(BUTTON_CANCEL)) {
            return;
        }
        if (this.colony.getTownHall() != null) {
            this.building.openGui();
        }
    }
}

