/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.client.gui.WindowHutWorkerPlaceholder;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobLumberjack;
import com.minecolonies.coremod.entity.ai.item.handling.ItemStorage;
import com.minecolonies.coremod.util.Utils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingLumberjack
extends AbstractBuildingWorker {
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String LUMBERJACK = "Lumberjack";
    private static final String LUMBERJACK_HUT_NAME = "lumberjackHut";
    private static final int SAPLINGS_TO_KEEP = 32;
    private final Map<ItemStorage, Integer> keepX = new HashMap<ItemStorage, Integer>();

    public BuildingLumberjack(Colony c, BlockPos l) {
        super(c, l);
        ItemStack stack = new ItemStack(Blocks.field_150345_g);
        this.keepX.put(new ItemStorage(stack.func_77973_b(), stack.func_77952_i(), 0, false), 32);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return LUMBERJACK;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().triggerAchievement(ModAchievements.achievementBuildingLumberjack);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().triggerAchievement(ModAchievements.achievementUpgradeLumberjackMax);
        }
    }

    @Override
    public boolean neededForWorker(@Nullable ItemStack stack) {
        return Utils.isStackAxe(stack);
    }

    @Override
    public Map<ItemStorage, Integer> getRequiredItemsAndAmount() {
        return this.keepX;
    }

    @Override
    @NotNull
    public String getJobName() {
        return LUMBERJACK;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobLumberjack(citizen);
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerPlaceholder<View>(this, BuildingLumberjack.LUMBERJACK_HUT_NAME);
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.STRENGTH;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.CHARISMA;
        }
    }
}

