/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.BuildingGuardTower;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.ai.citizen.guard.EntityAIMeleeGuard;
import com.minecolonies.coremod.entity.ai.citizen.guard.EntityAIRangeGuard;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public class JobGuard
extends AbstractJob {
    private static final int GUARD_CHANCE = 3;

    public JobGuard(CitizenData entity) {
        super(entity);
    }

    @Override
    @NotNull
    public String getName() {
        return "com.minecolonies.coremod.job.Guard";
    }

    @Override
    @NotNull
    public RenderBipedCitizen.Model getModel() {
        AbstractBuildingWorker building = this.getCitizen().getWorkBuilding();
        if (building instanceof BuildingGuardTower) {
            BuildingGuardTower.GuardJob job = ((BuildingGuardTower)building).getJob();
            if (job == null) {
                job = JobGuard.generateRandomAI((BuildingGuardTower)building);
            }
            if (job == BuildingGuardTower.GuardJob.KNIGHT) {
                return RenderBipedCitizen.Model.KNIGHT_GUARD;
            }
            return RenderBipedCitizen.Model.ARCHER_GUARD;
        }
        return RenderBipedCitizen.Model.ARCHER_GUARD;
    }

    @NotNull
    private static BuildingGuardTower.GuardJob generateRandomAI(@NotNull BuildingGuardTower building) {
        int chance = new Random().nextInt(3);
        if (chance == 1) {
            building.setJob(BuildingGuardTower.GuardJob.KNIGHT);
            return BuildingGuardTower.GuardJob.KNIGHT;
        }
        building.setJob(BuildingGuardTower.GuardJob.RANGER);
        return BuildingGuardTower.GuardJob.RANGER;
    }

    @Override
    @NotNull
    public AbstractAISkeleton<? extends AbstractJob> generateAI() {
        AbstractBuildingWorker building = this.getCitizen().getWorkBuilding();
        if (building instanceof BuildingGuardTower) {
            BuildingGuardTower.GuardJob job = ((BuildingGuardTower)building).getJob();
            if (job == BuildingGuardTower.GuardJob.KNIGHT) {
                return new EntityAIMeleeGuard(this);
            }
            return new EntityAIRangeGuard(this);
        }
        return new EntityAIRangeGuard(this);
    }
}

