/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.IColony;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public class AddOfficerCommand
extends AbstractSingleCommand {
    public static final String DESC = "addOfficer";
    private static final String SUCCESS_MESSAGE = "Succesfully added Player %s to colony %d";
    private static final String COLONY_NULL = "Couldn't find colony %d.";
    private static final String NO_ARGUMENTS = "Please define a colony or player";
    private static final String NO_PLAYER = "Can't find player to add";

    public AddOfficerCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId> <(Optional)Player>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        EntityPlayer player;
        IColony colony;
        if (args.length == 0) {
            sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString(NO_ARGUMENTS));
            return;
        }
        int colonyId = AddOfficerCommand.getIthArgument(args, 0, -1);
        if (colonyId == -1 && sender instanceof EntityPlayer) {
            colony = ColonyManager.getIColonyByOwner(sender.func_130014_f_(), ((EntityPlayer)sender).func_110124_au());
            if (colony == null) {
                sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString(COLONY_NULL));
                return;
            }
            colonyId = colony.getID();
        }
        if ((colony = ColonyManager.getColony(colonyId)) == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format(COLONY_NULL, colonyId, colonyId)));
            return;
        }
        if (sender instanceof EntityPlayer && !this.canPlayerUseCommand(player = (EntityPlayer)sender, AbstractSingleCommand.Commands.ADDOFFICER, colonyId)) {
            sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString("You are not allowed to do that!"));
            return;
        }
        String playerName = null;
        if (args.length >= 2) {
            playerName = args[1];
        }
        if (playerName == null || playerName.isEmpty()) {
            playerName = sender.func_70005_c_();
        }
        if (playerName == null) {
            sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString(NO_PLAYER));
            return;
        }
        ((Colony)colony).getPermissions().addPlayer(playerName, Permissions.Rank.OFFICER, ((Colony)colony).getWorld());
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format(SUCCESS_MESSAGE, playerName, colonyId)));
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return false;
    }
}

