/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.google.common.collect.ImmutableMap;
import com.minecolonies.coremod.commands.AbstractSplitCommand;
import com.minecolonies.coremod.commands.CitizensCommand;
import com.minecolonies.coremod.commands.ColoniesCommand;
import com.minecolonies.coremod.commands.ColonyCommand;
import com.minecolonies.coremod.commands.ISubCommand;
import com.minecolonies.coremod.commands.RandomTeleportCommand;
import com.minecolonies.coremod.configuration.Configurations;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import org.jetbrains.annotations.NotNull;

public class MinecoloniesCommand
extends AbstractSplitCommand {
    public static final String DESC = "minecolonies";
    private static final Map<UUID, Instant> commandExecutions = new HashMap<UUID, Instant>();
    private final ImmutableMap<String, ISubCommand> subCommands = new ImmutableMap.Builder().put((Object)"colonies", (Object)new ColoniesCommand("minecolonies")).put((Object)"colony", (Object)new ColonyCommand("minecolonies")).put((Object)"citizens", (Object)new CitizensCommand("minecolonies")).put((Object)"rtp", (Object)new RandomTeleportCommand("minecolonies")).build();

    public MinecoloniesCommand() {
        super(DESC);
    }

    @Override
    public Map<String, ISubCommand> getSubCommands() {
        return this.subCommands;
    }

    public static boolean canExecuteCommand(@NotNull EntityPlayer player) {
        boolean canTeleport;
        if (Configurations.teleportBuffer == 0) {
            return true;
        }
        MinecoloniesCommand.cleanUpList();
        boolean bl = canTeleport = !commandExecutions.containsKey(player.func_110124_au());
        if (canTeleport) {
            commandExecutions.put(player.func_110124_au(), Instant.now());
        }
        return canTeleport;
    }

    private static void cleanUpList() {
        HashMap<UUID, Instant> mapCopy = new HashMap<UUID, Instant>(commandExecutions);
        for (Map.Entry entry : mapCopy.entrySet()) {
            if (!Instant.now().isAfter((Instant)entry.getValue()) || Instant.now().getEpochSecond() - ((Instant)entry.getValue()).getEpochSecond() <= (long)Configurations.teleportBuffer) continue;
            commandExecutions.remove(entry.getKey());
        }
    }
}

