/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.miner;

import com.minecolonies.coremod.colony.buildings.BuildingMiner;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructure;
import com.minecolonies.coremod.entity.ai.citizen.miner.Level;
import com.minecolonies.coremod.entity.ai.citizen.miner.Node;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.util.Log;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockOre;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIStructureMiner
extends AbstractEntityAIStructure<JobMiner> {
    private static final String RENDER_META_TORCH = "Torch";
    private static final int NODE_DISTANCE = 7;
    private static final int MAX_BLOCKS_MINED = 192;
    private static final int LADDER_SEARCH_RANGE = 10;
    private static final int SHAFT_RADIUS = 3;
    private static final int SAFE_CHECK_RANGE = 5;
    private static final int ROTATE_ONCE = 1;
    private static final int ROTATE_TWICE = 2;
    private static final int ROTATE_THREE_TIMES = 3;
    private static final int ROTATE_FOUR_TIMES = 4;
    private static final int LIQUID_CHECK_RANGE = 5;
    @Nullable
    private BlockPos minerWorkingLocation;
    @Nullable
    private BlockPos currentStandingPosition;
    @Nullable
    private Node workingNode = null;

    public EntityAIStructureMiner(@NotNull JobMiner job) {
        super(job);
        super.registerTargets(new AITarget(AIState.IDLE, AIState.START_WORKING), new AITarget(AIState.START_WORKING, this::startWorkingAtOwnBuilding), new AITarget(AIState.PREPARING, this::prepareForMining), new AITarget(AIState.MINER_SEARCHING_LADDER, this::lookForLadder), new AITarget(AIState.MINER_WALKING_TO_LADDER, this::goToLadder), new AITarget(AIState.MINER_CHECK_MINESHAFT, this::checkMineShaft), new AITarget(AIState.MINER_MINING_SHAFT, this::doShaftMining), new AITarget(AIState.MINER_BUILDING_SHAFT, this::doShaftBuilding), new AITarget(AIState.MINER_MINING_NODE, this::executeNodeMining));
        this.worker.setSkillModifier(2 * this.worker.getCitizenData().getStrength() + this.worker.getCitizenData().getEndurance());
        this.worker.func_98053_h(true);
    }

    @Override
    public IBlockState getSolidSubstitution(BlockPos ignored) {
        return Blocks.field_150347_e.func_176223_P();
    }

    private static boolean isOre(Block block) {
        return block instanceof BlockOre;
    }

    @NotNull
    private AIState startWorkingAtOwnBuilding() {
        if (this.worker.field_70163_u >= (double)this.getOwnBuilding().getLocation().func_177956_o() && this.walkToBuilding()) {
            return AIState.START_WORKING;
        }
        return AIState.PREPARING;
    }

    @NotNull
    private AIState prepareForMining() {
        if (this.getOwnBuilding() != null && !this.getOwnBuilding().hasFoundLadder()) {
            return AIState.MINER_SEARCHING_LADDER;
        }
        return AIState.MINER_CHECK_MINESHAFT;
    }

    @NotNull
    private AIState goToLadder() {
        if (this.walkToLadder()) {
            return AIState.MINER_WALKING_TO_LADDER;
        }
        return AIState.MINER_CHECK_MINESHAFT;
    }

    private boolean walkToLadder() {
        return this.walkToBlock(this.getOwnBuilding().getLadderLocation());
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 192;
    }

    @Override
    protected BuildingMiner getOwnBuilding() {
        return (BuildingMiner)this.worker.getWorkBuilding();
    }

    @Override
    protected void updateRenderMetaData() {
        String renderMetaData = this.getRenderMetaTorch();
        this.worker.setRenderMetadata(renderMetaData);
    }

    @NotNull
    private String getRenderMetaTorch() {
        if (this.worker.hasItemInInventory(Blocks.field_150478_aa, -1)) {
            return RENDER_META_TORCH;
        }
        return "";
    }

    @NotNull
    private AIState checkMineShaft() {
        if (this.getLastLadder(this.getOwnBuilding().getLadderLocation()) < this.getOwnBuilding().getDepthLimit()) {
            if (this.getOwnBuilding().getNumberOfLevels() == 0) {
                this.chatSpamFilter.talkWithoutSpam("entity.miner.messageRequiresBetterHut", new Object[0]);
                this.getOwnBuilding().clearedShaft = false;
                return AIState.IDLE;
            }
            this.getOwnBuilding().clearedShaft = true;
            return AIState.MINER_MINING_NODE;
        }
        this.getOwnBuilding().clearedShaft = false;
        return AIState.MINER_MINING_SHAFT;
    }

    @NotNull
    private AIState lookForLadder() {
        BuildingMiner buildingMiner = this.getOwnBuilding();
        if (buildingMiner.hasFoundLadder() && buildingMiner.getLadderLocation() != null) {
            if (this.world.func_180495_p(buildingMiner.getLadderLocation()).func_177230_c() == Blocks.field_150468_ap) {
                return AIState.MINER_WALKING_TO_LADDER;
            }
            buildingMiner.setFoundLadder(false);
            buildingMiner.setLadderLocation(null);
        }
        int posX = buildingMiner.getLocation().func_177958_n();
        int posY = buildingMiner.getLocation().func_177956_o() + 2;
        int posZ = buildingMiner.getLocation().func_177952_p();
        for (int y = posY - 10; y < posY; ++y) {
            for (int x = posX - 10; x < posX + 10; ++x) {
                for (int z = posZ - 10; z < posZ + 10; ++z) {
                    this.tryFindLadderAt(new BlockPos(x, y, z));
                }
            }
        }
        return AIState.MINER_SEARCHING_LADDER;
    }

    private void tryFindLadderAt(@NotNull BlockPos pos) {
        BuildingMiner buildingMiner = this.getOwnBuilding();
        if (buildingMiner.hasFoundLadder()) {
            return;
        }
        if (this.world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150468_ap)) {
            int firstLadderY = this.getFirstLadder(pos);
            buildingMiner.setLadderLocation(new BlockPos(pos.func_177958_n(), firstLadderY, pos.func_177952_p()));
            this.validateLadderOrientation();
        }
    }

    private void validateLadderOrientation() {
        BuildingMiner buildingMiner = this.getOwnBuilding();
        EnumFacing ladderOrientation = (EnumFacing)this.world.func_180495_p(buildingMiner.getLadderLocation()).func_177229_b((IProperty)BlockLadder.field_176382_a);
        if (ladderOrientation == EnumFacing.WEST) {
            buildingMiner.setVectorX(-1);
            buildingMiner.setVectorZ(0);
        } else if (ladderOrientation == EnumFacing.EAST) {
            buildingMiner.setVectorX(1);
            buildingMiner.setVectorZ(0);
        } else if (ladderOrientation == EnumFacing.SOUTH) {
            buildingMiner.setVectorX(0);
            buildingMiner.setVectorZ(1);
        } else if (ladderOrientation == EnumFacing.NORTH) {
            buildingMiner.setVectorX(0);
            buildingMiner.setVectorZ(-1);
        } else {
            throw new IllegalStateException("Ladder metadata was " + ladderOrientation);
        }
        int x = buildingMiner.getLadderLocation().func_177958_n();
        int y = buildingMiner.getLadderLocation().func_177956_o();
        int z = buildingMiner.getLadderLocation().func_177952_p();
        buildingMiner.setCobbleLocation(new BlockPos(x - buildingMiner.getVectorX(), y, z - buildingMiner.getVectorZ()));
        buildingMiner.setShaftStart(new BlockPos(x, this.getLastLadder(buildingMiner.getLadderLocation()) - 1, z));
        buildingMiner.setFoundLadder(true);
    }

    private AIState doShaftMining() {
        this.minerWorkingLocation = this.getNextBlockInShaftToMine();
        if (this.minerWorkingLocation == null) {
            return this.advanceLadder(AIState.MINER_MINING_SHAFT);
        }
        this.mineBlock(this.minerWorkingLocation, this.currentStandingPosition);
        return AIState.MINER_MINING_SHAFT;
    }

    private AIState advanceLadder(AIState state) {
        if (this.getOwnBuilding().getStartingLevelShaft() >= 4) {
            return AIState.MINER_BUILDING_SHAFT;
        }
        if (this.checkOrRequestItems(new ItemStack(Blocks.field_150347_e, 2), new ItemStack(Blocks.field_150468_ap))) {
            return state;
        }
        BlockPos safeCobble = new BlockPos(this.getOwnBuilding().getLadderLocation().func_177958_n(), this.getLastLadder(this.getOwnBuilding().getLadderLocation()) - 2, this.getOwnBuilding().getLadderLocation().func_177952_p());
        int xOffset = 3 * this.getOwnBuilding().getVectorX();
        int zOffset = 3 * this.getOwnBuilding().getVectorZ();
        for (int x = -5 + xOffset; x <= 5 + xOffset; ++x) {
            for (int z = -5 + zOffset; z <= 5 + zOffset; ++z) {
                BlockPos curBlock = new BlockPos(safeCobble.func_177958_n() + x, safeCobble.func_177956_o(), safeCobble.func_177952_p() + z);
                if (this.secureBlock(curBlock, this.currentStandingPosition)) continue;
                return state;
            }
        }
        BlockPos safeStand = new BlockPos(this.getOwnBuilding().getLadderLocation().func_177958_n(), this.getLastLadder(this.getOwnBuilding().getLadderLocation()), this.getOwnBuilding().getLadderLocation().func_177952_p());
        BlockPos nextLadder = new BlockPos(this.getOwnBuilding().getLadderLocation().func_177958_n(), this.getLastLadder(this.getOwnBuilding().getLadderLocation()) - 1, this.getOwnBuilding().getLadderLocation().func_177952_p());
        BlockPos nextCobble = new BlockPos(this.getOwnBuilding().getCobbleLocation().func_177958_n(), this.getLastLadder(this.getOwnBuilding().getLadderLocation()) - 1, this.getOwnBuilding().getCobbleLocation().func_177952_p());
        if (!this.mineBlock(nextCobble, safeStand) || !this.mineBlock(nextLadder, safeStand)) {
            return state;
        }
        IBlockState metadata = this.getBlockState(safeStand);
        this.setBlockFromInventory(nextCobble, Blocks.field_150347_e);
        this.setBlockFromInventory(nextLadder, Blocks.field_150468_ap, metadata);
        this.getOwnBuilding().incrementStartingLevelShaft();
        return AIState.MINER_CHECK_MINESHAFT;
    }

    private IBlockState getBlockState(@NotNull BlockPos pos) {
        return this.world.func_180495_p(pos);
    }

    @Nullable
    private BlockPos getNextBlockInShaftToMine() {
        double distance;
        BlockPos curBlock;
        int z;
        int x;
        Block block;
        BlockPos ladderPos = this.getOwnBuilding().getLadderLocation();
        int lastLadder = this.getLastLadder(ladderPos);
        if (this.minerWorkingLocation == null) {
            this.minerWorkingLocation = new BlockPos(ladderPos.func_177958_n(), lastLadder + 1, ladderPos.func_177952_p());
        }
        if ((block = this.getBlock(this.minerWorkingLocation)) != null && block != Blocks.field_150350_a && block != Blocks.field_150468_ap && !block.equals(Blocks.field_150358_i) && !block.equals(Blocks.field_150356_k)) {
            return this.minerWorkingLocation;
        }
        this.currentStandingPosition = this.minerWorkingLocation;
        BlockPos nextBlockToMine = null;
        double bestDistance = Double.MAX_VALUE;
        int xOffset = 3 * this.getOwnBuilding().getVectorX();
        int zOffset = 3 * this.getOwnBuilding().getVectorZ();
        for (x = 3 + xOffset + 2; x >= -3 + xOffset - 2; --x) {
            for (z = -3 + zOffset - 2; z <= 3 + zOffset + 2; ++z) {
                if (x == 0 && 0 == z || !(block = this.getBlock(curBlock = new BlockPos(ladderPos.func_177958_n() + x, lastLadder, ladderPos.func_177952_p() + z))).equals(Blocks.field_150355_j) && !block.equals(Blocks.field_150353_l) && !block.equals(Blocks.field_150358_i) && !block.equals(Blocks.field_150356_k)) continue;
                this.setBlockFromInventory(curBlock, Blocks.field_150347_e);
            }
        }
        for (x = 3 + xOffset; x >= -3 + xOffset; --x) {
            for (z = -3 + zOffset; z <= 3 + zOffset; ++z) {
                if (x == 0 && 0 == z) continue;
                curBlock = new BlockPos(ladderPos.func_177958_n() + x, lastLadder, ladderPos.func_177952_p() + z);
                distance = curBlock.func_177951_i((Vec3i)ladderPos) + Math.pow(curBlock.func_177951_i((Vec3i)this.minerWorkingLocation), 2.0);
                block = this.getBlock(curBlock);
                if (!(distance < bestDistance) || this.world.func_175623_d(curBlock)) continue;
                if (block.equals(Blocks.field_150355_j) || block.equals(Blocks.field_150353_l) || block.equals(Blocks.field_150358_i) || block.equals(Blocks.field_150356_k)) {
                    this.setBlockFromInventory(curBlock, Blocks.field_150347_e);
                }
                nextBlockToMine = curBlock;
                bestDistance = distance;
            }
        }
        bestDistance = Double.MAX_VALUE;
        if (nextBlockToMine != null) {
            for (x = 1; x >= -1; --x) {
                for (z = -1; z <= 1; ++z) {
                    if (x == 0 && 0 == z || !((distance = (curBlock = new BlockPos(nextBlockToMine.func_177958_n() + x, lastLadder, nextBlockToMine.func_177952_p() + z)).func_177951_i((Vec3i)ladderPos)) < bestDistance) || !this.world.func_175623_d(curBlock)) continue;
                    this.currentStandingPosition = curBlock;
                    bestDistance = distance;
                }
            }
        }
        return nextBlockToMine;
    }

    @NotNull
    private AIState doShaftBuilding() {
        if (this.walkToBuilding()) {
            return AIState.MINER_BUILDING_SHAFT;
        }
        BlockPos ladderPos = this.getOwnBuilding().getLadderLocation();
        int lastLadder = this.getLastLadder(ladderPos) + 1;
        int xOffset = 3 * this.getOwnBuilding().getVectorX();
        int zOffset = 3 * this.getOwnBuilding().getVectorZ();
        this.initStructure(null, 0, new BlockPos(ladderPos.func_177958_n() + xOffset, lastLadder, ladderPos.func_177952_p() + zOffset));
        return AIState.CLEAR_STEP;
    }

    @Override
    protected boolean checkIfCanceled() {
        if (!this.isThereAStructureToBuild()) {
            switch (this.getState()) {
                case CLEAR_STEP: 
                case BUILDING_STEP: 
                case DECORATION_STEP: 
                case SPAWN_STEP: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    protected void onStartWithoutStructure() {
    }

    @NotNull
    private AIState executeNodeMining() {
        Level currentLevel = this.getOwnBuilding().getCurrentLevel();
        if (currentLevel == null) {
            Log.getLogger().warn("Current Level not set, resetting...");
            this.getOwnBuilding().setCurrentLevel(this.getOwnBuilding().getNumberOfLevels() - 1);
            return this.executeNodeMining();
        }
        return this.searchANodeToMine(currentLevel);
    }

    private AIState searchANodeToMine(@NotNull Level currentLevel) {
        BlockPos standingPosition;
        int vectorZ;
        int vectorX;
        if (this.workingNode == null || this.workingNode.getStatus() == Node.NodeStatus.COMPLETED) {
            this.workingNode = currentLevel.getRandomNode();
            return AIState.MINER_CHECK_MINESHAFT;
        }
        int rotation = 0;
        int n = this.workingNode.getX() < this.workingNode.getParent().getX() ? -1 : (vectorX = this.workingNode.getX() > this.workingNode.getParent().getX() ? 1 : 0);
        int n2 = this.workingNode.getZ() < this.workingNode.getParent().getY() ? -1 : (vectorZ = this.workingNode.getZ() > this.workingNode.getParent().getY() ? 1 : 0);
        if (vectorX == -1) {
            rotation = 2;
        } else if (vectorZ == -1) {
            rotation = 3;
        } else if (vectorZ == 1) {
            rotation = 1;
        }
        this.currentStandingPosition = standingPosition = new BlockPos(this.workingNode.getParent().getX(), (double)currentLevel.getDepth(), this.workingNode.getParent().getY());
        if (!(this.workingNode.getStatus() != Node.NodeStatus.AVAILABLE && this.workingNode.getStatus() != Node.NodeStatus.IN_PROGRESS || this.walkToBlock(standingPosition))) {
            return this.executeStructurePlacement(this.workingNode, standingPosition, rotation);
        }
        return AIState.MINER_CHECK_MINESHAFT;
    }

    private boolean secureBlock(@NotNull BlockPos curBlock, @NotNull BlockPos safeStand) {
        if (!this.getBlockState(curBlock).func_185904_a().func_76230_c() && this.getBlock(curBlock) != Blocks.field_150478_aa || EntityAIStructureMiner.isOre(this.getBlock(curBlock))) {
            if (!this.mineBlock(curBlock, safeStand)) {
                this.setDelay(1);
                return false;
            }
            if (this.checkOrRequestItems(new ItemStack(Blocks.field_150347_e))) {
                return false;
            }
            this.setBlockFromInventory(curBlock, Blocks.field_150347_e);
            return false;
        }
        return true;
    }

    private void initStructure(Node mineNode, int rotateTimes, BlockPos structurePos) {
        if (mineNode == null) {
            this.loadStructure("miner/minerMainShaft", this.getRotationFromVector(), structurePos);
        } else {
            if (mineNode.getStyle() == Node.NodeType.CROSSROAD) {
                this.loadStructure("miner/minerX4", rotateTimes, structurePos);
            }
            if (mineNode.getStyle() == Node.NodeType.BEND) {
                this.loadStructure("miner/minerX2Right", rotateTimes, structurePos);
            }
            if (mineNode.getStyle() == Node.NodeType.TUNNEL) {
                this.loadStructure("miner/minerX2Top", rotateTimes, structurePos);
            }
        }
    }

    private int getRotationFromVector() {
        if (this.getOwnBuilding().getVectorX() == 1) {
            return 1;
        }
        if (this.getOwnBuilding().getVectorZ() == 1) {
            return 2;
        }
        if (this.getOwnBuilding().getVectorX() == -1) {
            return 3;
        }
        if (this.getOwnBuilding().getVectorZ() == -1) {
            return 4;
        }
        return 0;
    }

    private AIState executeStructurePlacement(@NotNull Node mineNode, @NotNull BlockPos standingPosition, int rotation) {
        mineNode.setStatus(Node.NodeStatus.IN_PROGRESS);
        if (((JobMiner)this.job).getStructure() == null) {
            this.initStructure(mineNode, rotation, new BlockPos(mineNode.getX(), (double)this.getOwnBuilding().getCurrentLevel().getDepth(), mineNode.getZ()));
        }
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                for (int y = -1; y <= 5; ++y) {
                    BlockPos curBlock = new BlockPos(mineNode.getX() + (double)x, (double)(standingPosition.func_177956_o() + y), mineNode.getZ() + (double)z);
                    Block block = this.getBlock(curBlock);
                    if (!block.equals(Blocks.field_150355_j) && !block.equals(Blocks.field_150353_l) && !block.equals(Blocks.field_150358_i) && !block.equals(Blocks.field_150356_k)) continue;
                    this.setBlockFromInventory(curBlock, Blocks.field_150347_e);
                }
            }
        }
        this.workingNode = null;
        if (((JobMiner)this.job).getStructure() != null) {
            return AIState.CLEAR_STEP;
        }
        return AIState.MINER_MINING_NODE;
    }

    private void setBlockFromInventory(@NotNull BlockPos location, @NotNull Block block) {
        this.worker.func_184609_a(this.worker.func_184600_cs());
        this.setBlockFromInventory(location, block, block.func_176223_P());
    }

    private void setBlockFromInventory(@NotNull BlockPos location, Block block, IBlockState metadata) {
        int slot = block instanceof BlockLadder ? this.worker.findFirstSlotInInventoryWith(block, -1) : this.worker.findFirstSlotInInventoryWith(block, block.func_176201_c(metadata));
        if (slot != -1) {
            this.getInventory().func_70298_a(slot, 1);
            this.world.func_180501_a(location, metadata, 3);
        }
    }

    private Block getBlock(@NotNull BlockPos loc) {
        return this.world.func_180495_p(loc).func_177230_c();
    }

    private int getLastLadder(@NotNull BlockPos pos) {
        if (this.world.func_180495_p(pos).func_177230_c().isLadder(this.world.func_180495_p(pos), (IBlockAccess)this.world, pos, null)) {
            return this.getLastLadder(pos.func_177977_b());
        }
        return pos.func_177956_o() + 1;
    }

    private int getFirstLadder(@NotNull BlockPos pos) {
        if (this.world.func_180495_p(pos).func_177230_c().isLadder(this.world.func_180495_p(pos), (IBlockAccess)this.world, pos, null)) {
            return this.getFirstLadder(pos.func_177984_a());
        }
        return pos.func_177956_o() - 1;
    }
}

