/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.BuildingTownHall;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.util.LanguageHandler;
import com.minecolonies.coremod.util.TeleportHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class RecallTownhallMessage
extends AbstractMessage<RecallTownhallMessage, IMessage> {
    private int colonyId;

    public RecallTownhallMessage() {
    }

    public RecallTownhallMessage(@NotNull BuildingTownHall.View townhall) {
        this.colonyId = townhall.getColony().getID();
    }

    public void fromBytes(ByteBuf buf) {
        this.colonyId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.colonyId);
    }

    @Override
    public void messageOnServerThread(RecallTownhallMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Permissions.Action.MANAGE_HUTS)) {
                return;
            }
            BuildingTownHall building = colony.getTownHall();
            if (building != null) {
                BlockPos location = building.getLocation();
                World world = colony.getWorld();
                for (CitizenData citizenData : colony.getCitizens().values()) {
                    if (TeleportHelper.teleportCitizen(citizenData.getCitizenEntity(), world, location)) continue;
                    LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.workerHuts.recallFail", new Object[0]);
                }
            }
        }
    }
}

