/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.controls.TextField;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.SwitchView;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowBuilding;
import com.minecolonies.coremod.client.gui.WindowTownHallNameEntry;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.WorkOrderView;
import com.minecolonies.coremod.colony.buildings.BuildingTownHall;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.network.messages.PermissionsMessage;
import com.minecolonies.coremod.network.messages.RecallTownhallMessage;
import com.minecolonies.coremod.network.messages.ToggleJobMessage;
import com.minecolonies.coremod.network.messages.WorkOrderChangeMessage;
import com.minecolonies.coremod.util.LanguageHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowTownHall
extends AbstractWindowBuilding<BuildingTownHall.View> {
    private static final String BUTTON_INFO = "info";
    private static final String BUTTON_ACTIONS = "actions";
    private static final String BUTTON_SETTINGS = "settings";
    private static final String BUTTON_PERMISSIONS = "permissions";
    private static final String BUTTON_CITIZENS = "citizens";
    private static final String BUTTON_WORKORDER = "workOrder";
    private static final String BUTTON_RECALL = "recall";
    private static final String BUTTON_CHANGE_SPEC = "changeSpec";
    private static final String BUTTON_RENAME = "rename";
    private static final String BUTTON_ADD_PLAYER = "addPlayer";
    private static final String BUTTON_TOGGLE_JOB = "toggleJob";
    private static final String BUTTON_REMOVE_PLAYER = "removePlayer";
    private static final String BUTTON_PROMOTE = "promote";
    private static final String BUTTON_DEMOTE = "demote";
    private static final String BUTTON_UP = "up";
    private static final String BUTTON_DOWN = "down";
    private static final String BUTTON_DELETE = "delete";
    private static final String INPUT_ADDPLAYER_NAME = "addPlayerName";
    private static final String VIEW_PAGES = "pages";
    private static final String PAGE_INFO = "pageInfo";
    private static final String PAGE_ACTIONS = "pageActions";
    private static final String PAGE_SETTINGS = "pageSettings";
    private static final String PAGE_PERMISSIONS = "pagePermissions";
    private static final String PAGE_CITIZENS = "pageCitizens";
    private static final String PAGE_WORKORDER = "pageWorkOrder";
    private static final String LIST_USERS = "users";
    private static final String LIST_CITIZENS = "citizenList";
    private static final String LIST_WORKORDER = "workOrderList";
    private static final String CURRENT_SPEC_LABEL = "currentSpec";
    private static final String TOTAL_CITIZENS_LABEL = "totalCitizens";
    private static final String UNEMP_CITIZENS_LABEL = "unemployedCitizens";
    private static final String BUILDERS_LABEL = "builders";
    private static final String DELIVERY_MAN_LABEL = "deliverymen";
    private static final String ASSIGNEE_LABEL = "assignee";
    private static final String WORK_LABEL = "work";
    private static final String HIDDEN_WORKORDER_ID = "hiddenId";
    private static final int HIDDEN_ID_POSITION = 5;
    private static final String TOWNHALL_RESOURCE_SUFFIX = ":gui/windowTownHall.xml";
    private static final String BUILDER_JOB = "com.minecolonies.coremod.job.Builder";
    private static final String DELIVERYMEN_JOB = "com.minecolonies.coremod.job.Deliveryman";
    private final List<WorkOrderView> workOrders = new ArrayList<WorkOrderView>();
    private final BuildingTownHall.View townHall;
    @NotNull
    private final List<Permissions.Player> users = new ArrayList<Permissions.Player>();
    @NotNull
    private final List<CitizenDataView> citizens = new ArrayList<CitizenDataView>();
    @NotNull
    private final Map<String, String> tabsToPages = new HashMap<String, String>();
    private Button lastTabButton;
    private ScrollingList userList;

    public WindowTownHall(BuildingTownHall.View townHall) {
        super(townHall, "minecolonies:gui/windowTownHall.xml");
        this.townHall = townHall;
        this.updateUsers();
        this.updateCitizens();
        this.updateWorkOrders();
        this.tabsToPages.put(BUTTON_ACTIONS, PAGE_ACTIONS);
        this.tabsToPages.put(BUTTON_INFO, PAGE_INFO);
        this.tabsToPages.put(BUTTON_SETTINGS, PAGE_SETTINGS);
        this.tabsToPages.put(BUTTON_PERMISSIONS, PAGE_PERMISSIONS);
        this.tabsToPages.put(BUTTON_CITIZENS, PAGE_CITIZENS);
        this.tabsToPages.put(BUTTON_WORKORDER, PAGE_WORKORDER);
        this.tabsToPages.keySet().forEach(key -> this.registerButton((String)key, this::onTabClicked));
        this.registerButton(BUTTON_ADD_PLAYER, this::addPlayerCLicked);
        this.registerButton(BUTTON_RENAME, this::renameClicked);
        this.registerButton(BUTTON_REMOVE_PLAYER, this::removePlayerClicked);
        this.registerButton(BUTTON_PROMOTE, this::promoteDemoteClicked);
        this.registerButton(BUTTON_DEMOTE, this::promoteDemoteClicked);
        this.registerButton(BUTTON_RECALL, this::recallClicked);
        this.registerButton(BUTTON_CHANGE_SPEC, this::doNothing);
        this.registerButton(BUTTON_TOGGLE_JOB, this::toggleHiring);
        this.registerButton(BUTTON_UP, this::updatePriority);
        this.registerButton(BUTTON_DOWN, this::updatePriority);
        this.registerButton(BUTTON_DELETE, this::deleteWorkOrder);
    }

    private void updateUsers() {
        this.users.clear();
        this.users.addAll(this.townHall.getColony().getPlayers().values());
        this.users.sort(Comparator.comparing(Permissions.Player::getRank, Enum::compareTo));
    }

    private void updateCitizens() {
        this.citizens.clear();
        this.citizens.addAll(this.townHall.getColony().getCitizens().values());
    }

    private void updateWorkOrders() {
        this.workOrders.clear();
        this.workOrders.addAll(this.townHall.getColony().getWorkOrders());
        this.workOrders.sort((first, second) -> second.getPriority() > first.getPriority() ? 1 : (second.getPriority() < first.getPriority() ? -1 : 0));
    }

    private void updatePriority(@NotNull Button button) {
        Label idLabel = (Label)button.getParent().getChildren().get(5);
        int id = Integer.parseInt(idLabel.getLabelText());
        String buttonLabel = button.getID();
        for (int i = 0; i < this.workOrders.size(); ++i) {
            WorkOrderView workOrder = this.workOrders.get(i);
            if (workOrder.getId() != id) continue;
            if (buttonLabel.equals(BUTTON_UP) && i > 0) {
                workOrder.setPriority(this.workOrders.get(i - 1).getPriority() + 1);
                MineColonies.getNetwork().sendToServer((IMessage)new WorkOrderChangeMessage(this.building, id, false, workOrder.getPriority()));
            } else if (buttonLabel.equals(BUTTON_DOWN) && i <= this.workOrders.size()) {
                workOrder.setPriority(this.workOrders.get(i + 1).getPriority() - 1);
                MineColonies.getNetwork().sendToServer((IMessage)new WorkOrderChangeMessage(this.building, id, false, workOrder.getPriority()));
            }
            this.workOrders.sort((first, second) -> second.getPriority() > first.getPriority() ? 1 : (second.getPriority() < first.getPriority() ? -1 : 0));
            this.window.findPaneOfTypeByID(LIST_WORKORDER, ScrollingList.class).refreshElementPanes();
            return;
        }
    }

    private void deleteWorkOrder(@NotNull Button button) {
        Label idLabel = (Label)button.getParent().getChildren().get(5);
        int id = Integer.parseInt(idLabel.getLabelText());
        for (int i = 0; i < this.workOrders.size(); ++i) {
            if (this.workOrders.get(i).getId() != id) continue;
            this.workOrders.remove(i);
            break;
        }
        MineColonies.getNetwork().sendToServer((IMessage)new WorkOrderChangeMessage(this.building, id, true, 0));
        this.window.findPaneOfTypeByID(LIST_WORKORDER, ScrollingList.class).refreshElementPanes();
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.createAndSetStatistics();
        this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).setView(PAGE_ACTIONS);
        this.lastTabButton = this.findPaneOfTypeByID(BUTTON_ACTIONS, Button.class);
        this.lastTabButton.setEnabled(false);
        this.fillUserList();
        this.fillCitizensList();
        this.fillWorkOrderList();
        if (this.townHall.getColony().isManualHiring()) {
            this.findPaneOfTypeByID(BUTTON_TOGGLE_JOB, Button.class).setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.on", new Object[0]));
        }
    }

    private void createAndSetStatistics() {
        int citizensSize = this.townHall.getColony().getCitizens().size();
        int workers = 0;
        int builders = 0;
        int deliverymen = 0;
        block10: for (CitizenDataView citizen : this.citizens) {
            switch (citizen.getJob()) {
                case "com.minecolonies.coremod.job.Builder": {
                    ++builders;
                    continue block10;
                }
                case "com.minecolonies.coremod.job.Deliveryman": {
                    ++deliverymen;
                    continue block10;
                }
                case "": {
                    continue block10;
                }
            }
            ++workers;
        }
        String numberOfCitizens = LanguageHandler.format("com.minecolonies.coremod.gui.townHall.population.totalCitizens", citizensSize, this.townHall.getColony().getMaxCitizens());
        String numberOfUnemployed = LanguageHandler.format("com.minecolonies.coremod.gui.townHall.population.unemployed", citizensSize - (workers += deliverymen + builders));
        String numberOfBuilders = LanguageHandler.format("com.minecolonies.coremod.gui.townHall.population.builders", builders);
        String numberOfDeliverymen = LanguageHandler.format("com.minecolonies.coremod.gui.townHall.population.deliverymen", deliverymen);
        this.findPaneOfTypeByID(CURRENT_SPEC_LABEL, Label.class).setLabelText("<Industrial>");
        this.findPaneOfTypeByID(TOTAL_CITIZENS_LABEL, Label.class).setLabelText(numberOfCitizens);
        this.findPaneOfTypeByID(UNEMP_CITIZENS_LABEL, Label.class).setLabelText(numberOfUnemployed);
        this.findPaneOfTypeByID(BUILDERS_LABEL, Label.class).setLabelText(numberOfBuilders);
        this.findPaneOfTypeByID(DELIVERY_MAN_LABEL, Label.class).setLabelText(numberOfDeliverymen);
    }

    private void fillUserList() {
        this.userList = this.findPaneOfTypeByID(LIST_USERS, ScrollingList.class);
        this.userList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowTownHall.this.users.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                Permissions.Player player = (Permissions.Player)WindowTownHall.this.users.get(index);
                String rank = player.getRank().name();
                rank = Character.toUpperCase(rank.charAt(0)) + rank.toLowerCase().substring(1);
                rowPane.findPaneOfTypeByID("name", Label.class).setLabelText(player.getName());
                rowPane.findPaneOfTypeByID("rank", Label.class).setLabelText(rank);
            }
        });
    }

    private void fillCitizensList() {
        ScrollingList citizenList = this.findPaneOfTypeByID(LIST_CITIZENS, ScrollingList.class);
        citizenList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowTownHall.this.citizens.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                CitizenDataView citizen = (CitizenDataView)WindowTownHall.this.citizens.get(index);
                rowPane.findPaneOfTypeByID("name", Label.class).setLabelText(citizen.getName());
            }
        });
    }

    private void fillWorkOrderList() {
        ScrollingList workOrderList = this.findPaneOfTypeByID(LIST_WORKORDER, ScrollingList.class);
        workOrderList.enable();
        workOrderList.show();
        workOrderList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowTownHall.this.workOrders.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                WorkOrderView workOrder = (WorkOrderView)WindowTownHall.this.workOrders.get(index);
                String claimingCitizen = "";
                if (index == 0) {
                    if (this.getElementCount() == 1) {
                        rowPane.findPaneOfTypeByID(WindowTownHall.BUTTON_DOWN, Button.class).hide();
                    } else {
                        rowPane.findPaneOfTypeByID(WindowTownHall.BUTTON_DOWN, Button.class).show();
                    }
                    rowPane.findPaneOfTypeByID(WindowTownHall.BUTTON_UP, Button.class).hide();
                } else if (index == this.getElementCount() - 1) {
                    rowPane.findPaneOfTypeByID(WindowTownHall.BUTTON_DOWN, Button.class).hide();
                }
                for (CitizenDataView citizen : WindowTownHall.this.citizens) {
                    if (citizen.getID() != workOrder.getClaimedBy()) continue;
                    claimingCitizen = citizen.getName();
                    break;
                }
                rowPane.findPaneOfTypeByID(WindowTownHall.WORK_LABEL, Label.class).setLabelText(workOrder.getValue());
                rowPane.findPaneOfTypeByID(WindowTownHall.ASSIGNEE_LABEL, Label.class).setLabelText(claimingCitizen);
                rowPane.findPaneOfTypeByID(WindowTownHall.HIDDEN_WORKORDER_ID, Label.class).setLabelText(Integer.toString(workOrder.getId()));
            }
        });
    }

    @Override
    public String getBuildingName() {
        return this.townHall.getColony().getName();
    }

    private void toggleHiring(@NotNull Button button) {
        boolean toggle;
        if (button.getLabel().equals(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.off", new Object[0]))) {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.on", new Object[0]));
            toggle = true;
        } else {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.off", new Object[0]));
            toggle = false;
        }
        MineColonies.getNetwork().sendToServer((IMessage)new ToggleJobMessage(((BuildingTownHall.View)this.building).getColony(), toggle));
    }

    private void onTabClicked(@NotNull Button button) {
        String page = this.tabsToPages.get(button.getID());
        this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).setView(page);
        this.lastTabButton.setEnabled(true);
        button.setEnabled(false);
        this.lastTabButton = button;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        String currentPage = this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).getCurrentView().getID();
        if (currentPage.equals(PAGE_PERMISSIONS)) {
            this.updateUsers();
            this.window.findPaneOfTypeByID(LIST_USERS, ScrollingList.class).refreshElementPanes();
        } else if (currentPage.equals(PAGE_CITIZENS)) {
            this.updateCitizens();
            this.window.findPaneOfTypeByID(LIST_CITIZENS, ScrollingList.class).refreshElementPanes();
        }
        this.updateWorkOrders();
        this.window.findPaneOfTypeByID(LIST_WORKORDER, ScrollingList.class).refreshElementPanes();
    }

    private void renameClicked() {
        WindowTownHallNameEntry window = new WindowTownHallNameEntry(this.townHall.getColony());
        window.open();
    }

    private void addPlayerCLicked() {
        TextField input = this.findPaneOfTypeByID(INPUT_ADDPLAYER_NAME, TextField.class);
        MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.AddPlayer(this.townHall.getColony(), input.getText()));
        input.setText("");
    }

    private void removePlayerClicked(Button button) {
        Permissions.Player user;
        int row = this.userList.getListElementIndexByPane(button);
        if (row >= 0 && row < this.users.size() && (user = this.users.get(row)).getRank() != Permissions.Rank.OWNER) {
            MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.RemovePlayer(this.townHall.getColony(), user.getID()));
        }
    }

    private void promoteDemoteClicked(@NotNull Button button) {
        int row = this.userList.getListElementIndexByPane(button);
        if (row >= 0 && row < this.users.size()) {
            Permissions.Player user = this.users.get(row);
            if (button.getID().equals(BUTTON_PROMOTE)) {
                MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.ChangePlayerRank(this.townHall.getColony(), user.getID(), PermissionsMessage.ChangePlayerRank.Type.PROMOTE));
            } else {
                MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.ChangePlayerRank(this.townHall.getColony(), user.getID(), PermissionsMessage.ChangePlayerRank.Type.DEMOTE));
            }
        }
    }

    private void recallClicked() {
        MineColonies.getNetwork().sendToServer((IMessage)new RecallTownhallMessage(this.townHall));
    }
}

