/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.client.gui.WindowHutMiner;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.entity.ai.citizen.miner.Level;
import com.minecolonies.coremod.entity.ai.item.handling.ItemStorage;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.Utils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingMiner
extends AbstractBuildingWorker {
    private static final int STACK_MAX_SIZE = 64;
    private static final String TAG_FLOOR_BLOCK = "floorBlock";
    private static final String TAG_FENCE_BLOCK = "fenceBlock";
    private static final String TAG_STARTING_LEVEL = "startingLevelShaft";
    private static final String TAG_LEVELS = "levels";
    private static final String TAG_CLEARED = "clearedShaft";
    private static final String TAG_SLOCATION = "shaftLocation";
    private static final String TAG_VECTORX = "vectorx";
    private static final String TAG_VECTORZ = "vectorz";
    private static final String TAG_CLOCATION = "cobblelocation";
    private static final String TAG_ACTIVE = "activeNodeint";
    private static final String TAG_CURRENT_LEVEL = "currentLevel";
    private static final String TAG_SN = "StartingNode";
    private static final String TAG_LLOCATION = "ladderlocation";
    private static final String TAG_LADDER = "found_ladder";
    private static final String TAG_SHAFT_BLOCK = "shaftBlock";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String MINER = "Miner";
    private static final IBlockState floorBlock = Blocks.field_150376_bx.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP);
    private static final int MAX_DEPTH_LEVEL_0 = 70;
    private static final int MAX_DEPTH_LEVEL_1 = 50;
    private static final int MAX_DEPTH_LEVEL_2 = 30;
    private static final int MAX_DEPTH_LEVEL_3 = 5;
    @NotNull
    private final List<Level> levels = new ArrayList<Level>();
    public boolean clearedShaft = false;
    private Block shaftBlock = Blocks.field_150344_f;
    private Block fenceBlock = Blocks.field_180407_aO;
    private int startingLevelShaft = 0;
    private BlockPos cobbleLocation;
    private int startingLevelNode = 0;
    private int active = 0;
    private int currentLevel = 0;
    private BlockPos shaftStart;
    private int vectorX = 1;
    private int vectorZ = 1;
    private BlockPos ladderLocation;
    private boolean foundLadder = false;
    private final Map<ItemStorage, Integer> keepX = new HashMap<ItemStorage, Integer>();

    public BuildingMiner(Colony c, BlockPos l) {
        super(c, l);
        ItemStack stackLadder = new ItemStack(Blocks.field_150468_ap);
        ItemStack stackFence = new ItemStack(Blocks.field_180407_aO);
        ItemStack stackTorch = new ItemStack(Blocks.field_150478_aa);
        ItemStack stackCobble = new ItemStack(Blocks.field_150347_e);
        ItemStack stackSlab = new ItemStack((Block)Blocks.field_150376_bx);
        ItemStack stackPlanks = new ItemStack(Blocks.field_150344_f);
        this.keepX.put(new ItemStorage(stackLadder.func_77973_b(), stackLadder.func_77952_i(), 0, false), 64);
        this.keepX.put(new ItemStorage(stackFence.func_77973_b(), stackFence.func_77952_i(), 0, false), 64);
        this.keepX.put(new ItemStorage(stackTorch.func_77973_b(), stackTorch.func_77952_i(), 0, false), 64);
        this.keepX.put(new ItemStorage(stackCobble.func_77973_b(), stackCobble.func_77952_i(), 0, false), 64);
        this.keepX.put(new ItemStorage(stackSlab.func_77973_b(), stackSlab.func_77952_i(), 0, false), 64);
        this.keepX.put(new ItemStorage(stackPlanks.func_77973_b(), stackPlanks.func_77952_i(), 0, false), 64);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return MINER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().triggerAchievement(ModAchievements.achievementBuildingMiner);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().triggerAchievement(ModAchievements.achievementUpgradeMinerMax);
        }
    }

    @Override
    @NotNull
    public String getJobName() {
        return MINER;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobMiner(citizen);
    }

    @Override
    public boolean neededForWorker(@Nullable ItemStack stack) {
        return Utils.isMiningTool(stack);
    }

    @Override
    public Map<ItemStorage, Integer> getRequiredItemsAndAmount() {
        return this.keepX;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.func_74764_b(TAG_FENCE_BLOCK)) {
            this.fenceBlock = Block.func_149684_b((String)compound.func_74779_i(TAG_FENCE_BLOCK));
        }
        if (compound.func_74764_b(TAG_SHAFT_BLOCK)) {
            this.shaftBlock = Block.func_149684_b((String)compound.func_74779_i(TAG_SHAFT_BLOCK));
        }
        this.startingLevelShaft = compound.func_74762_e(TAG_STARTING_LEVEL);
        this.clearedShaft = compound.func_74767_n(TAG_CLEARED);
        this.vectorX = compound.func_74762_e(TAG_VECTORX);
        this.vectorZ = compound.func_74762_e(TAG_VECTORZ);
        this.active = compound.func_74762_e(TAG_ACTIVE);
        this.currentLevel = compound.func_74762_e(TAG_CURRENT_LEVEL);
        this.ladderLocation = BlockPosUtil.readFromNBT(compound, TAG_LLOCATION);
        this.foundLadder = compound.func_74767_n(TAG_LADDER);
        this.shaftStart = BlockPosUtil.readFromNBT(compound, TAG_SLOCATION);
        this.cobbleLocation = BlockPosUtil.readFromNBT(compound, TAG_CLOCATION);
        this.startingLevelNode = compound.func_74762_e(TAG_SN);
        NBTTagList levelTagList = compound.func_150295_c(TAG_LEVELS, 10);
        for (int i = 0; i < levelTagList.func_74745_c(); ++i) {
            Level level = Level.createFromNBT(levelTagList.func_150305_b(i));
            this.levels.add(level);
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74778_a(TAG_FENCE_BLOCK, ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.fenceBlock)).toString());
        compound.func_74778_a(TAG_FLOOR_BLOCK, ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.shaftBlock)).toString());
        compound.func_74768_a(TAG_STARTING_LEVEL, this.startingLevelShaft);
        compound.func_74757_a(TAG_CLEARED, this.clearedShaft);
        compound.func_74768_a(TAG_VECTORX, this.vectorX);
        compound.func_74768_a(TAG_VECTORZ, this.vectorZ);
        compound.func_74768_a(TAG_ACTIVE, this.active);
        compound.func_74768_a(TAG_CURRENT_LEVEL, this.currentLevel);
        compound.func_74757_a(TAG_LADDER, this.foundLadder);
        compound.func_74768_a(TAG_SN, this.startingLevelNode);
        if (this.shaftStart != null && this.cobbleLocation != null) {
            BlockPosUtil.writeToNBT(compound, TAG_SLOCATION, this.shaftStart);
            BlockPosUtil.writeToNBT(compound, TAG_CLOCATION, this.cobbleLocation);
        }
        if (this.ladderLocation != null) {
            BlockPosUtil.writeToNBT(compound, TAG_LLOCATION, this.ladderLocation);
        }
        NBTTagList levelTagList = new NBTTagList();
        for (Level level : this.levels) {
            NBTTagCompound levelCompound = new NBTTagCompound();
            level.writeToNBT(levelCompound);
            levelTagList.func_74742_a((NBTBase)levelCompound);
        }
        compound.func_74782_a(TAG_LEVELS, (NBTBase)levelTagList);
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.currentLevel);
        buf.writeInt(this.levels.size());
        for (Level level : this.levels) {
            buf.writeInt(level.getNumberOfNodes());
        }
    }

    public void addLevel(Level currentLevel) {
        this.levels.add(currentLevel);
    }

    public int getNumberOfLevels() {
        return this.levels.size();
    }

    @Nullable
    public Level getCurrentLevel() {
        if (this.currentLevel >= 0 && this.currentLevel < this.levels.size()) {
            return this.levels.get(this.currentLevel);
        }
        return null;
    }

    public void setCurrentLevel(int currentLevel) {
        this.currentLevel = currentLevel;
    }

    public int getDepthLimit() {
        if (this.getBuildingLevel() == 1) {
            return 50;
        }
        if (this.getBuildingLevel() == 2) {
            return 30;
        }
        if (this.getBuildingLevel() >= 3) {
            return 5;
        }
        return 70;
    }

    public BlockPos getLadderLocation() {
        return this.ladderLocation;
    }

    public void setLadderLocation(BlockPos ladderLocation) {
        this.ladderLocation = ladderLocation;
    }

    public boolean hasFoundLadder() {
        return this.foundLadder;
    }

    public void setFoundLadder(boolean foundLadder) {
        this.foundLadder = foundLadder;
    }

    public int getVectorX() {
        return this.vectorX;
    }

    public void setVectorX(int vectorX) {
        this.vectorX = vectorX;
    }

    public int getVectorZ() {
        return this.vectorZ;
    }

    public void setVectorZ(int vectorZ) {
        this.vectorZ = vectorZ;
    }

    public BlockPos getCobbleLocation() {
        return this.cobbleLocation;
    }

    public void setCobbleLocation(BlockPos pos) {
        this.cobbleLocation = pos;
    }

    public void setShaftStart(BlockPos pos) {
        this.shaftStart = pos;
    }

    public int getStartingLevelShaft() {
        return this.startingLevelShaft;
    }

    public void resetStartingLevelShaft() {
        this.startingLevelShaft = 0;
    }

    public void incrementStartingLevelShaft() {
        ++this.startingLevelShaft;
    }

    public IBlockState getFloorBlock() {
        return floorBlock;
    }

    public Block getShaftBlock() {
        return this.shaftBlock;
    }

    public Block getFenceBlock() {
        return this.fenceBlock;
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public int[] levels;
        public int current;

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutMiner(this);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            this.current = buf.readInt();
            int size = buf.readInt();
            this.levels = new int[size];
            for (int i = 0; i < size; ++i) {
                this.levels[i] = buf.readInt();
            }
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.STRENGTH;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.ENDURANCE;
        }
    }
}

