/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.coremod.colony.jobs.JobGuard;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.ai.citizen.guard.GuardArrow;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import org.jetbrains.annotations.NotNull;

public class EntityAIRangeGuard
extends AbstractEntityAIGuard
implements IRangedAttackMob {
    private static final int BASE_RELOAD_TIME = 60;
    private static final double BASE_POWER_ENCHANTMENT_DAMAGE = 0.5;
    private static final double POWER_ENCHANTMENT_DAMAGE_MULTIPLIER = 0.5;
    private static final double BASE_DAMAGE_MULTIPLIER = 2.0;
    private static final double RANDOM_DAMAGE_MULTPLIER = 0.25;
    private static final double DIFFICULTY_DAMAGE_INCREASE = 0.11;
    private static final int FIRE_EFFECT_CHANCE = 100;
    private static final double PITCH_DIVIDER = 1.0;
    private static final double BASE_PITCH = 0.8;
    private static final double PITCH_MULTIPLIER = 0.4;
    private static final double MOVE_MINIMAL = 0.01;
    private static final double TURN_AROUND = 180.0;
    private static final double AIM_SLIGHTLY_HIGHER_MULTIPLIER = (double)0.2f;
    private static final double BASIC_VOLUME = 1.0;
    private static final double AIM_HEIGHT = 3.0;
    private static final double XP_EACH_ARROW = 0.2;
    private static final double HIT_CHANCE_DIVIDER = 15.0;
    private static final double ARROW_SPEED = 1.6;
    private static final int BASE_FOLLOW_SPEED = 1;
    private static final double BASE_FOLLOW_SPEED_MULTIPLIER = 0.25;
    private static final double MAX_ATTACK_DISTANCE = 20.0;
    private static final int DAMAGE_PER_ATTACK = 2;
    private static final int MOVE_CLOSE = 3;

    public EntityAIRangeGuard(@NotNull JobGuard job) {
        super(job);
        super.registerTargets(new AITarget(AIState.GUARD_SEARCH_TARGET, this::searchTarget), new AITarget(AIState.GUARD_GET_TARGET, this::getTarget), new AITarget(AIState.GUARD_HUNT_DOWN_TARGET, this::huntDown), new AITarget(AIState.GUARD_PATROL, this::patrol), new AITarget(AIState.GUARD_RESTOCK, this::goToBuilding));
        if (this.worker.getCitizenData() != null) {
            this.worker.setSkillModifier(2 * this.worker.getCitizenData().getIntelligence() + this.worker.getCitizenData().getStrength());
            this.worker.func_98053_h(true);
        }
    }

    @Override
    protected AIState searchTarget() {
        if (this.checkOrRequestItems(false, new ItemStack((Item)Items.field_151031_f))) {
            return AIState.GUARD_SEARCH_TARGET;
        }
        this.worker.setHeldItem(this.worker.findFirstSlotInInventoryWith((Item)Items.field_151031_f, -1));
        return super.searchTarget();
    }

    protected AIState huntDown() {
        if (!this.targetEntity.func_70089_S() || this.checkOrRequestItems(false, new ItemStack((Item)Items.field_151031_f))) {
            this.targetEntity = null;
            this.worker.func_70659_e(1.0f);
            return AIState.GUARD_GATHERING;
        }
        if (this.worker.func_70635_at().func_75522_a((Entity)this.targetEntity) && (double)this.worker.func_70032_d((Entity)this.targetEntity) <= 20.0) {
            this.worker.func_184602_cy();
            this.func_82196_d(this.targetEntity, 2.0f);
            this.setDelay(this.getReloadTime());
            ++this.attacksExecuted;
            if (this.attacksExecuted >= this.getMaxAttacksUntilRestock()) {
                return AIState.GUARD_RESTOCK;
            }
            return AIState.GUARD_HUNT_DOWN_TARGET;
        }
        if (this.shouldReturnToTarget(this.targetEntity.func_180425_c(), 30.0)) {
            return AIState.GUARD_PATROL;
        }
        this.worker.func_70659_e((float)(1.0 + 0.25 * (double)this.worker.getExperienceLevel()));
        this.worker.isWorkerAtSiteWithMove(this.targetEntity.func_180425_c(), 3);
        return AIState.GUARD_SEARCH_TARGET;
    }

    public void func_82196_d(@NotNull EntityLivingBase entityToAttack, float baseDamage) {
        GuardArrow arrowEntity = new GuardArrow(this.worker.field_70170_p, this.worker);
        double xVector = entityToAttack.field_70165_t - this.worker.field_70165_t;
        double yVector = entityToAttack.func_174813_aQ().field_72338_b + (double)entityToAttack.field_70131_O / 3.0 - arrowEntity.field_70163_u;
        double zVector = entityToAttack.field_70161_v - this.worker.field_70161_v;
        double distance = MathHelper.func_76133_a((double)(xVector * xVector + zVector * zVector));
        double damage = baseDamage;
        double chance = 15.0 / (double)(this.worker.getExperienceLevel() + 1);
        arrowEntity.func_70186_c(xVector, yVector + distance * (double)0.2f, zVector, 1.6f, (float)chance);
        if (this.worker.func_110143_aJ() <= 2.0f) {
            damage *= 2.0;
        }
        this.addEffectsToArrow(arrowEntity, damage);
        this.worker.addExperience(0.2);
        this.worker.func_70625_a((Entity)entityToAttack, 180.0f, 180.0f);
        this.worker.func_70671_ap().func_75651_a((Entity)entityToAttack, 180.0f, 180.0f);
        double xDiff = this.targetEntity.field_70165_t - this.worker.field_70165_t;
        double zDiff = this.targetEntity.field_70161_v - this.worker.field_70161_v;
        double goToX = xDiff > 0.0 ? 0.01 : -0.01;
        double goToZ = zDiff > 0.0 ? 0.01 : -0.01;
        this.worker.func_70091_d(goToX, 0.0, goToZ);
        this.worker.func_184609_a(EnumHand.MAIN_HAND);
        this.worker.func_184185_a(SoundEvents.field_187866_fi, 1.0f, (float)this.getRandomPitch());
        this.worker.field_70170_p.func_72838_d((Entity)arrowEntity);
        this.worker.damageItemInHand(1);
    }

    private int getReloadTime() {
        return 60 / (this.worker.getExperienceLevel() + 1);
    }

    private void addEffectsToArrow(EntityTippedArrow arrowEntity, double baseDamage) {
        ItemStack holdItem;
        int powerEntchantment = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, (EntityLivingBase)this.worker);
        int punchEntchantment = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (EntityLivingBase)this.worker);
        DifficultyInstance difficulty = this.worker.field_70170_p.func_175649_E(new BlockPos((Entity)this.worker));
        arrowEntity.func_70239_b(baseDamage * 2.0 + this.worker.getRandom().nextGaussian() * 0.25 + (double)this.worker.field_70170_p.func_175659_aa().func_151525_a() * 0.11);
        if (powerEntchantment > 0) {
            arrowEntity.func_70239_b(arrowEntity.func_70242_d() + (double)powerEntchantment * 0.5 + 0.5);
        }
        if (punchEntchantment > 0) {
            arrowEntity.func_70240_a(punchEntchantment);
        }
        boolean onFire = this.worker.func_70027_ad() && difficulty.func_190083_c() && this.worker.getRandom().nextBoolean();
        boolean bl = onFire = onFire || EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185311_w, (EntityLivingBase)this.worker) > 0;
        if (onFire) {
            arrowEntity.func_70015_d(100);
        }
        if ((holdItem = this.worker.func_184586_b(EnumHand.OFF_HAND)) != null && holdItem.func_77973_b() == Items.field_185167_i) {
            arrowEntity.func_184555_a(holdItem);
        }
    }

    private double getRandomPitch() {
        return 1.0 / (this.worker.func_70681_au().nextDouble() * 0.4 + 0.8);
    }
}

