/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding;

import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.pathfinding.AbstractPathJob;
import com.minecolonies.coremod.entity.pathfinding.PathJobFindTree;
import com.minecolonies.coremod.entity.pathfinding.PathJobFindWater;
import com.minecolonies.coremod.entity.pathfinding.PathJobMoveAwayFromLocation;
import com.minecolonies.coremod.entity.pathfinding.PathJobMoveToLocation;
import com.minecolonies.coremod.entity.pathfinding.PathPointExtended;
import com.minecolonies.coremod.entity.pathfinding.PathResult;
import com.minecolonies.coremod.entity.pathfinding.Pathfinding;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.BlockUtils;
import com.minecolonies.coremod.util.Log;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathNavigate
extends PathNavigateGround {
    public static final double MAX_PATHING_LENGTH = 36.0;
    public static final double PATHING_INTERMEDIARY_LENGTH = 16.0;
    private final EntityLiving entity;
    private double walkSpeed;
    @Nullable
    private BlockPos destination;
    @Nullable
    private BlockPos originalDestination;
    @Nullable
    private Future<Path> future;
    @Nullable
    private PathResult pathResult;

    public PathNavigate(@NotNull EntityLiving entity, World world) {
        super(entity, world);
        this.entity = entity;
        this.field_179695_a = new WalkNodeProcessor();
    }

    @Nullable
    protected PathFinder func_179679_a() {
        return null;
    }

    protected boolean func_75485_k() {
        return true;
    }

    protected Vec3d func_75502_i() {
        return this.entity.func_174791_d();
    }

    public BlockPos getDestination() {
        return this.destination;
    }

    @Nullable
    public Path func_179680_a(BlockPos pos) {
        return null;
    }

    public double getSpeed() {
        return this.walkSpeed;
    }

    public void func_75489_a(double d) {
        this.walkSpeed = d;
    }

    public boolean func_75492_a(double x, double y, double z, double speed) {
        this.moveToXYZ(x, y, z, speed);
        return true;
    }

    public boolean func_75497_a(@NotNull Entity e, double speed) {
        return this.func_75492_a(e.field_70165_t, e.field_70163_u, e.field_70161_v, speed);
    }

    @Nullable
    public PathResult moveToXYZ(double x, double y, double z, double speed) {
        int newX = MathHelper.func_76128_c((double)x);
        int newY = (int)y;
        int newZ = MathHelper.func_76128_c((double)z);
        if (this.destination != null && BlockPosUtil.isEqual(this.destination, newX, newY, newZ) || this.originalDestination != null && BlockPosUtil.isEqual(this.originalDestination, newX, newY, newZ) && this.pathResult != null && this.pathResult.isInProgress()) {
            return this.pathResult;
        }
        Vec3d moveVector = this.func_75502_i().func_72444_a(new Vec3d((double)newX, (double)newY, (double)newZ));
        double moveLength = moveVector.func_72433_c();
        if (moveLength >= 36.0 && !this.isUnableToReachDestination()) {
            Vec3d newMove = moveVector.func_186678_a(16.0 / moveLength).func_178787_e(this.func_75502_i());
            this.originalDestination = new BlockPos(newX, newY, newZ);
            newX = MathHelper.func_76128_c((double)newMove.field_72450_a);
            newY = MathHelper.func_76128_c((double)newMove.field_72448_b);
            newZ = MathHelper.func_76128_c((double)newMove.field_72449_c);
        }
        BlockPos start = AbstractPathJob.prepareStart(this.entity);
        BlockPos dest = new BlockPos(newX, newY, newZ);
        return this.setPathJob(new PathJobMoveToLocation(this.entity.field_70170_p, start, dest, (int)this.func_111269_d()), dest, speed);
    }

    public boolean isUnableToReachDestination() {
        return this.pathResult != null && this.pathResult.failedToReachDestination();
    }

    @Nullable
    private PathResult setPathJob(@NotNull AbstractPathJob job, BlockPos dest, double speed) {
        this.func_75499_g();
        this.destination = dest;
        this.walkSpeed = speed;
        this.future = Pathfinding.enqueue(job);
        this.pathResult = job.getResult();
        return this.pathResult;
    }

    public boolean func_75484_a(@NotNull Path path, double speed) {
        int pathLength = path.func_75874_d();
        Path tempPath = null;
        if (pathLength > 0 && !(path.func_75877_a(0) instanceof PathPointExtended)) {
            PathPoint[] newPoints = new PathPointExtended[pathLength];
            for (int i = 0; i < pathLength; ++i) {
                PathPoint point = path.func_75877_a(i);
                newPoints[i] = new PathPointExtended(new BlockPos(point.field_75839_a, point.field_75837_b, point.field_75838_c));
            }
            tempPath = new Path(newPoints);
            PathPoint finalPoint = newPoints[pathLength - 1];
            this.destination = new BlockPos(finalPoint.field_75839_a, finalPoint.field_75837_b, finalPoint.field_75838_c);
        }
        return super.func_75484_a(tempPath == null ? path : tempPath, speed);
    }

    public void func_75501_e() {
        if (this.future != null) {
            if (!this.future.isDone()) {
                return;
            }
            try {
                if (this.future.get() == null) {
                    this.future = null;
                    return;
                }
                this.func_75484_a(this.future.get(), this.walkSpeed);
                this.pathResult.setPathLength(this.func_75505_d().func_75874_d());
                this.pathResult.setStatus(PathResult.Status.IN_PROGRESS_FOLLOWING);
                PathPoint p = this.func_75505_d().func_75870_c();
                if (p != null && this.destination == null) {
                    this.destination = new BlockPos(p.field_75839_a, p.field_75837_b, p.field_75838_c);
                    this.pathResult.setPathReachesDestination(true);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                Log.getLogger().catching((Throwable)e);
            }
            this.future = null;
        }
        int oldIndex = this.func_75500_f() ? 0 : this.func_75505_d().func_75873_e();
        super.func_75501_e();
        if (!this.func_75500_f()) {
            PathPointExtended pEx = (PathPointExtended)this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e());
            if (pEx.isOnLadder()) {
                Vec3d vec3 = this.func_75505_d().func_75878_a((Entity)this.entity);
                if (vec3.func_186679_c(this.entity.field_70165_t, vec3.field_72448_b, this.entity.field_70161_v) < 0.1) {
                    double newSpeed = 0.05;
                    switch (pEx.getLadderFacing()) {
                        case NORTH: {
                            vec3.func_72441_c(0.0, 0.0, 1.0);
                            break;
                        }
                        case SOUTH: {
                            vec3.func_72441_c(0.0, 0.0, -1.0);
                            break;
                        }
                        case WEST: {
                            vec3.func_72441_c(1.0, 0.0, 0.0);
                            break;
                        }
                        case EAST: {
                            vec3.func_72441_c(-1.0, 0.0, 0.0);
                            break;
                        }
                        default: {
                            newSpeed = 0.0;
                        }
                    }
                    this.entity.func_70605_aq().func_75642_a(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, newSpeed);
                }
            } else if (this.entity.func_70090_H()) {
                int curIndex = this.func_75505_d().func_75873_e();
                if (curIndex > 0 && curIndex + 1 < this.func_75505_d().func_75874_d() && this.func_75505_d().func_75877_a((int)(curIndex - 1)).field_75837_b != pEx.field_75837_b) {
                    oldIndex = curIndex + 1;
                }
                this.func_75505_d().func_75872_c(oldIndex);
                Vec3d Vec3d2 = this.func_75505_d().func_75878_a((Entity)this.entity);
                Vec3d vec3d = new Vec3d(this.entity.field_70165_t, Vec3d2.field_72448_b, this.entity.field_70161_v);
                if (Vec3d2.func_72436_e(vec3d) < 0.1 && Math.abs(this.entity.field_70163_u - Vec3d2.field_72448_b) < 0.5) {
                    this.func_75505_d().func_75872_c(this.func_75505_d().func_75873_e() + 1);
                    if (this.func_75500_f()) {
                        return;
                    }
                    Vec3d2 = this.func_75505_d().func_75878_a((Entity)this.entity);
                }
                this.entity.func_70605_aq().func_75642_a(Vec3d2.field_72450_a, Vec3d2.field_72448_b, Vec3d2.field_72449_c, this.walkSpeed);
            } else {
                this.field_75511_d = BlockUtils.isPathBlock(this.field_75513_b.func_180495_p(this.entity.func_180425_c().func_177977_b()).func_177230_c()) ? 1.3 : 1.0;
            }
        }
        if (this.pathResult != null && this.func_75500_f()) {
            this.pathResult.setStatus(PathResult.Status.COMPLETE);
            this.pathResult = null;
        }
    }

    protected void func_75508_h() {
        int curNode = this.field_75514_c.func_75873_e();
        int curNodeNext = curNode + 1;
        if (curNodeNext < this.field_75514_c.func_75874_d()) {
            PathPointExtended pEx = (PathPointExtended)this.field_75514_c.func_75877_a(curNode);
            PathPointExtended pExNext = (PathPointExtended)this.field_75514_c.func_75877_a(curNodeNext);
            if (pEx.isOnLadder() && pEx.getLadderFacing() == EnumFacing.DOWN && !pExNext.isOnLadder()) {
                Vec3d vec3 = this.func_75502_i();
                if (vec3.field_72448_b - (double)pEx.field_75837_b < 0.001) {
                    this.field_75514_c.func_75872_c(curNodeNext);
                }
                this.func_179677_a(vec3);
                return;
            }
        }
        super.func_75508_h();
    }

    public boolean func_75500_f() {
        return this.future == null && super.func_75500_f();
    }

    public void func_75499_g() {
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
        if (this.pathResult != null) {
            this.pathResult.setStatus(PathResult.Status.CANCELLED);
            this.pathResult = null;
        }
        this.destination = null;
        super.func_75499_g();
    }

    public PathJobFindTree.TreePathResult moveToTree(int range, double speed) {
        BlockPos start = AbstractPathJob.prepareStart(this.entity);
        return (PathJobFindTree.TreePathResult)this.setPathJob(new PathJobFindTree(this.entity.field_70170_p, start, ((EntityCitizen)this.entity).getWorkBuilding().getLocation(), range), null, speed);
    }

    @Nullable
    public PathJobFindWater.WaterPathResult moveToWater(int range, double speed, List<BlockPos> ponds) {
        BlockPos start = AbstractPathJob.prepareStart(this.entity);
        return (PathJobFindWater.WaterPathResult)this.setPathJob(new PathJobFindWater(this.entity.field_70170_p, start, ((EntityCitizen)this.entity).getWorkBuilding().getLocation(), range, ponds), null, speed);
    }

    @Nullable
    public PathResult moveToEntityLiving(@NotNull Entity e, double speed) {
        return this.moveToXYZ(e.field_70165_t, e.field_70163_u, e.field_70161_v, speed);
    }

    @Nullable
    public PathResult moveAwayFromEntityLiving(@NotNull Entity e, double distance, double speed) {
        return this.moveAwayFromXYZ(e.func_180425_c(), distance, speed);
    }

    @Nullable
    public PathResult moveAwayFromXYZ(BlockPos avoid, double range, double speed) {
        BlockPos start = AbstractPathJob.prepareStart(this.entity);
        return this.setPathJob(new PathJobMoveAwayFromLocation(this.entity.field_70170_p, start, avoid, (int)range, (int)this.func_111269_d()), null, speed);
    }
}

